/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Vector;
import org.eigenbase.xom.AssertFailure;
import org.eigenbase.xom.XMLAttrVector;
import org.eigenbase.xom.XMLUtil;
import org.eigenbase.xom.XOMUtil;

public class XMLOutput {
    private PrintWriter out;
    private Vector tagStack;
    private int indent;
    private int tagsWritten;
    private boolean compact;
    private String indentString = "\t";
    private boolean glob;
    private boolean inTag;
    private boolean alwaysQuoteCData;
    private boolean ignorePcdata;

    private void displayIndent(PrintWriter out, int indent) {
        if (!this.compact) {
            for (int i = 0; i < indent; ++i) {
                out.print(this.indentString);
            }
        }
    }

    public XMLOutput(Writer out) {
        this.out = new PrintWriter(out, true);
        this.indent = 0;
        this.tagsWritten = 0;
        this.tagStack = new Vector();
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public boolean getCompact() {
        return this.compact;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public void setGlob(boolean glob) {
        this.glob = glob;
    }

    public void setAlwaysQuoteCData(boolean alwaysQuoteCData) {
        this.alwaysQuoteCData = alwaysQuoteCData;
    }

    public void setIgnorePcdata(boolean ignorePcdata) {
        this.ignorePcdata = ignorePcdata;
    }

    public boolean getIgnorePcdata() {
        return this.ignorePcdata;
    }

    public void print(String s) {
        this.out.print(s);
    }

    public void beginTag(String tagName, XMLAttrVector attributes) {
        this.beginBeginTag(tagName);
        if (attributes != null) {
            attributes.display(this.out, this.indent);
        }
        this.endBeginTag(tagName);
    }

    public void beginBeginTag(String tagName) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        this.displayIndent(this.out, this.indent);
        this.out.print("<");
        this.out.print(tagName);
    }

    public void endBeginTag(String tagName) {
        if (this.glob) {
            this.inTag = true;
        } else if (this.compact) {
            this.out.print(">");
        } else {
            this.out.println(">");
        }
        this.out.flush();
        this.tagStack.addElement(tagName);
        ++this.indent;
        ++this.tagsWritten;
    }

    public void attribute(String name, String value) {
        XMLUtil.printAtt(this.out, name, value);
    }

    public void beginNode() {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
    }

    public void endTag(String tagName) {
        int stackSize = this.tagStack.size();
        String matchTag = (String)this.tagStack.elementAt(stackSize - 1);
        if (!tagName.equalsIgnoreCase(matchTag)) {
            throw new AssertFailure("End tag <" + tagName + "> does not match  start tag <" + matchTag + ">");
        }
        this.tagStack.removeElementAt(stackSize - 1);
        --this.indent;
        if (this.inTag) {
            if (this.compact) {
                this.out.print("/>");
            } else {
                this.out.println("/>");
            }
            this.inTag = false;
        } else {
            this.displayIndent(this.out, this.indent);
            this.out.print("</");
            this.out.print(tagName);
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
        }
        this.out.flush();
    }

    public void emptyTag(String tagName, XMLAttrVector attributes) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        this.displayIndent(this.out, this.indent);
        this.out.print("<");
        this.out.print(tagName);
        if (attributes != null) {
            this.out.print(" ");
            attributes.display(this.out, this.indent);
        }
        if (this.compact) {
            this.out.print("/>");
        } else {
            this.out.println("/>");
        }
        this.out.flush();
        ++this.tagsWritten;
    }

    public void cdata(String data) {
        this.cdata(data, false);
    }

    public void cdata(String data, boolean quote) {
        if (this.inTag) {
            if (this.compact) {
                this.out.print(">");
            } else {
                this.out.println(">");
            }
            this.inTag = false;
        }
        if (data == null) {
            data = "";
        }
        boolean specials = false;
        boolean cdataEnd = false;
        if (XOMUtil.stringHasXMLSpecials(data)) {
            specials = true;
            if (data.indexOf("]]>") > -1) {
                cdataEnd = true;
            }
        }
        this.displayIndent(this.out, this.indent);
        if (quote || this.alwaysQuoteCData) {
            this.out.print("<![CDATA[");
            this.out.print(data);
            this.out.println("]]>");
        } else if (!specials && !cdataEnd) {
            this.out.print(data);
        } else {
            XMLUtil.stringEncodeXML(data, this.out);
        }
        this.out.flush();
        ++this.tagsWritten;
    }

    public void stringTag(String name, String data) {
        this.beginTag(name, null);
        this.cdata(data);
        this.endTag(name);
    }

    public void content(String content) {
        if (content != null) {
            ++this.indent;
            LineNumberReader in = new LineNumberReader(new StringReader(content));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    this.displayIndent(this.out, this.indent);
                    this.out.println(line);
                }
            }
            catch (IOException ex) {
                throw new AssertFailure(ex);
            }
            --this.indent;
            this.out.flush();
        }
        ++this.tagsWritten;
    }

    public void header() {
        this.out.println("<?xml version=\"1.0\" ?>");
        this.out.flush();
        ++this.tagsWritten;
    }

    public void header(String version) {
        this.out.print("<?xml version=\"");
        this.out.print(version);
        this.out.println("\" ?>");
        this.out.flush();
        ++this.tagsWritten;
    }

    public int numTagsWritten() {
        return this.tagsWritten;
    }
}

