/*
 * Decompiled with CFR 0.152.
 */
package checkers.basetype;

import checkers.basetype.BaseTypeChecker;
import checkers.compilermsgs.quals.CompilerMessageKey;
import checkers.nullness.quals.Nullable;
import checkers.quals.Unused;
import checkers.source.Result;
import checkers.source.SourceVisitor;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.AnnotatedTypes;
import checkers.types.QualifierHierarchy;
import checkers.types.VisitorState;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.util.AnnotationUtils;
import checkers.util.ElementUtils;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTypeVisitor<R, P>
extends SourceVisitor<R, P> {
    protected final BaseTypeChecker checker;
    protected final AnnotationUtils annoFactory;
    protected final Map<String, String> options;
    private final SourcePositions positions;
    protected final AnnotatedTypes annoTypes;
    protected final VisitorState visitorState;
    protected final AnnotatedTypeFactory plainFactory;
    private final AnnotatedTypeMirror.AnnotatedDeclaredType vectorType;
    private AnnotatedTypeScanner<Void, Tree> typeValidator;
    private static boolean checkedJDK = false;

    public BaseTypeVisitor(BaseTypeChecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.vectorType = this.atypeFactory.fromElement(this.elements.getTypeElement("java.util.Vector"));
        this.typeValidator = this.createTypeValidator();
        this.checker = checker;
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        this.annoFactory = AnnotationUtils.getInstance(env);
        this.options = env.getOptions();
        this.positions = this.trees.getSourcePositions();
        this.annoTypes = new AnnotatedTypes(checker.getProcessingEnvironment(), this.atypeFactory);
        this.visitorState = this.atypeFactory.getVisitorState();
        this.plainFactory = new AnnotatedTypeFactory(checker.getProcessingEnvironment(), null, root, null);
    }

    @Override
    public R scan(Tree tree, P p) {
        if (tree != null && this.getCurrentPath() != null) {
            this.visitorState.setPath(new TreePath(this.getCurrentPath(), tree));
        }
        return super.scan(tree, p);
    }

    private boolean hasExplicitConstructor(ClassTree node) {
        TypeElement elem = TreeUtils.elementFromDeclaration(node);
        for (ExecutableElement ee : ElementFilter.constructorsIn(elem.getEnclosedElements())) {
            Symbol.MethodSymbol ms = (Symbol.MethodSymbol)ee;
            long mod = ms.flags();
            if ((mod & 0x1000L) != 0L) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitClass(ClassTree node, P p) {
        AnnotatedTypeMirror.AnnotatedDeclaredType preACT = this.visitorState.getClassType();
        ClassTree preCT = this.visitorState.getClassTree();
        AnnotatedTypeMirror.AnnotatedDeclaredType preAMT = this.visitorState.getMethodReceiver();
        MethodTree preMT = this.visitorState.getMethodTree();
        this.visitorState.setClassType(this.atypeFactory.getAnnotatedType(node));
        this.visitorState.setClassTree(node);
        this.visitorState.setMethodReceiver(null);
        this.visitorState.setMethodTree(null);
        try {
            if (!this.hasExplicitConstructor(node)) {
                this.checkDefaultConstructor(node);
            }
            Object r = super.visitClass(node, p);
            return r;
        }
        finally {
            this.visitorState.setClassType(preACT);
            this.visitorState.setClassTree(preCT);
            this.visitorState.setMethodReceiver(preAMT);
            this.visitorState.setMethodTree(preMT);
        }
    }

    protected void checkDefaultConstructor(ClassTree node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R visitMethod(MethodTree node, P p) {
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.getAnnotatedType(node);
        AnnotatedTypeMirror.AnnotatedDeclaredType preMRT = this.visitorState.getMethodReceiver();
        MethodTree preMT = this.visitorState.getMethodTree();
        this.visitorState.setMethodReceiver(methodType.getReceiverType());
        this.visitorState.setMethodTree(node);
        try {
            Element elt = InternalUtils.symbol(node);
            assert (elt != null) : "no symbol for method";
            if (InternalUtils.isAnonymousConstructor(node)) {
                R r = null;
                return r;
            }
            if (node.getReturnType() != null) {
                this.typeValidator.visit(methodType.getReturnType(), node.getReturnType());
            }
            ExecutableElement methodElement = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.getAnnotatedType(methodElement.getEnclosingElement());
            Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods = this.annoTypes.overriddenMethods(methodElement);
            for (Map.Entry<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> pair : overriddenMethods.entrySet()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType = pair.getKey();
                AnnotatedTypeMirror.AnnotatedExecutableType overriddenMethod = this.annoTypes.asMemberOf((AnnotatedTypeMirror)overriddenType, pair.getValue());
                this.checkOverride(node, enclosingType, overriddenMethod, overriddenType, p);
            }
            Object r = super.visitMethod(node, p);
            return r;
        }
        finally {
            this.visitorState.setMethodReceiver(preMRT);
            this.visitorState.setMethodTree(preMT);
        }
    }

    @Override
    public R visitVariable(VariableTree node, P p) {
        this.validateTypeOf(node);
        if (node.getInitializer() != null) {
            this.commonAssignmentCheck(node, node.getInitializer(), "assignment.type.incompatible", p);
        }
        return super.visitVariable(node, p);
    }

    @Override
    public R visitAssignment(AssignmentTree node, P p) {
        this.commonAssignmentCheck(node.getVariable(), node.getExpression(), "assignment.type.incompatible", p);
        return super.visitAssignment(node, p);
    }

    @Override
    public R visitEnhancedForLoop(EnhancedForLoopTree node, P p) {
        AnnotatedTypeMirror var = this.atypeFactory.getAnnotatedType(node.getVariable());
        AnnotatedTypeMirror iterableType = this.atypeFactory.getAnnotatedType(node.getExpression());
        AnnotatedTypeMirror iteratedType = this.annoTypes.getIteratedType(iterableType);
        this.validateTypeOf(node.getVariable());
        this.commonAssignmentCheck(var, iteratedType, node.getExpression(), "enhancedfor.type.incompatible", p);
        return super.visitEnhancedForLoop(node, p);
    }

    private boolean isSuperInvocation(MethodInvocationTree node) {
        return node.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)node.getMethodSelect()).getName().contentEquals("super");
    }

    @Override
    public R visitMethodInvocation(MethodInvocationTree node, P p) {
        if (this.isEnumSuper(node)) {
            return super.visitMethodInvocation(node, p);
        }
        if (this.shouldSkip(node)) {
            return super.visitMethodInvocation(node, p);
        }
        AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod = this.atypeFactory.methodFromUse(node);
        LinkedList<AnnotatedTypeMirror> typeargs = new LinkedList<AnnotatedTypeMirror>();
        for (Tree tree : node.getTypeArguments()) {
            typeargs.add(this.atypeFactory.getAnnotatedTypeFromTypeTree(tree));
        }
        this.checkTypeArguments(invokedMethod.getTypeVariables(), typeargs, node.getTypeArguments(), p);
        List<AnnotatedTypeMirror> params = this.annoTypes.expandVarArgs(invokedMethod, node.getArguments());
        this.checkArguments(params, node.getArguments(), p);
        if (this.isVectorCopyInto(invokedMethod)) {
            this.typeCheckVectorCopyIntoArgument(node, params);
        }
        if (!ElementUtils.isStatic(invokedMethod.getElement()) && !this.isSuperInvocation(node)) {
            this.checkMethodInvocability(invokedMethod, node);
        }
        return super.visitMethodInvocation(node, p);
    }

    protected boolean isVectorCopyInto(AnnotatedTypeMirror.AnnotatedExecutableType method) {
        ExecutableElement elt = method.getElement();
        return elt.getSimpleName().contentEquals("copyInto") && elt.getParameters().size() == 1;
    }

    protected void typeCheckVectorCopyIntoArgument(MethodInvocationTree node, List<? extends AnnotatedTypeMirror> params) {
        assert (params.size() == 1);
        assert (node.getArguments().size() == 1);
        AnnotatedTypeMirror passed = this.atypeFactory.getAnnotatedType(node.getArguments().get(0));
        AnnotatedTypeMirror.AnnotatedArrayType passedAsArray = (AnnotatedTypeMirror.AnnotatedArrayType)passed;
        AnnotatedTypeMirror receiver = this.atypeFactory.getReceiver(node);
        AnnotatedTypeMirror.AnnotatedDeclaredType receiverAsVector = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.annoTypes.asSuper(receiver, this.vectorType);
        if (receiverAsVector == null || receiverAsVector.getTypeArguments().isEmpty()) {
            return;
        }
        this.commonAssignmentCheck(passedAsArray.getComponentType(), receiverAsVector.getTypeArguments().get(0), node.getArguments().get(0), "vector.copyinto.type.incompatible", null);
    }

    @Override
    public R visitNewClass(NewClassTree node, P p) {
        if (this.shouldSkip(InternalUtils.constructor(node))) {
            return super.visitNewClass(node, p);
        }
        AnnotatedTypeMirror.AnnotatedExecutableType constructor = this.atypeFactory.constructorFromUse(node);
        List<? extends ExpressionTree> passedArguments = node.getArguments();
        List<AnnotatedTypeMirror> params = this.annoTypes.expandVarArgs(constructor, passedArguments);
        this.checkArguments(params, passedArguments, p);
        AnnotatedTypeMirror.AnnotatedExecutableType type = this.atypeFactory.getAnnotatedType(InternalUtils.constructor(node));
        LinkedList<AnnotatedTypeMirror> typeargs = new LinkedList<AnnotatedTypeMirror>();
        for (Tree tree : node.getTypeArguments()) {
            typeargs.add(this.atypeFactory.getAnnotatedTypeFromTypeTree(tree));
        }
        this.checkTypeArguments(type.getTypeVariables(), typeargs, node.getTypeArguments(), p);
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = this.atypeFactory.getAnnotatedType(node);
        this.checkConstructorInvocation(dt, constructor, node);
        this.validateTypeOf(node);
        return super.visitNewClass(node, p);
    }

    @Override
    public R visitReturn(ReturnTree node, P p) {
        if (node.getExpression() == null) {
            return super.visitReturn(node, p);
        }
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getCurrentPath());
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.getAnnotatedType(enclosingMethod);
        this.commonAssignmentCheck(methodType.getReturnType(), node.getExpression(), "return.type.incompatible", p);
        return super.visitReturn(node, p);
    }

    @Override
    public R visitUnary(UnaryTree node, P p) {
        if (node.getKind() == Tree.Kind.PREFIX_DECREMENT || node.getKind() == Tree.Kind.PREFIX_INCREMENT || node.getKind() == Tree.Kind.POSTFIX_DECREMENT || node.getKind() == Tree.Kind.POSTFIX_INCREMENT) {
            AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(node.getExpression());
            this.checkAssignability(type, node.getExpression());
        }
        return super.visitUnary(node, p);
    }

    @Override
    public R visitCompoundAssignment(CompoundAssignmentTree node, P p) {
        AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(node.getVariable());
        this.checkAssignability(type, node.getVariable());
        return super.visitCompoundAssignment(node, p);
    }

    @Override
    public R visitNewArray(NewArrayTree node, P p) {
        this.validateTypeOf(node);
        if (node.getType() != null && node.getInitializers() != null) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = this.atypeFactory.getAnnotatedType(node);
            this.checkArrayInitialization(arrayType.getComponentType(), node.getInitializers(), p);
        }
        return super.visitNewArray(node, p);
    }

    @Override
    public R visitParameterizedType(ParameterizedTypeTree node, P p) {
        if (TreeUtils.isDiamondTree(node)) {
            return super.visitParameterizedType(node, p);
        }
        AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedTypeFromTypeTree(node);
        if (type.getKind() != TypeKind.DECLARED) {
            return super.visitParameterizedType(node, p);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType declared = (AnnotatedTypeMirror.AnnotatedDeclaredType)type;
        TypeElement element = (TypeElement)declared.getUnderlyingType().asElement();
        if (this.shouldSkip(element)) {
            return super.visitParameterizedType(node, p);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType generic = this.atypeFactory.getAnnotatedType(element);
        this.checkTypeArguments(generic.getTypeArguments(), declared.getTypeArguments(), node.getTypeArguments(), p);
        return super.visitParameterizedType(node, p);
    }

    protected void checkTypecastRedundancy(TypeCastTree node, P p) {
        AnnotatedTypeMirror exprType;
        if (!this.checker.getLintOption("cast:redundant", false)) {
            return;
        }
        AnnotatedTypeMirror castType = this.atypeFactory.getAnnotatedType(node);
        if (this.annoTypes.areSame(castType, exprType = this.atypeFactory.getAnnotatedType(node.getExpression()))) {
            this.checker.report(Result.warning("cast.redundant", castType), node);
        }
    }

    protected void checkTypecastSafety(TypeCastTree node, P p) {
        if (!this.checker.getLintOption("cast:unsafe", true)) {
            return;
        }
        boolean isSubtype = false;
        AnnotatedTypeMirror castType = this.atypeFactory.getAnnotatedType(node);
        if (castType.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType castDeclared = (AnnotatedTypeMirror.AnnotatedDeclaredType)castType;
            AnnotatedTypeMirror.AnnotatedDeclaredType elementType = this.atypeFactory.fromElement((TypeElement)castDeclared.getUnderlyingType().asElement());
            if (AnnotationUtils.areSame(castDeclared.getAnnotations(), elementType.getAnnotations())) {
                isSubtype = true;
            }
        }
        AnnotatedTypeMirror exprType = this.atypeFactory.getAnnotatedType(node.getExpression());
        if (!isSubtype) {
            isSubtype = this.checker.getQualifierHierarchy().isSubtype(exprType.getAnnotations(), castType.getAnnotations());
        }
        if (!isSubtype) {
            this.checker.report(Result.warning("cast.unsafe", exprType, castType), node);
        }
    }

    @Override
    public R visitTypeCast(TypeCastTree node, P p) {
        this.validateTypeOf(node.getType());
        this.checkTypecastSafety(node, p);
        this.checkTypecastRedundancy(node, p);
        return super.visitTypeCast(node, p);
    }

    @Override
    public R visitInstanceOf(InstanceOfTree node, P p) {
        this.validateTypeOf(node.getType());
        return super.visitInstanceOf(node, p);
    }

    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueExp, @CompilerMessageKey String errorKey, P p) {
        AnnotatedTypeMirror var = this.atypeFactory.getAnnotatedType(varTree);
        assert (var != null);
        this.checkAssignability(var, varTree);
        this.commonAssignmentCheck(var, valueExp, errorKey, p);
    }

    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueExp, @CompilerMessageKey String errorKey, P p) {
        if (this.shouldSkip(valueExp)) {
            return;
        }
        if (varType.getKind() == TypeKind.ARRAY && valueExp instanceof NewArrayTree && ((NewArrayTree)valueExp).getType() == null) {
            AnnotatedTypeMirror compType = ((AnnotatedTypeMirror.AnnotatedArrayType)varType).getComponentType();
            NewArrayTree arrayTree = (NewArrayTree)valueExp;
            assert (arrayTree.getInitializers() != null);
            this.checkArrayInitialization(compType, arrayTree.getInitializers(), p);
        }
        AnnotatedTypeMirror valueType = this.atypeFactory.getAnnotatedType(valueExp);
        assert (valueType != null);
        this.commonAssignmentCheck(varType, valueType, valueExp, errorKey, p);
    }

    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey, P p) {
        boolean success = this.checker.isSubtype(valueType, varType);
        if (this.options.containsKey("showchecks")) {
            long valuePos = this.positions.getStartPosition(this.root, valueTree);
            System.out.printf(" %s (line %3d): %s %s%n     actual: %s %s%n   expected: %s %s%n", new Object[]{success ? "success: actual is subtype of expected" : "FAILURE: actual is not subtype of expected", this.root.getLineMap().getLineNumber(valuePos), valueTree.getKind(), valueTree, valueType.getKind(), valueType, varType.getKind(), varType});
        }
        if (!success) {
            this.checker.report(Result.failure(errorKey, valueType.toString(), varType.toString()), valueTree);
        }
    }

    protected void checkArrayInitialization(AnnotatedTypeMirror type, List<? extends ExpressionTree> initializers, P p) {
        for (ExpressionTree expressionTree : initializers) {
            this.commonAssignmentCheck(type, expressionTree, "type.incompatible", p);
        }
    }

    protected void checkTypeArguments(List<? extends AnnotatedTypeMirror> typevars, List<? extends AnnotatedTypeMirror> typeargs, List<? extends Tree> typeargTrees, P p) {
        if (typeargs.isEmpty()) {
            return;
        }
        Iterator<? extends AnnotatedTypeMirror> varIter = typevars.iterator();
        Iterator<? extends AnnotatedTypeMirror> argIter = typeargs.iterator();
        while (varIter.hasNext()) {
            AnnotatedTypeMirror var = varIter.next();
            assert (var.getKind() == TypeKind.TYPEVAR) : var.getKind();
            AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)var;
            assert (argIter.hasNext()) : typevars + " / " + typeargs;
            AnnotatedTypeMirror typearg = argIter.next();
            if (typearg.getKind() == TypeKind.WILDCARD) continue;
            if (typeVar.getUpperBound() != null && (!TypesUtils.isObject(typeVar.getUpperBound().getUnderlyingType()) || typeVar.getUpperBound().isAnnotated())) {
                this.commonAssignmentCheck(typeVar.getUpperBound(), typearg, typeargTrees.get(typeargs.indexOf(typearg)), "generic.argument.invalid", p);
            }
            if (typeVar.getAnnotationsOnTypeVar().isEmpty() || typearg.getAnnotations().equals(typeVar.getAnnotationsOnTypeVar())) continue;
            this.checker.report(Result.failure("generic.argument.invalid", typearg, typeVar), typeargTrees.get(typeargs.indexOf(typearg)));
        }
    }

    protected boolean checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = method.getReceiverType().getErased();
        AnnotatedTypeMirror treeReceiver = ((AnnotatedTypeMirror)methodReceiver).getCopy(false);
        treeReceiver.addAnnotations(this.atypeFactory.getReceiver(node).getAnnotations());
        if (!this.checker.isSubtype(treeReceiver, methodReceiver)) {
            this.checker.report(Result.failure("method.invocation.invalid", TreeUtils.elementFromUse(node), treeReceiver.toString(), ((AnnotatedTypeMirror)methodReceiver).toString()), node);
            return false;
        }
        return true;
    }

    protected boolean checkConstructorInvocation(AnnotatedTypeMirror.AnnotatedDeclaredType dt, AnnotatedTypeMirror.AnnotatedExecutableType constructor, Tree src) {
        boolean b;
        Set<AnnotationMirror> dtAnno = dt.getAnnotations();
        Set<AnnotationMirror> receiverAnno = constructor.getReceiverType().getAnnotations();
        QualifierHierarchy hierarchy = this.checker.getQualifierHierarchy();
        boolean bl = b = hierarchy.isSubtype(dtAnno, receiverAnno) || hierarchy.isSubtype(receiverAnno, dtAnno);
        if (!b) {
            this.checker.report(Result.failure("constructor.invocation.invalid", constructor.toString(), dt, constructor.getReceiverType()), src);
        }
        return b;
    }

    protected void checkArguments(List<? extends AnnotatedTypeMirror> requiredArgs, List<? extends ExpressionTree> passedArgs, P p) {
        assert (requiredArgs.size() == passedArgs.size());
        for (int i = 0; i < requiredArgs.size(); ++i) {
            this.commonAssignmentCheck(requiredArgs.get(i), passedArgs.get(i), "argument.type.incompatible", p);
        }
    }

    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, P p) {
        if (this.shouldSkip(overriddenType.getElement())) {
            return true;
        }
        AnnotatedTypeMirror.AnnotatedExecutableType overrider = this.atypeFactory.getAnnotatedType(overriderTree);
        boolean result = true;
        if (overrider.getTypeVariables().isEmpty() && !overridden.getTypeVariables().isEmpty()) {
            overridden = overridden.getErased();
        }
        String overriderMeth = overrider.getElement().toString();
        String overriderTyp = enclosingType.getUnderlyingType().asElement().toString();
        String overriddenMeth = overridden.getElement().toString();
        String overriddenTyp = overriddenType.getUnderlyingType().asElement().toString();
        if (overrider.getReturnType().getKind() != TypeKind.VOID && !this.checker.isSubtype(overrider.getReturnType(), overridden.getReturnType())) {
            this.checker.report(Result.failure("override.return.invalid", overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overrider.getReturnType().toString(), overridden.getReturnType().toString()), overriderTree.getReturnType());
            result = false;
        }
        List<AnnotatedTypeMirror> overriderParams = overrider.getParameterTypes();
        List<AnnotatedTypeMirror> overriddenParams = overridden.getParameterTypes();
        for (int i = 0; i < overriderParams.size(); ++i) {
            if (this.checker.isSubtype(overriddenParams.get(i), overriderParams.get(i))) continue;
            this.checker.report(Result.failure("override.param.invalid", overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overriderParams.get(i).toString(), overriddenParams.get(i).toString()), overriderTree.getParameters().get(i));
            result = false;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType overriddenReceiver = overrider.getReceiverType().getErased().getCopy(false);
        overriddenReceiver.addAnnotations(overridden.getReceiverType().getAnnotations());
        if (!this.checker.isSubtype(overriddenReceiver, overrider.getReceiverType().getErased())) {
            this.checker.report(Result.failure("override.receiver.invalid", overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overrider.getReceiverType(), overridden.getReceiverType()), overriderTree);
            result = false;
        }
        return result;
    }

    protected void checkAssignability(AnnotatedTypeMirror varType, Tree varTree) {
        if (varTree instanceof ExpressionTree && !this.checker.isAssignable(varType, this.atypeFactory.getReceiver((ExpressionTree)varTree), varTree)) {
            this.checker.report(Result.failure("assignability.invalid", InternalUtils.symbol(varTree), this.atypeFactory.getReceiver((ExpressionTree)varTree)), varTree);
        }
    }

    protected MemberSelectTree enclosingMemberSelect() {
        TreePath path = this.getCurrentPath();
        assert (path.getLeaf().getKind() == Tree.Kind.IDENTIFIER);
        if (path.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            return (MemberSelectTree)path.getParentPath().getLeaf();
        }
        return null;
    }

    protected Tree enclosingStatement(Tree tree) {
        TreePath path;
        for (path = this.getCurrentPath(); path != null && path.getLeaf() != tree; path = path.getParentPath()) {
        }
        if (path != null) {
            return path.getParentPath().getLeaf();
        }
        return null;
    }

    @Override
    public R visitIdentifier(IdentifierTree node, P p) {
        this.checkAccess(node, p);
        return super.visitIdentifier(node, p);
    }

    protected void checkAccess(IdentifierTree node, P p) {
        Element elem;
        ExpressionTree tree;
        MemberSelectTree memberSel = this.enclosingMemberSelect();
        if (memberSel == null) {
            tree = node;
            elem = TreeUtils.elementFromUse(node);
        } else {
            tree = memberSel;
            elem = TreeUtils.elementFromUse(memberSel);
        }
        if (elem == null || !elem.getKind().isField()) {
            return;
        }
        AnnotatedTypeMirror receiver = this.plainFactory.getReceiver(tree);
        if (!this.isAccessAllowed(elem, receiver, tree)) {
            this.checker.report(Result.failure("unallowed.access", elem, receiver), node);
        }
    }

    protected boolean isAccessAllowed(Element field, AnnotatedTypeMirror receiver, ExpressionTree accessTree) {
        Unused unused = field.getAnnotation(Unused.class);
        if (unused == null) {
            return true;
        }
        try {
            unused.when();
        }
        catch (MirroredTypeException exp) {
            Name whenName = TypesUtils.getQualifiedName((DeclaredType)exp.getTypeMirror());
            if (receiver.getAnnotation(whenName) == null) {
                return true;
            }
            Tree tree = this.enclosingStatement(accessTree);
            return tree != null && tree.getKind() == Tree.Kind.ASSIGNMENT && ((AssignmentTree)tree).getVariable() == accessTree && ((AssignmentTree)tree).getExpression().getKind() == Tree.Kind.NULL_LITERAL;
        }
        assert (false) : "Cannot be here";
        return false;
    }

    public void validateTypeOf(Tree tree) {
        AnnotatedTypeMirror type;
        switch (tree.getKind()) {
            case PRIMITIVE_TYPE: 
            case PARAMETERIZED_TYPE: 
            case TYPE_PARAMETER: 
            case ARRAY_TYPE: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: {
                type = this.atypeFactory.getAnnotatedTypeFromTypeTree(tree);
                break;
            }
            default: {
                type = this.atypeFactory.getAnnotatedType(tree);
            }
        }
        this.typeValidator.visit(type, tree);
    }

    protected TypeValidator createTypeValidator() {
        return new TypeValidator();
    }

    private boolean isEnumSuper(MethodInvocationTree node) {
        ExecutableElement ex = TreeUtils.elementFromUse(node);
        Name name = ElementUtils.getQualifiedClassName(ex);
        return "java.lang.Enum".contentEquals(name);
    }

    protected final boolean shouldSkip(ExpressionTree exprTree) {
        if (exprTree instanceof ConditionalExpressionTree) {
            ConditionalExpressionTree condTree = (ConditionalExpressionTree)exprTree;
            return this.shouldSkip(condTree.getTrueExpression()) || this.shouldSkip(condTree.getFalseExpression());
        }
        Element elm = InternalUtils.symbol(exprTree);
        return this.shouldSkip(elm);
    }

    protected final boolean shouldSkip(Element element) {
        if (element == null) {
            return false;
        }
        TypeElement typeElement = ElementUtils.enclosingClass(element);
        String name = typeElement.getQualifiedName().toString();
        return this.checker.getShouldSkip().matcher(name).find();
    }

    @Override
    public R visitAnnotation(AnnotationTree node, P p) {
        return null;
    }

    @Override
    public R visitCompilationUnit(CompilationUnitTree node, P p) {
        Object r = this.scan(node.getPackageAnnotations(), p);
        r = this.reduce(this.scan(node.getTypeDecls(), p), r);
        return r;
    }

    protected void checkForAnnotatedJdk() {
        if (checkedJDK) {
            return;
        }
        checkedJDK = true;
        if (this.options.containsKey("nocheckjdk")) {
            return;
        }
        TypeElement objectTE = this.elements.getTypeElement("java.lang.Object");
        TypeMirror objectTM = objectTE.asType();
        AnnotatedTypeMirror objectATM = this.plainFactory.toAnnotatedType(objectTM);
        List<? extends Element> members = this.elements.getAllMembers(objectTE);
        for (Element element : members) {
            ExecutableElement m;
            AnnotatedTypeMirror.AnnotatedExecutableType objectEqualsAET;
            AnnotatedTypeMirror.AnnotatedDeclaredType objectEqualsParamADT;
            if (!element.toString().equals("equals(java.lang.Object)") || (objectEqualsParamADT = (AnnotatedTypeMirror.AnnotatedDeclaredType)(objectEqualsAET = this.annoTypes.asMemberOf(objectATM, m = (ExecutableElement)element)).getParameterTypes().get(0)).hasAnnotation(Nullable.class)) continue;
            System.out.printf("Warning:  you do not seem to be using the distributed annotated JDK.%nSupply javac the argument:  -Xbootclasspath/p:.../checkers/jdk/jdk.jar%n", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TypeValidator
    extends AnnotatedTypeScanner<Void, Tree> {
        protected TypeValidator() {
        }

        protected void reportError(AnnotatedTypeMirror type, Tree p) {
            BaseTypeVisitor.this.checker.report(Result.failure("type.invalid", type.getAnnotations(), type.toString()), p);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Tree p) {
            if (BaseTypeVisitor.this.shouldSkip(type.getElement())) {
                return (Void)super.visitDeclared(type, p);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType useType = type.getErased();
            AnnotatedTypeMirror.AnnotatedDeclaredType elemType = (AnnotatedTypeMirror.AnnotatedDeclaredType)BaseTypeVisitor.this.atypeFactory.getAnnotatedType(useType.getUnderlyingType().asElement()).getErased();
            if (!BaseTypeVisitor.this.checker.isValidUse(elemType, useType)) {
                this.reportError(useType, p);
            }
            return (Void)super.visitDeclared(type, p);
        }
    }
}

