/*
 * Decompiled with CFR 0.152.
 */
package checkers.basic;

import checkers.basetype.BaseTypeChecker;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.BasicAnnotatedTypeFactory;
import com.sun.source.tree.CompilationUnitTree;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.SupportedOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedOptions(value={"quals"})
public final class BasicChecker
extends BaseTypeChecker {
    @Override
    public AnnotatedTypeFactory createFactory(CompilationUnitTree root) {
        return new BasicAnnotatedTypeFactory<BasicChecker>(this, root);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        String qualNames = this.env.getOptions().get("quals");
        if (qualNames == null) {
            throw new Error("missing required option: -Aquals");
        }
        HashSet qualSet = new HashSet();
        try {
            for (String qualName : qualNames.split(",")) {
                Class<?> q = Class.forName(qualName);
                qualSet.add(q);
            }
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        return Collections.unmodifiableSet(qualSet);
    }

    @Override
    public Collection<String> getSuppressWarningsKey() {
        HashSet<String> swKeys = new HashSet<String>();
        Set<Class<? extends Annotation>> annos = this.getSupportedTypeQualifiers();
        if (annos.isEmpty()) {
            return super.getSuppressWarningsKey();
        }
        for (Class<? extends Annotation> anno : annos) {
            swKeys.add(anno.getSimpleName().toLowerCase());
        }
        return swKeys;
    }
}

