/*
 * Decompiled with CFR 0.152.
 */
package checkers.fenum;

import checkers.basetype.BaseTypeVisitor;
import checkers.fenum.FenumChecker;
import checkers.source.Result;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.TreeUtils;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FenumVisitor
extends BaseTypeVisitor<Void, Void> {
    public FenumVisitor(FenumChecker checker, CompilationUnitTree root) {
        super(checker, root);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        if (!TreeUtils.isStringConcatenation(node)) {
            AnnotatedTypeMirror lhs = this.atypeFactory.getAnnotatedType(node.getLeftOperand());
            AnnotatedTypeMirror rhs = this.atypeFactory.getAnnotatedType(node.getRightOperand());
            if (!this.checker.getQualifierHierarchy().isSubtype(lhs.getAnnotations(), rhs.getAnnotations()) && !this.checker.getQualifierHierarchy().isSubtype(rhs.getAnnotations(), lhs.getAnnotations())) {
                this.checker.report(Result.failure("binary.type.incompatible", lhs, rhs), node);
            }
        }
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        ExpressionTree var = node.getVariable();
        ExpressionTree expr = node.getExpression();
        AnnotatedTypeMirror varType = this.atypeFactory.getAnnotatedType(var);
        AnnotatedTypeMirror exprType = this.atypeFactory.getAnnotatedType(expr);
        if (!this.checker.getQualifierHierarchy().isSubtype(exprType.getAnnotations(), varType.getAnnotations())) {
            this.checker.report(Result.failure("compoundassign.type.incompatible", varType, exprType), node);
        }
        return (Void)super.visitCompoundAssignment(node, p);
    }

    @Override
    protected boolean checkConstructorInvocation(AnnotatedTypeMirror.AnnotatedDeclaredType dt, AnnotatedTypeMirror.AnnotatedExecutableType constructor, Tree src) {
        return true;
    }
}

