/*
 * Decompiled with CFR 0.152.
 */
package checkers.flow;

import checkers.types.QualifierHierarchy;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenKillBits<K> {
    private final Map<K, BitSet> bitsets;

    public static <K> GenKillBits<K> copy(GenKillBits<K> other) {
        if (other == null) {
            return null;
        }
        return new GenKillBits<K>(other);
    }

    public GenKillBits(Collection<K> keys) {
        this.bitsets = new HashMap<K, BitSet>(keys.size());
        for (K key : keys) {
            this.bitsets.put(key, new BitSet());
        }
    }

    public GenKillBits(GenKillBits<K> other) {
        other.valid();
        this.bitsets = new HashMap<K, BitSet>(other.bitsets);
        for (K key : this.bitsets.keySet()) {
            BitSet newbits = (BitSet)this.bitsets.get(key).clone();
            this.bitsets.put(key, newbits);
        }
    }

    public void set(K key, int index) {
        if (!this.bitsets.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        this.bitsets.get(key).set(index);
    }

    public boolean get(K key, int index) {
        this.valid();
        if (!this.bitsets.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return this.bitsets.get(key).get(index);
    }

    public boolean contains(K key) {
        return this.bitsets.containsKey(key);
    }

    public void clear(K key, int index) {
        if (!this.bitsets.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        this.bitsets.get(key).clear(index);
    }

    public String toString() {
        return "[GenKill: " + this.bitsets + "]";
    }

    public static void andlub(GenKillBits<AnnotationMirror> outarg1, GenKillBits<AnnotationMirror> arg2, QualifierHierarchy annoRelations) {
        outarg1.valid();
        arg2.valid();
        int length = 0;
        for (BitSet bs : outarg1.bitsets.values()) {
            if (bs.length() <= length) continue;
            length = bs.length();
        }
        for (BitSet bs : arg2.bitsets.values()) {
            if (bs.length() <= length) continue;
            length = bs.length();
        }
        for (int var = 0; var < length; ++var) {
            for (AnnotationMirror key1 : outarg1.bitsets.keySet()) {
                if (!arg2.bitsets.containsKey(key1)) {
                    throw new IllegalArgumentException();
                }
                BitSet lhs = outarg1.bitsets.get(key1);
                boolean notfound = true;
                for (AnnotationMirror key2 : arg2.bitsets.keySet()) {
                    BitSet rhs = arg2.bitsets.get(key2);
                    if (!lhs.get(var) || !rhs.get(var)) continue;
                    AnnotationMirror lub = annoRelations.leastUpperBound(key1, key2);
                    lhs.clear(var);
                    outarg1.bitsets.get(lub).set(var);
                    notfound = false;
                }
                if (!notfound) continue;
                lhs.clear(var);
            }
        }
        outarg1.valid();
    }

    public static void orlub(GenKillBits<AnnotationMirror> outarg1, GenKillBits<AnnotationMirror> arg2, QualifierHierarchy annoRelations) {
        outarg1.valid();
        arg2.valid();
        for (AnnotationMirror key1 : outarg1.bitsets.keySet()) {
            if (!arg2.bitsets.containsKey(key1)) {
                throw new IllegalArgumentException();
            }
            for (AnnotationMirror key2 : arg2.bitsets.keySet()) {
                BitSet lhs = outarg1.bitsets.get(key1);
                BitSet rhs = arg2.bitsets.get(key2);
                int length = lhs.length();
                if (rhs.length() > length) {
                    length = rhs.length();
                }
                for (int var = 0; var < length; ++var) {
                    if (!rhs.get(var)) continue;
                    if (lhs.get(var)) {
                        AnnotationMirror glb = annoRelations.leastUpperBound(key1, key2);
                        lhs.clear(var);
                        outarg1.bitsets.get(glb).set(var);
                        continue;
                    }
                    boolean found = false;
                    for (AnnotationMirror key3 : outarg1.bitsets.keySet()) {
                        if (!outarg1.bitsets.get(key3).get(var)) continue;
                        AnnotationMirror glb = annoRelations.leastUpperBound(key3, key2);
                        if (!glb.equals(key3)) {
                            outarg1.bitsets.get(key3).clear(var);
                            outarg1.bitsets.get(glb).set(var);
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    outarg1.bitsets.get(key2).set(var);
                }
            }
        }
        outarg1.valid();
    }

    public boolean valid() {
        BitSet xorres = new BitSet();
        BitSet orres = new BitSet();
        for (K key : this.bitsets.keySet()) {
            xorres.xor(this.bitsets.get(key));
            orres.or(this.bitsets.get(key));
        }
        for (int i = 0; i < orres.length(); ++i) {
            if (!orres.get(i) || xorres.get(i)) continue;
            return false;
        }
        return true;
    }
}

