/*
 * Decompiled with CFR 0.152.
 */
package checkers.javari;

import checkers.basetype.BaseTypeVisitor;
import checkers.javari.JavariChecker;
import checkers.javari.quals.Assignable;
import checkers.source.Result;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.AnnotatedTypes;
import checkers.util.TreeUtils;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavariVisitor
extends BaseTypeVisitor<Void, Void> {
    private final AnnotationMirror READONLY;
    private final AnnotationMirror MUTABLE;
    private final AnnotationMirror POLYREAD;
    private final AnnotationMirror QREADONLY;

    public JavariVisitor(JavariChecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.READONLY = checker.READONLY;
        this.MUTABLE = checker.MUTABLE;
        this.POLYREAD = checker.POLYREAD;
        this.QREADONLY = checker.QREADONLY;
        this.checkForAnnotatedJdk();
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        if (this.atypeFactory.fromClass(node).hasAnnotation(this.POLYREAD) && !this.atypeFactory.getSelfType(node).hasAnnotation(this.POLYREAD)) {
            this.checker.report(Result.failure("polyread.type", new Object[0]), node);
        }
        return (Void)super.visitClass(node, p);
    }

    @Override
    protected void checkAssignability(AnnotatedTypeMirror varType, Tree varTree) {
        AnnotatedTypeMirror receiver;
        if (!(varTree instanceof ExpressionTree)) {
            return;
        }
        Element varElt = varType.getElement();
        if (varElt != null && varElt.getAnnotation(Assignable.class) != null) {
            return;
        }
        boolean variableLocalField = TreeUtils.isSelfAccess((ExpressionTree)varTree) && varElt != null && varElt.getKind().isField();
        boolean inConstructor = this.visitorState.getMethodTree() == null || TreeUtils.isConstructor(this.visitorState.getMethodTree());
        AnnotatedTypeMirror.AnnotatedDeclaredType mReceiver = this.atypeFactory.getSelfType(varTree);
        if (variableLocalField && !inConstructor && !mReceiver.hasAnnotation(this.MUTABLE)) {
            this.checker.report(Result.failure("ro.field", new Object[0]), varTree);
        }
        if (varTree.getKind() == Tree.Kind.MEMBER_SELECT && !TreeUtils.isSelfAccess((ExpressionTree)varTree) && (receiver = this.atypeFactory.getReceiver((ExpressionTree)varTree)) != null && !receiver.hasAnnotation(this.MUTABLE)) {
            this.checker.report(Result.failure("ro.field", new Object[0]), varTree);
        }
    }

    @Override
    public void validateTypeOf(Tree tree) {
        AnnotatedTypeMirror type;
        switch (tree.getKind()) {
            case PRIMITIVE_TYPE: 
            case PARAMETERIZED_TYPE: 
            case TYPE_PARAMETER: 
            case ARRAY_TYPE: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: {
                type = this.atypeFactory.getAnnotatedTypeFromTypeTree(tree);
                break;
            }
            default: {
                type = this.atypeFactory.getAnnotatedType(tree);
            }
        }
        type = AnnotatedTypes.innerMostType(type);
        if (type.getKind().isPrimitive() && (type.hasAnnotation(this.QREADONLY) || type.hasAnnotation(this.READONLY) || type.hasAnnotation(this.POLYREAD))) {
            this.checker.report(Result.failure("primitive.ro", new Object[0]), tree);
        }
        super.validateTypeOf(tree);
    }
}

