/*
 * Decompiled with CFR 0.152.
 */
package checkers.lock;

import checkers.lock.LockChecker;
import checkers.lock.quals.GuardedBy;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.util.AnnotationUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockAnnotatedTypeFactory
extends BasicAnnotatedTypeFactory<LockChecker> {
    private List<String> heldLocks = new ArrayList<String>();
    private final AnnotationMirror GUARDED_BY = this.annotations.fromClass(GuardedBy.class);

    public LockAnnotatedTypeFactory(LockChecker checker, CompilationUnitTree root) {
        super(checker, root);
    }

    public void setHeldLocks(List<String> heldLocks) {
        this.heldLocks = heldLocks;
    }

    public List<String> getHeldLock() {
        return Collections.unmodifiableList(this.heldLocks);
    }

    private void removeHeldLocks(AnnotatedTypeMirror type) {
        Set<AnnotationMirror> annos = type.getAnnotations();
        if (annos.isEmpty()) {
            return;
        }
        AnnotationMirror guarded = annos.iterator().next();
        String lock = AnnotationUtils.elementValue(guarded, "value", String.class);
        if (this.heldLocks.contains(lock)) {
            type.clearAnnotations();
        }
    }

    private AnnotationMirror createGuarded(String lock) {
        AnnotationUtils.AnnotationBuilder builder = new AnnotationUtils.AnnotationBuilder(this.env, GuardedBy.class.getCanonicalName());
        builder.setValue((CharSequence)"value", lock);
        return builder.build();
    }

    private ExpressionTree receiver(ExpressionTree expr) {
        if (expr.getKind() == Tree.Kind.METHOD_INVOCATION) {
            expr = ((MethodInvocationTree)expr).getMethodSelect();
        }
        if ((expr = TreeUtils.skipParens(expr)).getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)expr).getExpression();
        }
        return null;
    }

    private void replaceThis(AnnotatedTypeMirror type, Tree tree) {
        if (tree.getKind() != Tree.Kind.IDENTIFIER && tree.getKind() != Tree.Kind.MEMBER_SELECT && tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return;
        }
        ExpressionTree expr = (ExpressionTree)tree;
        if (!type.hasAnnotation(this.GUARDED_BY) || TreeUtils.isSelfAccess(expr)) {
            return;
        }
        AnnotationMirror guardedBy = type.getAnnotation(GuardedBy.class.getCanonicalName());
        if (!"this".equals(AnnotationUtils.elementValue(guardedBy, "value", String.class))) {
            return;
        }
        ExpressionTree receiver = this.receiver(expr);
        assert (receiver != null);
        if (receiver != null) {
            AnnotationMirror newAnno = this.createGuarded(receiver.toString());
            type.clearAnnotations();
            type.addAnnotation(newAnno);
        }
    }

    private void replaceItself(AnnotatedTypeMirror type, Tree tree) {
        if (tree.getKind() != Tree.Kind.IDENTIFIER && tree.getKind() != Tree.Kind.MEMBER_SELECT && tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return;
        }
        ExpressionTree expr = (ExpressionTree)tree;
        if (!type.hasAnnotation(this.GUARDED_BY)) {
            return;
        }
        AnnotationMirror guardedBy = type.getAnnotation(GuardedBy.class.getCanonicalName());
        if (!"itself".equals(AnnotationUtils.elementValue(guardedBy, "value", String.class))) {
            return;
        }
        AnnotationMirror newAnno = this.createGuarded(expr.toString());
        type.clearAnnotations();
        type.addAnnotation(newAnno);
    }

    @Override
    protected void annotateImplicit(Tree tree, AnnotatedTypeMirror type) {
        super.annotateImplicit(tree, type);
        this.replaceThis(type, tree);
        this.replaceItself(type, tree);
        this.removeHeldLocks(type);
    }

    @Override
    protected AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        if (TypesUtils.isDeclaredOfName(a.getAnnotationType(), net.jcip.annotations.GuardedBy.class.getCanonicalName())) {
            AnnotationUtils.AnnotationBuilder builder = new AnnotationUtils.AnnotationBuilder(this.env, GuardedBy.class);
            builder.setValue((CharSequence)"value", AnnotationUtils.parseStringValue(a, "value"));
            return builder.build();
        }
        return super.aliasedAnnotation(a);
    }
}

