/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.nullness.NullnessAnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.AnnotatedTypes;
import checkers.util.TreeUtils;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public class CollectionToArrayHeuristics {
    private final ProcessingEnvironment env;
    private final NullnessAnnotatedTypeFactory factory;
    private final AnnotatedTypes atypes;
    private final ExecutableElement collectionToArrayObject;
    private final ExecutableElement collectionToArrayE;
    private final ExecutableElement size;
    private final AnnotatedTypeMirror.AnnotatedDeclaredType collectionType;

    public CollectionToArrayHeuristics(ProcessingEnvironment env, NullnessAnnotatedTypeFactory factory) {
        this.env = env;
        this.factory = factory;
        this.atypes = new AnnotatedTypes(env, factory);
        this.collectionToArrayObject = this.getMethod("java.util.Collection", "toArray", 0);
        this.collectionToArrayE = this.getMethod("java.util.Collection", "toArray", 1);
        this.size = this.getMethod("java.util.Collection", "size", 0);
        this.collectionType = factory.fromElement(env.getElementUtils().getTypeElement("java.util.Collection"));
    }

    public void handle(MethodInvocationTree tree, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        if (this.isMethod(tree, this.collectionToArrayObject)) {
            boolean receiver = this.isNonNullReceiver(tree);
            this.setComponentNullness(receiver, method.getReturnType());
        } else if (this.isMethod(tree, this.collectionToArrayE)) {
            assert (!tree.getArguments().isEmpty()) : tree;
            Tree argument = tree.getArguments().get(0);
            boolean isArrayCreation = this.isHandledArrayCreation(argument, this.receiver(tree.getMethodSelect()));
            boolean receiver = this.isNonNullReceiver(tree);
            this.setComponentNullness(receiver && isArrayCreation, method.getReturnType());
            if (!receiver) {
                this.setComponentNullness(false, method.getParameterTypes().get(0));
            }
        }
    }

    private void setComponentNullness(boolean isNonNull, AnnotatedTypeMirror type) {
        assert (type.getKind() == TypeKind.ARRAY);
        AnnotatedTypeMirror compType = ((AnnotatedTypeMirror.AnnotatedArrayType)type).getComponentType();
        compType.clearAnnotations();
        compType.addAnnotation(isNonNull ? this.factory.NONNULL : this.factory.NULLABLE);
    }

    private boolean isHandledArrayCreation(Tree argument, String receiver) {
        if (argument.getKind() != Tree.Kind.NEW_ARRAY) {
            return false;
        }
        NewArrayTree newArr = (NewArrayTree)argument;
        if (newArr.getInitializers() != null) {
            return newArr.getInitializers().isEmpty();
        }
        assert (!newArr.getDimensions().isEmpty());
        Tree dimension = newArr.getDimensions().get(newArr.getDimensions().size() - 1);
        if (dimension.toString().equals("0")) {
            return true;
        }
        if (this.isMethod(dimension, this.size)) {
            MethodInvocationTree invok = (MethodInvocationTree)dimension;
            String invokReceiver = this.receiver(invok.getMethodSelect());
            return invokReceiver.equals(receiver);
        }
        return false;
    }

    private boolean isNonNullReceiver(MethodInvocationTree tree) {
        AnnotatedTypeMirror receiver = this.factory.getReceiver(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType collection = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypes.asSuper(receiver, this.collectionType);
        assert (collection != null);
        return !collection.getTypeArguments().isEmpty() && collection.getTypeArguments().get(0).hasAnnotation(this.factory.NONNULL);
    }

    private String receiver(Tree tree) {
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)tree).getExpression().toString();
        }
        return "this";
    }

    private boolean isMethod(Tree tree, ExecutableElement method) {
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methInvok = (MethodInvocationTree)tree;
        ExecutableElement invoked = TreeUtils.elementFromUse(methInvok);
        return this.isMethod(invoked, method);
    }

    private boolean isMethod(ExecutableElement questioned, ExecutableElement method) {
        return questioned.equals(method) || this.env.getElementUtils().overrides(questioned, method, (TypeElement)questioned.getEnclosingElement());
    }

    private ExecutableElement getMethod(String typeName, String methodName, int params) {
        TypeElement mapElt = this.env.getElementUtils().getTypeElement(typeName);
        for (ExecutableElement exec : ElementFilter.methodsIn(mapElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName) || exec.getParameters().size() != params) continue;
            return exec;
        }
        throw new RuntimeException("Shouldn't be here!");
    }
}

