/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseTypeChecker;
import checkers.nullness.quals.Covariant;
import checkers.nullness.quals.KeyFor;
import checkers.nullness.quals.KeyForBottom;
import checkers.quals.TypeQualifiers;
import checkers.quals.Unqualified;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeHierarchy;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

@TypeQualifiers(value={KeyFor.class, Unqualified.class, KeyForBottom.class})
public class KeyForSubchecker
extends BaseTypeChecker {
    protected TypeHierarchy createTypeHierarchy() {
        return new KeyForTypeHierarchy(this.getQualifierHierarchy());
    }

    public final boolean isSubtype(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        if (lhs.getKind() == TypeKind.TYPEVAR && rhs.getKind() == TypeKind.TYPEVAR && lhs.getAnnotations().isEmpty()) {
            return true;
        }
        if (rhs.getAnnotation(KeyForBottom.class) != null) {
            return true;
        }
        return super.isSubtype(rhs, lhs);
    }

    private class KeyForTypeHierarchy
    extends TypeHierarchy {
        public KeyForTypeHierarchy(QualifierHierarchy qualifierHierarchy) {
            super(qualifierHierarchy);
        }

        protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
            List<AnnotatedTypeMirror> rhsTypeArgs = rhs.getTypeArguments();
            List<AnnotatedTypeMirror> lhsTypeArgs = lhs.getTypeArguments();
            if (rhsTypeArgs.isEmpty() || lhsTypeArgs.isEmpty()) {
                return true;
            }
            TypeElement lhsElem = (TypeElement)lhs.getUnderlyingType().asElement();
            int[] covarVals = null;
            if (lhsElem.getAnnotation(Covariant.class) != null) {
                covarVals = lhsElem.getAnnotation(Covariant.class).value();
            }
            assert (lhsTypeArgs.size() == rhsTypeArgs.size());
            for (int i = 0; i < lhsTypeArgs.size(); ++i) {
                boolean covar = false;
                if (covarVals != null) {
                    for (int cvv = 0; cvv < covarVals.length; ++cvv) {
                        if (covarVals[cvv] != i) continue;
                        covar = true;
                    }
                }
                if (!(covar ? !KeyForSubchecker.this.isSubtype(rhsTypeArgs.get(i), lhsTypeArgs.get(i)) : !this.isSubtypeAsTypeArgument(rhsTypeArgs.get(i), lhsTypeArgs.get(i)))) continue;
                return false;
            }
            return true;
        }
    }
}

