/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseTypeVisitor;
import checkers.nullness.KeyForSubchecker;
import checkers.nullness.quals.KeyFor;
import checkers.source.Result;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.AnnotationUtils;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyForVisitor
extends BaseTypeVisitor<Void, Void> {
    public KeyForVisitor(KeyForSubchecker checker, CompilationUnitTree root) {
        super(checker, root);
    }

    @Override
    protected BaseTypeVisitor.TypeValidator createTypeValidator() {
        return new KeyForTypeValidator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyForTypeValidator
    extends BaseTypeVisitor.TypeValidator {
        private KeyForTypeValidator() {
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Tree p) {
            AnnotationMirror kf = type.getAnnotation(KeyFor.class);
            if (kf != null) {
                ModifiersTree mt;
                List<String> maps = AnnotationUtils.parseStringArrayValue(kf, "value");
                boolean inStatic = false;
                if (p.getKind() == Tree.Kind.VARIABLE && (mt = ((VariableTree)p).getModifiers()).getFlags().contains((Object)Modifier.STATIC)) {
                    inStatic = true;
                }
                for (String map : maps) {
                    if (map.equals("this")) {
                        if (!inStatic) continue;
                        KeyForVisitor.this.checker.report(Result.failure("keyfor.type.invalid", type.getAnnotations(), type.toString()), p);
                        continue;
                    }
                    if (!map.matches("#(\\d+)")) continue;
                }
            }
            return super.visitDeclared(type, p);
        }
    }
}

