/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.nullness.NullnessAnnotatedTypeFactory;
import checkers.nullness.quals.KeyFor;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.AnnotationUtils;
import checkers.util.Heuristics;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

class MapGetHeuristics {
    private final ProcessingEnvironment env;
    private final Elements elements;
    private final NullnessAnnotatedTypeFactory factory;
    private final AnnotatedTypeFactory keyForFactory;
    private final ExecutableElement mapGet;
    private final ExecutableElement mapPut;
    private final ExecutableElement mapKeySet;
    private final ExecutableElement mapContains;

    public MapGetHeuristics(ProcessingEnvironment env, NullnessAnnotatedTypeFactory factory, AnnotatedTypeFactory keyForFactory) {
        this.env = env;
        this.elements = env.getElementUtils();
        this.factory = factory;
        this.keyForFactory = keyForFactory;
        this.mapGet = this.getMethod("java.util.Map", "get", 1);
        this.mapPut = this.getMethod("java.util.Map", "put", 2);
        this.mapKeySet = this.getMethod("java.util.Map", "keySet", 0);
        this.mapContains = this.getMethod("java.util.Map", "containsKey", 1);
    }

    public void handle(MethodInvocationTree tree, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        if (this.isMethod(tree, this.mapGet)) {
            AnnotatedTypeMirror type = method.getReturnType();
            type.clearAnnotations();
            if (!this.isSuppressable(tree)) {
                type.addAnnotation(this.factory.NULLABLE);
            } else {
                type.addAnnotation(this.factory.NONNULL);
            }
        }
    }

    private boolean isSuppressable(MethodInvocationTree tree) {
        Element elt = this.getSite(tree);
        if (elt instanceof VariableElement && tree.getArguments().get(0) instanceof IdentifierTree && this.isKeyInMap((IdentifierTree)tree.getArguments().get(0), (VariableElement)elt)) {
            return true;
        }
        if (elt instanceof VariableElement) {
            ExpressionTree arg = tree.getArguments().get(0);
            return this.keyForInMap(arg, ((VariableElement)elt).getSimpleName().toString()) || this.keyForInMap(arg, String.valueOf(TreeUtils.getReceiverTree(tree)));
        }
        return false;
    }

    private boolean keyForInMap(ExpressionTree key, String mapName) {
        AnnotatedTypeMirror keyForType = this.keyForFactory.getAnnotatedType(key);
        AnnotationMirror anno = keyForType.getAnnotation(KeyFor.class);
        if (anno == null) {
            return false;
        }
        List<String> maps = AnnotationUtils.parseStringArrayValue(anno, "value");
        return maps.contains(mapName);
    }

    public Heuristics.Matcher inContains(final Element key, final VariableElement map) {
        return Heuristics.Matchers.or(Heuristics.Matchers.whenTrue(new Heuristics.Matcher(){

            public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
                return MapGetHeuristics.this.isInvocationOfContains(key, map, node);
            }
        }), Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.CONDITIONAL_EXPRESSION, new Heuristics.Matcher(){

            public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void p) {
                return MapGetHeuristics.this.isInvocationOfContains(key, map, tree.getCondition());
            }
        })));
    }

    private Heuristics.Matcher inForEnhanced(final Element key, final VariableElement map) {
        return Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.ENHANCED_FOR_LOOP, new Heuristics.Matcher(){

            public Boolean visitEnhancedForLoop(EnhancedForLoopTree tree, Void p) {
                if (key.equals(TreeUtils.elementFromDeclaration(tree.getVariable()))) {
                    return (Boolean)this.visit(tree.getExpression(), p);
                }
                return false;
            }

            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void p) {
                return MapGetHeuristics.this.isMethod(tree, MapGetHeuristics.this.mapKeySet) && map.equals(MapGetHeuristics.this.getSite(tree));
            }
        }));
    }

    private Heuristics.Matcher preceededByAssert(final Element key, final VariableElement map) {
        return Heuristics.Matchers.preceededBy(Heuristics.Matchers.ofKind(Tree.Kind.ASSERT, new Heuristics.Matcher(){

            public Boolean visitAssert(AssertTree tree, Void p) {
                return MapGetHeuristics.this.isInvocationOfContains(key, map, tree.getCondition()) || MapGetHeuristics.this.isCheckOfGet(key, map, tree.getCondition());
            }
        }));
    }

    private boolean isTerminating(StatementTree tree) {
        IfTree ifTree;
        StatementTree first = this.firstStatement(tree);
        if (first instanceof ThrowTree) {
            return true;
        }
        if (first instanceof ReturnTree) {
            return true;
        }
        return first instanceof IfTree && (ifTree = (IfTree)first).getElseStatement() != null && this.isTerminating(ifTree.getThenStatement()) && this.isTerminating(ifTree.getElseStatement());
    }

    private Heuristics.Matcher preceededByExplicitAssert(final Element key, final VariableElement map) {
        return Heuristics.Matchers.preceededBy(Heuristics.Matchers.ofKind(Tree.Kind.IF, new Heuristics.Matcher(){

            public Boolean visitIf(IfTree tree, Void p) {
                return MapGetHeuristics.this.isNotContained(key, map, tree.getCondition()) && MapGetHeuristics.this.isTerminating(tree.getThenStatement());
            }
        }));
    }

    private Heuristics.Matcher preceededByIfThenPut(final Element key, final VariableElement map) {
        return Heuristics.Matchers.preceededBy(Heuristics.Matchers.ofKind(Tree.Kind.IF, new Heuristics.Matcher(){

            public Boolean visitIf(IfTree tree, Void p) {
                StatementTree first;
                if (MapGetHeuristics.this.isNotContained(key, map, tree.getCondition()) && (first = MapGetHeuristics.this.firstStatement(tree.getThenStatement())) != null && first.getKind() == Tree.Kind.EXPRESSION_STATEMENT && MapGetHeuristics.this.isInvocationOfPut(key, map, ((ExpressionStatementTree)first).getExpression())) {
                    return true;
                }
                return false;
            }
        }));
    }

    private Heuristics.Matcher keyInMatcher(Element key, VariableElement map) {
        return Heuristics.Matchers.or(this.inContains(key, map), this.inForEnhanced(key, map), this.preceededByAssert(key, map), this.preceededByExplicitAssert(key, map), this.preceededByIfThenPut(key, map));
    }

    private boolean isKeyInMap(IdentifierTree keyTree, VariableElement map) {
        TreePath path = this.factory.getPath(keyTree);
        Element key = TreeUtils.elementFromUse(keyTree);
        return this.keyInMatcher(key, map).match(path);
    }

    private Element getSite(MethodInvocationTree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.factory.getReceiver(tree);
        return type.getElement();
    }

    private boolean isMethod(Tree tree, ExecutableElement method) {
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methInvok = (MethodInvocationTree)tree;
        ExecutableElement invoked = TreeUtils.elementFromUse(methInvok);
        return this.isMethod(invoked, method);
    }

    private boolean isMethod(ExecutableElement questioned, ExecutableElement method) {
        return questioned.equals(method) || this.env.getElementUtils().overrides(questioned, method, (TypeElement)questioned.getEnclosingElement());
    }

    private ExecutableElement getMethod(String typeName, String methodName, int params) {
        TypeElement mapElt = this.env.getElementUtils().getTypeElement(typeName);
        for (ExecutableElement exec : ElementFilter.methodsIn(mapElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName) || exec.getParameters().size() != params) continue;
            return exec;
        }
        throw new RuntimeException("Shouldn't be here!");
    }

    private boolean isInvocationOfContains(Element key, VariableElement map, Tree tree) {
        Element containsArgument;
        MethodInvocationTree invok;
        return TreeUtils.skipParens(tree) instanceof MethodInvocationTree && this.isMethod(invok = (MethodInvocationTree)TreeUtils.skipParens(tree), this.mapContains) && key.equals(containsArgument = InternalUtils.symbol(invok.getArguments().get(0))) && map.equals(this.getSite(invok));
    }

    private boolean isInvocationOfPut(Element key, VariableElement map, Tree tree) {
        Element containsArgument;
        MethodInvocationTree invok;
        return TreeUtils.skipParens(tree) instanceof MethodInvocationTree && this.isMethod(invok = (MethodInvocationTree)TreeUtils.skipParens(tree), this.mapPut) && key.equals(containsArgument = InternalUtils.symbol(invok.getArguments().get(0))) && map.equals(this.getSite(invok));
    }

    private boolean isNotContained(Element key, VariableElement map, ExpressionTree tree) {
        return (tree = TreeUtils.skipParens(tree)).getKind() == Tree.Kind.LOGICAL_COMPLEMENT && this.isInvocationOfContains(key, map, ((UnaryTree)tree).getExpression());
    }

    private StatementTree firstStatement(StatementTree tree) {
        StatementTree first = tree;
        while (first.getKind() == Tree.Kind.BLOCK) {
            List<? extends StatementTree> trees = ((BlockTree)first).getStatements();
            if (trees.isEmpty()) {
                return null;
            }
            first = trees.iterator().next();
        }
        return first;
    }

    private boolean isCheckOfGet(Element key, VariableElement map, Tree tree) {
        Element containsArgument;
        MethodInvocationTree invok;
        if ((tree = TreeUtils.skipParens(tree)).getKind() != Tree.Kind.NOT_EQUAL_TO || ((BinaryTree)tree).getRightOperand().getKind() != Tree.Kind.NULL_LITERAL) {
            return false;
        }
        ExpressionTree right = TreeUtils.skipParens(((BinaryTree)tree).getLeftOperand());
        return right instanceof MethodInvocationTree && this.isMethod(invok = (MethodInvocationTree)right, this.mapGet) && key.equals(containsArgument = InternalUtils.symbol(invok.getArguments().get(0))) && map.equals(this.getSite(invok));
    }
}

