/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseTypeVisitor;
import checkers.nullness.NullnessSubchecker;
import checkers.nullness.quals.LazyNonNull;
import checkers.nullness.quals.NonNull;
import checkers.nullness.quals.Nullable;
import checkers.source.Result;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullnessVisitor
extends BaseTypeVisitor<Void, Void> {
    private final AnnotationMirror NONNULL = this.annoFactory.fromClass(NonNull.class);
    private final AnnotationMirror NULLABLE = this.annoFactory.fromClass(Nullable.class);
    private final TypeMirror stringType = this.elements.getTypeElement("java.lang.String").asType();
    private boolean isInAssert = false;
    private Set<VariableElement> nonInitializedFields = null;

    public NullnessVisitor(NullnessSubchecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.checkForAnnotatedJdk();
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        if (!TreeUtils.isSelfAccess(node)) {
            this.checkForNullability(node.getExpression(), "dereference.of.nullable");
        }
        return (Void)super.visitMemberSelect(node, p);
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
        this.checkForNullability(node.getExpression(), "dereference.of.nullable");
        return (Void)super.visitEnhancedForLoop(node, p);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Void p) {
        this.checkForNullability(node.getExpression(), "accessing.nullable");
        return (Void)super.visitArrayAccess(node, p);
    }

    @Override
    public Void visitThrow(ThrowTree node, Void p) {
        this.checkForNullability(node.getExpression(), "throwing.nullable");
        return (Void)super.visitThrow(node, p);
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Void p) {
        AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(node.getExpression());
        if (type.hasAnnotation(this.NULLABLE)) {
            this.checker.report(Result.failure("locking.nullable", node), node);
        }
        return (Void)super.visitSynchronized(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitAssert(AssertTree node, Void p) {
        boolean beforeAssert = this.isInAssert;
        try {
            this.isInAssert = true;
            Void void_ = (Void)super.visitAssert(node, p);
            return void_;
        }
        finally {
            this.isInAssert = beforeAssert;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitIf(IfTree node, Void p) {
        boolean beforeAssert = this.isInAssert;
        try {
            this.isInAssert = TreeUtils.firstStatement(node.getThenStatement()).getKind() == Tree.Kind.THROW && node.getElseStatement() == null;
            Void void_ = (Void)super.visitIf(node, p);
            return void_;
        }
        finally {
            this.isInAssert = beforeAssert;
        }
    }

    protected void checkForRedundantTests(BinaryTree node) {
        if (this.isInAssert) {
            return;
        }
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        if ((node.getKind() == Tree.Kind.EQUAL_TO || node.getKind() == Tree.Kind.NOT_EQUAL_TO) && this.checker.getLintOption("nulltest", false)) {
            AnnotatedTypeMirror left = this.atypeFactory.getAnnotatedType(leftOp);
            AnnotatedTypeMirror right = this.atypeFactory.getAnnotatedType(rightOp);
            if (leftOp.getKind() == Tree.Kind.NULL_LITERAL && right.hasAnnotation(this.NONNULL)) {
                this.checker.report(Result.warning("known.nonnull", rightOp.toString()), node);
            } else if (rightOp.getKind() == Tree.Kind.NULL_LITERAL && left.hasAnnotation(this.NONNULL)) {
                this.checker.report(Result.warning("known.nonnull", leftOp.toString()), node);
            }
        }
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        if (this.isUnboxingOperation(node)) {
            this.checkForNullability(leftOp, "unboxing.of.nullable");
            this.checkForNullability(rightOp, "unboxing.of.nullable");
        }
        this.checkForRedundantTests(node);
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitUnary(UnaryTree node, Void p) {
        this.checkForNullability(node.getExpression(), "unboxing.of.nullable");
        return (Void)super.visitUnary(node, p);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        if (!this.isString(node)) {
            this.checkForNullability(node.getVariable(), "unboxing.of.nullable");
            this.checkForNullability(node.getExpression(), "unboxing.of.nullable");
        }
        return (Void)super.visitCompoundAssignment(node, p);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        if (this.isPrimitive(node) && !this.isPrimitive(node.getExpression())) {
            this.checkForNullability(node.getExpression(), "unboxing.of.nullable");
        }
        return (Void)super.visitTypeCast(node, p);
    }

    @Override
    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueExp, String errorKey, Void p) {
        VariableElement elem;
        if (varTree.getKind() == Tree.Kind.VARIABLE && (elem = TreeUtils.elementFromDeclaration((VariableTree)varTree)).getAnnotation(LazyNonNull.class) != null) {
            return;
        }
        super.commonAssignmentCheck(varTree, valueExp, errorKey, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree node, Void p) {
        if (TreeUtils.isConstructor(node) && !TreeUtils.containsThisConstructorInvocation(node)) {
            Void void_;
            Set<VariableElement> oldFields = this.nonInitializedFields;
            try {
                this.nonInitializedFields = this.getUninitializedFields(TreeUtils.enclosingClass(this.getCurrentPath()));
                void_ = (Void)super.visitMethod(node, p);
            }
            catch (Throwable throwable) {
                if (!this.nonInitializedFields.isEmpty() && this.checker.getLintOption("uninitialized", false)) {
                    this.checker.report(Result.failure("fields.uninitialized", this.nonInitializedFields), node);
                }
                this.nonInitializedFields = oldFields;
                throw throwable;
            }
            if (!this.nonInitializedFields.isEmpty() && this.checker.getLintOption("uninitialized", false)) {
                this.checker.report(Result.failure("fields.uninitialized", this.nonInitializedFields), node);
            }
            this.nonInitializedFields = oldFields;
            return void_;
        }
        return (Void)super.visitMethod(node, p);
    }

    @Override
    protected void checkDefaultConstructor(ClassTree node) {
        if (!this.checker.getLintOption("uninitialized", false)) {
            return;
        }
        Set<VariableElement> fields = this.getUninitializedFields(node);
        if (!fields.isEmpty()) {
            this.checker.report(Result.failure("fields.uninitialized", fields), node);
        }
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        if (this.nonInitializedFields != null) {
            this.nonInitializedFields.remove(InternalUtils.symbol(node.getVariable()));
        }
        return (Void)super.visitAssignment(node, p);
    }

    private Set<VariableElement> getUninitializedFields(ClassTree classTree) {
        HashSet<VariableElement> fields = new HashSet<VariableElement>();
        for (Tree tree : classTree.getMembers()) {
            if (!(tree instanceof VariableTree)) continue;
            VariableTree var = (VariableTree)tree;
            VariableElement varElt = TreeUtils.elementFromDeclaration(var);
            if (var.getInitializer() != null || !this.atypeFactory.getAnnotatedType(var).hasAnnotation(this.NONNULL) || varElt.getModifiers().contains((Object)Modifier.STATIC)) continue;
            fields.add(varElt);
        }
        return fields;
    }

    @Override
    protected boolean checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
        if (TreeUtils.isSelfAccess(node) ? this.nonInitializedFields != null && this.nonInitializedFields.isEmpty() : method.getReceiverType().hasAnnotation(this.NONNULL)) {
            return true;
        }
        return super.checkMethodInvocability(method, node);
    }

    private void checkForNullability(ExpressionTree tree, String errMsg) {
        AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(tree);
        if (!type.hasAnnotation(this.NONNULL)) {
            this.checker.report(Result.failure(errMsg, tree), tree);
        }
    }

    private final boolean isUnboxingOperation(BinaryTree tree) {
        if (tree.getKind() == Tree.Kind.EQUAL_TO || tree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
            return this.isPrimitive(tree.getLeftOperand()) != this.isPrimitive(tree.getRightOperand());
        }
        return !this.isString(tree);
    }

    private final boolean isString(ExpressionTree tree) {
        TypeMirror type = InternalUtils.typeOf(tree);
        return this.types.isAssignable(this.stringType, type);
    }

    private final boolean isPrimitive(ExpressionTree tree) {
        return InternalUtils.typeOf(tree).getKind().isPrimitive();
    }
}

