/*
 * Decompiled with CFR 0.152.
 */
package checkers.oigj;

import checkers.basetype.BaseTypeChecker;
import checkers.oigj.OIGJMutabilityBottom;
import checkers.oigj.quals.Assignable;
import checkers.oigj.quals.AssignsFields;
import checkers.oigj.quals.I;
import checkers.oigj.quals.Immutable;
import checkers.oigj.quals.Mutable;
import checkers.oigj.quals.ReadOnly;
import checkers.quals.TypeQualifiers;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeHierarchy;
import checkers.util.AnnotationUtils;
import checkers.util.InternalUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Collections;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

@TypeQualifiers(value={ReadOnly.class, Mutable.class, Immutable.class, I.class, AssignsFields.class, OIGJMutabilityBottom.class})
public class ImmutabilitySubchecker
extends BaseTypeChecker {
    protected AnnotationMirror READONLY;
    protected AnnotationMirror MUTABLE;
    protected AnnotationMirror IMMUTABLE;
    protected AnnotationMirror I;
    protected AnnotationMirror ASSIGNS_FIELDS;
    protected AnnotationMirror BOTTOM_QUAL;

    public synchronized void init(ProcessingEnvironment env) {
        AnnotationUtils annoFactory = AnnotationUtils.getInstance(env);
        this.READONLY = annoFactory.fromClass(ReadOnly.class);
        this.MUTABLE = annoFactory.fromClass(Mutable.class);
        this.IMMUTABLE = annoFactory.fromClass(Immutable.class);
        this.I = annoFactory.fromClass(I.class);
        this.ASSIGNS_FIELDS = annoFactory.fromClass(AssignsFields.class);
        this.BOTTOM_QUAL = annoFactory.fromClass(OIGJMutabilityBottom.class);
        super.init(env);
    }

    protected TypeHierarchy createTypeHierarchy() {
        return new OIGJImmutabilityQualifierHierarchy(this.getQualifierHierarchy());
    }

    public boolean isAssignable(AnnotatedTypeMirror varType, AnnotatedTypeMirror receiverType, Tree varTree) {
        if (!(varTree instanceof ExpressionTree)) {
            return true;
        }
        Element varElement = InternalUtils.symbol(varTree);
        if (varElement != null && varElement.getAnnotation(Assignable.class) != null) {
            return true;
        }
        return this.getQualifierHierarchy().isSubtype(receiverType.getAnnotations(), Collections.singleton(this.ASSIGNS_FIELDS));
    }

    private final class OIGJImmutabilityQualifierHierarchy
    extends TypeHierarchy {
        public OIGJImmutabilityQualifierHierarchy(QualifierHierarchy qualifierHierarchy) {
            super(qualifierHierarchy);
        }

        protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
            if (lhs.hasAnnotation(ImmutabilitySubchecker.this.MUTABLE)) {
                return super.isSubtypeTypeArguments(rhs, lhs);
            }
            if (!lhs.getTypeArguments().isEmpty() && !rhs.getTypeArguments().isEmpty()) {
                assert (lhs.getTypeArguments().size() == rhs.getTypeArguments().size());
                for (int i = 0; i < lhs.getTypeArguments().size(); ++i) {
                    if (this.isSubtype(rhs.getTypeArguments().get(i), lhs.getTypeArguments().get(i))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

