/*
 * Decompiled with CFR 0.152.
 */
package checkers.propkey;

import checkers.basetype.BaseTypeChecker;
import checkers.propkey.quals.PropertyKey;
import checkers.quals.TypeQualifiers;
import checkers.quals.Unqualified;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TypeQualifiers(value={PropertyKey.class, Unqualified.class})
@SupportedOptions(value={"propfiles", "bundlenames"})
public class PropertyKeyChecker
extends BaseTypeChecker {
    private Set<String> lookupKeys;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.lookupKeys = Collections.unmodifiableSet(this.buildLookupKeys(env.getOptions()));
    }

    public Set<String> getLookupKeys() {
        return this.lookupKeys;
    }

    private Set<String> buildLookupKeys(Map<String, String> options) {
        HashSet<String> result = new HashSet<String>();
        if (options.containsKey("propfiles")) {
            result.addAll(this.keysOfPropertyFiles(this.env.getOptions().get("propfiles")));
        }
        if (options.containsKey("bundlenames")) {
            result.addAll(this.keysOfResourceBundle(this.env.getOptions().get("bundlenames")));
        }
        return result;
    }

    private Set<String> keysOfPropertyFiles(String names) {
        String[] namesArr = names.split(":");
        if (namesArr == null) {
            System.err.println("Couldn't parse the properties files: <" + names + ">");
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String name : namesArr) {
            try {
                Properties prop = new Properties();
                InputStream in = null;
                ClassLoader cl = this.getClass().getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if ((in = cl.getResourceAsStream(name)) == null) {
                    try {
                        in = new FileInputStream(name);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                if (in == null) {
                    System.err.println("Couldn't find the properties file: " + name);
                    continue;
                }
                prop.load(in);
                result.addAll(prop.stringPropertyNames());
            }
            catch (Exception e) {
                System.err.println("Exception in PropertyKeyChecker.keysOfPropertyFile: " + e);
                e.printStackTrace();
            }
        }
        return result;
    }

    private Set<String> keysOfResourceBundle(String bundleNames) {
        String[] namesArr = bundleNames.split(":");
        if (namesArr == null) {
            System.err.println("Couldn't parse the resource bundles: <" + bundleNames + ">");
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String bundleName : namesArr) {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
            if (bundle == null) {
                System.err.println("Couldn't find the resource bundle: <" + bundleName + "> for locale <" + Locale.getDefault() + ">");
                continue;
            }
            result.addAll(bundle.keySet());
        }
        return result;
    }
}

