/*
 * Decompiled with CFR 0.152.
 */
package checkers.regex;

import checkers.basetype.BaseTypeChecker;
import checkers.regex.RegexChecker;
import checkers.regex.quals.Regex;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.types.TreeAnnotator;
import checkers.util.TreeUtils;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexAnnotatedTypeFactory
extends BasicAnnotatedTypeFactory<RegexChecker> {
    public RegexAnnotatedTypeFactory(RegexChecker checker, CompilationUnitTree root) {
        super(checker, root);
    }

    @Override
    public TreeAnnotator createTreeAnnotator(RegexChecker checker) {
        return new RegexTreeAnnotator(checker);
    }

    private static boolean isRegex(String str) {
        try {
            Pattern.compile(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private class RegexTreeAnnotator
    extends TreeAnnotator {
        public RegexTreeAnnotator(BaseTypeChecker checker) {
            super(checker, RegexAnnotatedTypeFactory.this);
        }

        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotated() && tree.getKind() == Tree.Kind.STRING_LITERAL && RegexAnnotatedTypeFactory.isRegex((String)tree.getValue())) {
                type.addAnnotation(Regex.class);
            }
            return super.visitLiteral(tree, type);
        }

        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotated() && TreeUtils.isStringConcatenation(tree)) {
                AnnotatedTypeMirror lExpr = RegexAnnotatedTypeFactory.this.getAnnotatedType(tree.getLeftOperand());
                AnnotatedTypeMirror rExpr = RegexAnnotatedTypeFactory.this.getAnnotatedType(tree.getRightOperand());
                if (lExpr.hasAnnotation(Regex.class) && rExpr.hasAnnotation(Regex.class)) {
                    type.addAnnotation(Regex.class);
                }
            }
            return (Void)super.visitBinary(tree, type);
        }
    }
}

