/*
 * Decompiled with CFR 0.152.
 */
package checkers.signature;

import checkers.basetype.BaseTypeChecker;
import checkers.signature.SignatureChecker;
import checkers.signature.quals.BinaryName;
import checkers.signature.quals.FieldDescriptor;
import checkers.signature.quals.SignatureBottom;
import checkers.signature.quals.SourceName;
import checkers.signature.quals.UnannotatedString;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.types.TreeAnnotator;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureAnnotatedTypeFactory
extends BasicAnnotatedTypeFactory<SignatureChecker> {
    private Pattern fqnPat = Pattern.compile("^[A-Za-z_][A-Za-z_0-9]*(\\.[A-Za-z_][A-Za-z_0-9]*)*(\\[\\])*$");
    private Pattern bnPat = Pattern.compile("^[A-Za-z_][A-Za-z_0-9]*(\\.[A-Za-z_][A-Za-z_0-9]*)*(\\$[A-Za-z_][A-Za-z_0-9]*)?(\\[\\])*$");
    private Pattern fdPat = Pattern.compile("^\\[*([BCDFIJSZ]|L[A-Za-z_][A-Za-z_0-9]*(/[A-Za-z_][A-Za-z_0-9]*)*(\\$[A-Za-z_][A-Za-z_0-9]*)?;)$");

    public SignatureAnnotatedTypeFactory(SignatureChecker checker, CompilationUnitTree root) {
        super(checker, root);
    }

    @Override
    public TreeAnnotator createTreeAnnotator(SignatureChecker checker) {
        return new SignatureTreeAnnotator(checker);
    }

    private Class<? extends Annotation> bestSignatureAnnotation(String s) {
        if (this.fdPat.matcher(s).matches()) {
            if (this.bnPat.matcher(s).matches()) {
                return SignatureBottom.class;
            }
            return FieldDescriptor.class;
        }
        if (this.bnPat.matcher(s).matches()) {
            if (this.fqnPat.matcher(s).matches()) {
                return SourceName.class;
            }
            return BinaryName.class;
        }
        return UnannotatedString.class;
    }

    private class SignatureTreeAnnotator
    extends TreeAnnotator {
        public SignatureTreeAnnotator(BaseTypeChecker checker) {
            super(checker, SignatureAnnotatedTypeFactory.this);
        }

        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotated() && tree.getKind() == Tree.Kind.STRING_LITERAL) {
                String s = (String)tree.getValue();
                type.addAnnotation(SignatureAnnotatedTypeFactory.this.bestSignatureAnnotation(s));
            }
            return super.visitLiteral(tree, type);
        }
    }
}

