/*
 * Decompiled with CFR 0.152.
 */
package checkers.source;

import checkers.compilermsgs.quals.CompilerMessageKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Result {
    private final Type type;
    private final List<DiagMessage> messages;
    public static final Result SUCCESS = new Result(Type.SUCCESS, null);

    public static Result failure(@CompilerMessageKey String messageKey, Object ... args) {
        return new Result(Type.FAILURE, Collections.singleton(new DiagMessage(messageKey, args)));
    }

    public static Result warning(@CompilerMessageKey String messageKey, Object ... args) {
        return new Result(Type.WARNING, Collections.singleton(new DiagMessage(messageKey, args)));
    }

    private Result(Type type, Collection<DiagMessage> messagePairs) {
        this.type = type;
        this.messages = new LinkedList<DiagMessage>();
        if (messagePairs != null) {
            for (DiagMessage msg : messagePairs) {
                String message = msg.getMessageKey();
                Object[] args = msg.getArgs();
                if (args != null) {
                    args = Arrays.copyOf(msg.getArgs(), args.length);
                }
                this.messages.add(new DiagMessage(message, args));
            }
        }
    }

    public Result merge(Result r) {
        if (r == null) {
            return this;
        }
        if (r.isSuccess() && this.isSuccess()) {
            return SUCCESS;
        }
        LinkedList<DiagMessage> messages = new LinkedList<DiagMessage>();
        messages.addAll(this.messages);
        messages.addAll(r.messages);
        return new Result(Type.merge(r.type, this.type), messages);
    }

    public boolean isSuccess() {
        return this.type == Type.SUCCESS;
    }

    public boolean isFailure() {
        return this.type == Type.FAILURE;
    }

    public boolean isWarning() {
        return this.type == Type.WARNING;
    }

    public List<String> getMessageKeys() {
        LinkedList<String> msgKeys = new LinkedList<String>();
        for (DiagMessage msg : this.getDiagMessages()) {
            msgKeys.add(msg.getMessageKey());
        }
        return Collections.unmodifiableList(msgKeys);
    }

    public List<DiagMessage> getDiagMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public String toString() {
        switch (this.type) {
            case FAILURE: {
                return "FAILURE: " + this.messages;
            }
            case WARNING: {
                return "WARNING: " + this.messages;
            }
        }
        return "SUCCESS";
    }

    public static class DiagMessage {
        @CompilerMessageKey
        private String message;
        private Object[] args;

        protected DiagMessage(@CompilerMessageKey String message, Object[] args) {
            this.message = message;
            this.args = args == null ? new Object[0] : Arrays.copyOf(args, args.length);
        }

        @CompilerMessageKey
        public String getMessageKey() {
            return this.message;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DiagMessage)) {
                return false;
            }
            DiagMessage other = (DiagMessage)obj;
            return this.message.equals(other.message) && Arrays.equals(this.args, other.args);
        }

        public String toString() {
            if (this.args.length == 0) {
                return this.message;
            }
            return this.message + " : " + Arrays.toString(this.args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SUCCESS,
        FAILURE,
        WARNING;


        public static final Type merge(Type a, Type b) {
            if (a == FAILURE || b == FAILURE) {
                return FAILURE;
            }
            if (a == WARNING || b == WARNING) {
                return WARNING;
            }
            return SUCCESS;
        }
    }
}

