/*
 * Decompiled with CFR 0.152.
 */
package checkers.source;

import checkers.compilermsgs.quals.CompilerMessageKey;
import checkers.nullness.quals.Nullable;
import checkers.source.Result;
import checkers.source.SourceVisitor;
import checkers.source.SupportedLintOptions;
import checkers.source.SuppressWarningsKey;
import checkers.types.AnnotatedTypeFactory;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.AbstractTypeProcessor;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.processing.JavacMessager;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceChecker
extends AbstractTypeProcessor {
    protected ProcessingEnvironment env;
    private static final String MSGS_FILE = "messages.properties";
    protected Properties messages;
    protected JavacMessager messager;
    protected Trees trees;
    protected CompilationUnitTree currentRoot;
    public TreePath currentPath;
    private boolean warns;
    private Pattern skipPattern;
    private Set<String> activeLints;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator").intern();
    private boolean warnedAboutSourceLevel = false;

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.env;
    }

    public AnnotatedTypeFactory createFactory(CompilationUnitTree root) {
        return new AnnotatedTypeFactory(this, root);
    }

    protected abstract SourceVisitor<?, ?> createSourceVisitor(CompilationUnitTree var1);

    public Properties getMessages() {
        if (this.messages != null) {
            return this.messages;
        }
        this.messages = new Properties();
        Stack checkers = new Stack();
        for (Class<?> currClass = this.getClass(); currClass != SourceChecker.class; currClass = currClass.getSuperclass()) {
            checkers.push(currClass);
        }
        checkers.push(SourceChecker.class);
        while (!checkers.empty()) {
            this.messages.putAll((Map<?, ?>)this.getProperties((Class)checkers.pop(), MSGS_FILE));
        }
        return this.messages;
    }

    private Pattern getSkipPattern(Map<String, String> options) {
        String pattern = "";
        if (options.containsKey("skipClasses")) {
            pattern = options.get("skipClasses");
        } else if (System.getProperty("checkers.skipClasses") != null) {
            pattern = System.getProperty("checkers.skipClasses");
        } else if (System.getenv("skipClasses") != null) {
            pattern = System.getenv("skipClasses");
        }
        if (pattern.equals("")) {
            pattern = "\\(";
        }
        return Pattern.compile(pattern);
    }

    private Set<String> createActiveLints(Map<String, String> options) {
        if (!options.containsKey("lint")) {
            return Collections.emptySet();
        }
        String lintString = options.get("lint");
        if (lintString == null) {
            return Collections.singleton("all");
        }
        HashSet<String> activeLint = new HashSet<String>();
        for (String s : lintString.split(",")) {
            activeLint.add(s);
            if (!s.equals("none")) continue;
            activeLint.add("-all");
        }
        return activeLint;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.env = processingEnv;
        this.skipPattern = this.getSkipPattern(processingEnv.getOptions());
        Trees trees = Trees.instance(processingEnv);
        assert (trees != null);
        this.trees = trees;
        this.messager = (JavacMessager)processingEnv.getMessager();
        this.messages = this.getMessages();
        this.warns = processingEnv.getOptions().containsKey("warns");
        this.activeLints = this.createActiveLints(processingEnv.getOptions());
    }

    @Override
    public void typeProcess(TypeElement e, TreePath p) {
        if (e == null) {
            System.err.println("Refusing to process empty TypeElement");
            return;
        }
        if (p == null) {
            System.err.println("Refusing to process empty TreePath in TypeElement: " + e);
            return;
        }
        Source source = Source.instance(((JavacProcessingEnvironment)this.env).getContext());
        if (!this.warnedAboutSourceLevel && !source.allowTypeAnnotations()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "-source " + source.name + " does not support type annotations");
            this.warnedAboutSourceLevel = true;
        }
        this.currentRoot = p.getCompilationUnit();
        this.currentPath = p;
        try {
            SourceVisitor<?, ?> visitor = this.createSourceVisitor(this.currentRoot);
            visitor.scan(p, null);
        }
        catch (Throwable exception) {
            String message = this.getClass().getSimpleName().replaceAll("Checker", "") + " processor threw unexpected exception when processing " + this.currentRoot.getSourceFile().getName();
            Error err = new Error(message, exception);
            err.printStackTrace();
            throw err;
        }
    }

    protected String fullMessageOf(String messageKey, String defValue) {
        String key = messageKey;
        while (!this.messages.containsKey(key)) {
            int dot = key.indexOf(46);
            if (dot < 0) {
                return defValue;
            }
            key = key.substring(dot + 1);
        }
        return this.messages.getProperty(key);
    }

    protected void message(Diagnostic.Kind kind, Object source, @CompilerMessageKey String msgKey, Object ... args) {
        assert (this.messages != null) : "null messages";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i] == null ? null : this.messages.getProperty(args[i].toString(), args[i].toString());
            }
        }
        if (kind == Diagnostic.Kind.NOTE) {
            System.err.println("(NOTE) " + String.format(msgKey, args));
            return;
        }
        String defaultFormat = String.format("(%s)", msgKey);
        String fmtString = this.env.getOptions() != null && this.env.getOptions().containsKey("nomsgtext") ? defaultFormat : this.fullMessageOf(msgKey, defaultFormat);
        String messageText = String.format(fmtString, args);
        if (LINE_SEPARATOR != "\n") {
            messageText = messageText.replaceAll("\n", LINE_SEPARATOR);
        }
        if (source instanceof Element) {
            this.messager.printMessage(kind, messageText, (Element)source);
        } else if (source instanceof Tree) {
            Trees.instance(this.env).printMessage(kind, messageText, (Tree)source, this.currentRoot);
        } else {
            throw new IllegalArgumentException("invalid position source: " + source.getClass().getName());
        }
    }

    private boolean checkSuppressWarnings(SuppressWarnings anno, String err) {
        if (anno == null) {
            return false;
        }
        Collection<String> swkeys = this.getSuppressWarningsKey();
        for (String suppressWarningValue : anno.value()) {
            for (String swKey : swkeys) {
                if (suppressWarningValue.equals(swKey)) {
                    return true;
                }
                String expected = swKey + ":" + err;
                if (!expected.contains(suppressWarningValue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldSuppressWarnings(Tree tree, String err) {
        Collection<String> swKeys = this.getSuppressWarningsKey();
        if (swKeys.isEmpty()) {
            return false;
        }
        TreePath path = this.trees.getPath(this.currentRoot, tree);
        if (path == null) {
            return false;
        }
        VariableTree var = TreeUtils.enclosingVariable(path);
        if (var != null && this.shouldSuppressWarnings(InternalUtils.symbol(var), err)) {
            return true;
        }
        MethodTree method = TreeUtils.enclosingMethod(path);
        if (method != null && this.shouldSuppressWarnings(InternalUtils.symbol(method), err)) {
            return true;
        }
        ClassTree cls = TreeUtils.enclosingClass(path);
        return cls != null && this.shouldSuppressWarnings(InternalUtils.symbol(cls), err);
    }

    private boolean shouldSuppressWarnings(@Nullable Element elt, String err) {
        if (elt == null) {
            return false;
        }
        return this.checkSuppressWarnings(elt.getAnnotation(SuppressWarnings.class), err) || this.shouldSuppressWarnings(elt.getEnclosingElement(), err);
    }

    public void report(Result r, Object src) {
        String err = r.getMessageKeys().iterator().next();
        if (src instanceof Tree && this.shouldSuppressWarnings((Tree)src, err)) {
            return;
        }
        if (src instanceof Element && this.shouldSuppressWarnings((Element)src, err)) {
            return;
        }
        if (r.isSuccess()) {
            return;
        }
        for (Result.DiagMessage msg : r.getDiagMessages()) {
            if (r.isFailure()) {
                this.message(this.warns ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.ERROR, src, msg.getMessageKey(), msg.getArgs());
                continue;
            }
            if (r.isWarning()) {
                this.message(Diagnostic.Kind.MANDATORY_WARNING, src, msg.getMessageKey(), msg.getArgs());
                continue;
            }
            this.message(Diagnostic.Kind.NOTE, src, msg.getMessageKey(), msg.getArgs());
        }
    }

    public final boolean getLintOption(String name) {
        return this.getLintOption(name, false);
    }

    public final boolean getLintOption(String name, boolean def) {
        if (!this.getSupportedLintOptions().contains(name)) {
            throw new IllegalArgumentException("illegal lint option: " + name);
        }
        if (this.activeLints.isEmpty()) {
            return def;
        }
        String tofind = name;
        while (tofind != null) {
            if (this.activeLints.contains(tofind)) {
                return true;
            }
            if (this.activeLints.contains(String.format("-%s", tofind))) {
                return false;
            }
            tofind = this.parentOfOption(tofind);
        }
        return def;
    }

    private String parentOfOption(String name) {
        if (name.equals("all")) {
            return null;
        }
        if (name.contains(":")) {
            return name.substring(0, name.lastIndexOf(58));
        }
        return "all";
    }

    public Set<String> getSupportedLintOptions() {
        SupportedLintOptions sl = this.getClass().getAnnotation(SupportedLintOptions.class);
        if (sl == null) {
            return Collections.emptySet();
        }
        String[] slValue = sl.value();
        assert (slValue != null);
        String[] lintArray = slValue;
        HashSet<String> lintSet = new HashSet<String>(lintArray.length);
        for (String s : lintArray) {
            lintSet.add(s);
        }
        return Collections.unmodifiableSet(lintSet);
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>();
        options.add("skipClasses");
        options.add("lint");
        options.add("nomsgtext");
        options.add("filenames");
        options.add("showchecks");
        options.add("stubs");
        options.add("nocheckjdk");
        options.add("warns");
        options.add("annotatedTypeParams");
        options.addAll(super.getSupportedOptions());
        return Collections.unmodifiableSet(options);
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        SupportedAnnotationTypes supported = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        if (supported != null) {
            throw new Error("@SupportedAnnotationTypes should not be written on any checker; supported annotation types are inherited from SourceChecker");
        }
        return Collections.singleton("*");
    }

    public Collection<String> getSuppressWarningsKey() {
        SuppressWarningsKey annotation = this.getClass().getAnnotation(SuppressWarningsKey.class);
        if (annotation != null) {
            return Collections.singleton(annotation.value());
        }
        String className = this.getClass().getSimpleName();
        int indexOfChecker = className.lastIndexOf("Checker");
        if (indexOfChecker == -1) {
            indexOfChecker = className.lastIndexOf("Subchecker");
        }
        String key = indexOfChecker == -1 ? className : className.substring(0, indexOfChecker);
        return Collections.singleton(key.trim().toLowerCase());
    }

    public Pattern getShouldSkip() {
        return this.skipPattern;
    }

    private Properties getProperties(Class<?> cls, String filePath) {
        Properties prop = new Properties();
        try {
            InputStream base = cls.getResourceAsStream(filePath);
            if (base == null) {
                return prop;
            }
            prop.load(base);
        }
        catch (IOException e) {
            System.err.println("Couldn't parse " + filePath + " file");
            e.printStackTrace();
        }
        return prop;
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        try {
            return SourceVersion.RELEASE_7;
        }
        catch (NoSuchFieldError e) {
            return SourceVersion.latest();
        }
    }
}

