/*
 * Decompiled with CFR 0.152.
 */
package checkers.tainting;

import checkers.basetype.BaseTypeChecker;
import checkers.tainting.TaintingChecker;
import checkers.tainting.quals.Untainted;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.types.TreeAnnotator;
import checkers.util.TreeUtils;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaintingAnnotatedTypeFactory
extends BasicAnnotatedTypeFactory<TaintingChecker> {
    public TaintingAnnotatedTypeFactory(TaintingChecker checker, CompilationUnitTree root) {
        super(checker, root);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator(TaintingChecker checker) {
        return new TaintingTreeAnnotator(checker);
    }

    private class TaintingTreeAnnotator
    extends TreeAnnotator {
        public TaintingTreeAnnotator(BaseTypeChecker checker) {
            super(checker, TaintingAnnotatedTypeFactory.this);
        }

        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringConcatenation(tree)) {
                AnnotatedTypeMirror lExpr = TaintingAnnotatedTypeFactory.this.getAnnotatedType(tree.getLeftOperand());
                AnnotatedTypeMirror rExpr = TaintingAnnotatedTypeFactory.this.getAnnotatedType(tree.getRightOperand());
                if (lExpr.hasAnnotation(Untainted.class) && rExpr.hasAnnotation(Untainted.class)) {
                    type.addAnnotation(Untainted.class);
                }
            }
            return (Void)super.visitBinary(tree, type);
        }
    }
}

