/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.types.AnnotatedTypeMirror;
import checkers.types.AnnotatedTypes;
import checkers.util.TypesUtils;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFromElement {
    public static void annotate(AnnotatedTypeMirror type, Element element) {
        if (element == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
        if (element.getKind().isField()) {
            TypeFromElement.annotate(type, (VariableElement)element);
        } else if (element instanceof TypeElement) {
            TypeFromElement.annotate((AnnotatedTypeMirror.AnnotatedDeclaredType)type, (TypeElement)element);
        } else if (element instanceof ExecutableElement) {
            TypeFromElement.annotate((AnnotatedTypeMirror.AnnotatedExecutableType)type, (ExecutableElement)element);
        } else if (element.getKind() == ElementKind.PARAMETER) {
            ExecutableElement execElt;
            Element enclosing = element.getEnclosingElement();
            if (enclosing instanceof ExecutableElement && (execElt = (ExecutableElement)enclosing).getParameters().contains(element)) {
                int param_index = execElt.getParameters().indexOf(element);
                for (Attribute.TypeCompound typeAnno : ((Symbol.MethodSymbol)execElt).typeAnnotations) {
                    if (typeAnno.position.type != TargetType.METHOD_PARAMETER_GENERIC_OR_ARRAY || typeAnno.position.parameter_index != param_index) continue;
                    TypeFromElement.annotate(type, typeAnno);
                }
            }
        } else if (element.getKind() == ElementKind.TYPE_PARAMETER) {
            ExecutableElement execElt;
            Element enclosing = element.getEnclosingElement();
            if (enclosing instanceof TypeElement) {
                TypeElement clsElt = (TypeElement)enclosing;
                if (clsElt.getTypeParameters().contains(element)) {
                    int param_index = clsElt.getTypeParameters().indexOf(element);
                    for (Attribute.TypeCompound typeAnno : ((Symbol.ClassSymbol)clsElt).typeAnnotations) {
                        switch (typeAnno.position.type) {
                            case CLASS_TYPE_PARAMETER_BOUND: 
                            case CLASS_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: {
                                if (typeAnno.position.parameter_index != param_index) break;
                                TypeFromElement.annotatePossibleBound(type, typeAnno);
                            }
                        }
                    }
                }
            } else if (enclosing instanceof ExecutableElement && (execElt = (ExecutableElement)enclosing).getTypeParameters().contains(element)) {
                int param_index = execElt.getTypeParameters().indexOf(element);
                for (Attribute.TypeCompound typeAnno : ((Symbol.MethodSymbol)execElt).typeAnnotations) {
                    switch (typeAnno.position.type) {
                        case METHOD_TYPE_PARAMETER: 
                        case METHOD_TYPE_PARAMETER_BOUND: 
                        case METHOD_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: {
                            if (typeAnno.position.parameter_index != param_index) break;
                            TypeFromElement.annotatePossibleBound(type, typeAnno);
                        }
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("illegal argument: " + (Object)((Object)element.getKind()));
        }
    }

    public static void annotate(AnnotatedTypeMirror type, VariableElement element) {
        if (!element.getKind().isField()) {
            throw new IllegalArgumentException("element is not a field: " + (Object)((Object)element.getKind()));
        }
        Symbol.VarSymbol symbol = (Symbol.VarSymbol)element;
        TypeFromElement.addAnnotationsToElt(type, symbol.getAnnotationMirrors());
        for (Attribute.TypeCompound anno : symbol.typeAnnotations) {
            TypeAnnotationPosition pos = anno.position;
            switch (pos.type) {
                case FIELD_GENERIC_OR_ARRAY: {
                    TypeFromElement.annotate(type, anno);
                }
            }
        }
    }

    public static void annotate(AnnotatedTypeMirror.AnnotatedDeclaredType type, TypeElement element) {
        Symbol.ClassSymbol symbol = (Symbol.ClassSymbol)element;
        type.addAnnotations(symbol.getAnnotationMirrors());
        List<AnnotatedTypeMirror> typeParameters = type.getTypeArguments();
        block4: for (Attribute.TypeCompound anno : symbol.typeAnnotations) {
            TypeAnnotationPosition pos = anno.position;
            switch (pos.type) {
                case CLASS_TYPE_PARAMETER: {
                    if (pos.parameter_index < 0 || pos.parameter_index >= typeParameters.size()) break;
                    AnnotatedTypeMirror typeParam = typeParameters.get(pos.parameter_index);
                    typeParam.addAnnotation(anno);
                    if (typeParam.getKind() != TypeKind.TYPEVAR) continue block4;
                    ((AnnotatedTypeMirror.AnnotatedTypeVariable)typeParam).getUpperBound().addAnnotation(anno);
                    break;
                }
                case CLASS_TYPE_PARAMETER_BOUND: 
                case CLASS_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: {
                    if (pos.parameter_index < 0 || pos.parameter_index >= typeParameters.size()) break;
                    List<AnnotatedTypeMirror> bounds = TypeFromElement.getBounds(typeParameters.get(pos.parameter_index));
                    if (pos.bound_index < 0 || pos.bound_index >= bounds.size()) break;
                    TypeFromElement.annotate(bounds.get(pos.bound_index), anno);
                }
            }
        }
    }

    public static void annotateSupers(List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes, TypeElement element) {
        Symbol.ClassSymbol symbol = (Symbol.ClassSymbol)element;
        boolean hasSuperClass = element.getSuperclass().getKind() != TypeKind.NONE;
        AnnotatedTypeMirror.AnnotatedDeclaredType superClassType = hasSuperClass ? supertypes.get(0) : null;
        List<AnnotatedTypeMirror.AnnotatedDeclaredType> superInterfaces = hasSuperClass ? TypeFromElement.tail(supertypes) : supertypes;
        for (Attribute.TypeCompound anno : symbol.typeAnnotations) {
            TypeAnnotationPosition pos = anno.position;
            switch (pos.type) {
                case CLASS_EXTENDS: 
                case CLASS_EXTENDS_GENERIC_OR_ARRAY: {
                    if (pos.type_index == -1 && superClassType != null) {
                        TypeFromElement.annotate((AnnotatedTypeMirror)superClassType, anno);
                        break;
                    }
                    if (pos.type_index < 0 || pos.type_index >= superInterfaces.size()) break;
                    TypeFromElement.annotate((AnnotatedTypeMirror)superInterfaces.get(pos.type_index), anno);
                }
            }
        }
    }

    public static void annotate(AnnotatedTypeMirror.AnnotatedExecutableType type, ExecutableElement element) {
        Symbol.MethodSymbol symbol = (Symbol.MethodSymbol)element;
        TypeFromElement.addAnnotationsToElt(type.getReturnType(), symbol.getAnnotationMirrors());
        List<AnnotatedTypeMirror> thrown = type.getThrownTypes();
        List<AnnotatedTypeMirror> params = type.getParameterTypes();
        List<AnnotatedTypeMirror.AnnotatedTypeVariable> typeParams = type.getTypeVariables();
        for (int i = 0; i < params.size(); ++i) {
            TypeFromElement.addAnnotationsToElt(params.get(i), element.getParameters().get(i).getAnnotationMirrors());
        }
        block9: for (Attribute.TypeCompound typeAnno : symbol.typeAnnotations) {
            TypeAnnotationPosition pos = typeAnno.position;
            switch (typeAnno.position.type) {
                case METHOD_RECEIVER: {
                    TypeFromElement.annotate((AnnotatedTypeMirror)type.getReceiverType(), typeAnno);
                    break;
                }
                case METHOD_RETURN: 
                case METHOD_RETURN_GENERIC_OR_ARRAY: {
                    TypeFromElement.annotate(type.getReturnType(), typeAnno);
                    break;
                }
                case METHOD_PARAMETER: 
                case METHOD_PARAMETER_GENERIC_OR_ARRAY: {
                    if (pos.parameter_index < 0 || pos.parameter_index >= params.size()) break;
                    TypeFromElement.annotate(params.get(pos.parameter_index), typeAnno);
                    break;
                }
                case THROWS: {
                    if (pos.type_index < 0 || pos.type_index >= thrown.size()) break;
                    TypeFromElement.annotate(thrown.get(pos.type_index), typeAnno);
                    break;
                }
                case METHOD_TYPE_PARAMETER: {
                    if (pos.parameter_index < 0 || pos.parameter_index >= typeParams.size()) break;
                    TypeFromElement.annotate((AnnotatedTypeMirror)typeParams.get(pos.parameter_index), typeAnno);
                    break;
                }
                case METHOD_TYPE_PARAMETER_BOUND: 
                case METHOD_TYPE_PARAMETER_BOUND_GENERIC_OR_ARRAY: {
                    if (pos.parameter_index < 0 || pos.parameter_index >= typeParams.size()) break;
                    List<AnnotatedTypeMirror> bounds = TypeFromElement.getBounds(typeParams.get(pos.parameter_index));
                    if (pos.bound_index < 0 || pos.bound_index >= bounds.size()) continue block9;
                    TypeFromElement.annotate(bounds.get(pos.bound_index), typeAnno);
                    break;
                }
            }
        }
    }

    static void addAnnotationsToElt(AnnotatedTypeMirror type, List<? extends AnnotationMirror> annotations) {
        AnnotatedTypes.innerMostType(type).addAnnotations(annotations);
    }

    static void clearAnnotationsFromElt(AnnotatedTypeMirror type) {
        AnnotatedTypes.innerMostType(type).clearAnnotations();
    }

    private static void annotate(AnnotatedTypeMirror type, Attribute.TypeCompound anno) {
        TypeAnnotationPosition pos = anno.position;
        if (!pos.type.hasLocation()) {
            type.addAnnotation(anno);
        } else {
            TypeFromElement.annotate(type, pos.location, Collections.singletonList(anno));
        }
    }

    private static void annotatePossibleBound(AnnotatedTypeMirror type, Attribute.TypeCompound anno) {
        if (!anno.position.type.hasBound()) {
            TypeFromElement.annotate(type, anno);
        } else {
            if (type.getKind() != TypeKind.TYPEVAR && type.getKind() != TypeKind.WILDCARD) {
                return;
            }
            List<AnnotatedTypeMirror> bounds = TypeFromElement.getBounds(type);
            int boundIndex = anno.position.bound_index;
            if (boundIndex >= 0 && boundIndex < bounds.size()) {
                TypeFromElement.annotate(bounds.get(boundIndex), anno);
            }
        }
    }

    private static void annotate(AnnotatedTypeMirror type, List<Integer> location, List<? extends AnnotationMirror> annotations) {
        if (location.isEmpty()) {
            type.addAnnotations(annotations);
        } else if (type.getKind() == TypeKind.DECLARED) {
            TypeFromElement.annotate((AnnotatedTypeMirror.AnnotatedDeclaredType)type, location, annotations);
        } else if (type.getKind() == TypeKind.ARRAY) {
            TypeFromElement.annotate((AnnotatedTypeMirror.AnnotatedArrayType)type, location, annotations);
        } else {
            throw new AssertionError((Object)"only declared and arrays can have assertions");
        }
    }

    private static void annotate(AnnotatedTypeMirror.AnnotatedDeclaredType type, List<Integer> location, List<? extends AnnotationMirror> annotations) {
        if (location.isEmpty()) {
            type.addAnnotations(annotations);
        } else if (location.get(0) < type.getTypeArguments().size()) {
            TypeFromElement.annotate(type.getTypeArguments().get(location.get(0)), TypeFromElement.tail(location), annotations);
        }
    }

    private static void annotate(AnnotatedTypeMirror.AnnotatedArrayType type, List<Integer> location, List<? extends AnnotationMirror> annotations) {
        if (location.isEmpty()) {
            type.addAnnotations(annotations);
        } else if (location.size() == 1) {
            List<AnnotatedTypeMirror> arrays;
            int arrayIndex = location.get(0);
            if (arrayIndex < (arrays = TypeFromElement.createArraysList(type)).size()) {
                arrays.get(arrayIndex).addAnnotations(annotations);
            }
        } else {
            throw new AssertionError((Object)("location too large: " + location));
        }
    }

    private static List<AnnotatedTypeMirror> createArraysList(AnnotatedTypeMirror.AnnotatedArrayType array) {
        AnnotatedTypeMirror type;
        LinkedList<AnnotatedTypeMirror> arrays = new LinkedList<AnnotatedTypeMirror>();
        for (type = array; type != null && type.getKind() == TypeKind.ARRAY; type = type.getComponentType()) {
            arrays.addFirst(type);
        }
        if (type != null) {
            arrays.addFirst(type);
        }
        return arrays;
    }

    private static <T> List<T> tail(List<T> list) {
        return list.subList(1, list.size());
    }

    private static List<AnnotatedTypeMirror> getBounds(AnnotatedTypeMirror type) {
        AnnotatedTypeMirror bound = null;
        if (type.getKind() == TypeKind.TYPEVAR) {
            bound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)type).getUpperBound();
        } else if (type.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType wt = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
            bound = wt.getExtendsBound() == null ? wt.getExtendsBound() : wt.getSuperBound();
        } else {
            throw new IllegalArgumentException("type has no bounds: " + (Object)((Object)type.getKind()));
        }
        if (bound == null) {
            return Collections.emptyList();
        }
        if (!TypesUtils.isAnonymousType(bound.getUnderlyingType())) {
            return Collections.singletonList(bound);
        }
        return Collections.unmodifiableList(bound.directSuperTypes());
    }
}

