/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.AnnotatedTypes;
import checkers.util.ElementUtils;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TypeFromTree
extends SimpleTreeVisitor<AnnotatedTypeMirror, AnnotatedTypeFactory> {
    private static Map<TypeElement, Boolean> isTypeCache = new IdentityHashMap<TypeElement, Boolean>();

    TypeFromTree() {
    }

    @Override
    public AnnotatedTypeMirror defaultAction(Tree node, AnnotatedTypeFactory f) {
        if (node == null) {
            throw new IllegalArgumentException("null tree");
        }
        throw new UnsupportedOperationException("conversion undefined for tree type " + (Object)((Object)node.getKind()));
    }

    static void addAnnotationsToElt(AnnotatedTypeMirror type, List<? extends AnnotationMirror> annotations) {
        AnnotatedTypeMirror innerType = AnnotatedTypes.innerMostType(type);
        for (AnnotationMirror annotationMirror : annotations) {
            if (TypeFromTree.isTypeAnnotation(annotationMirror)) {
                innerType.addAnnotation(annotationMirror);
                continue;
            }
            type.addAnnotation(annotationMirror);
        }
    }

    static void clearAnnotationsFromElt(AnnotatedTypeMirror type) {
        AnnotatedTypeMirror innerType = AnnotatedTypes.innerMostType(type);
        type.clearAnnotations();
        innerType.clearAnnotations();
        if (innerType.getKind() == TypeKind.TYPEVAR) {
            AnnotatedTypeMirror.AnnotatedTypeVariable typevar = (AnnotatedTypeMirror.AnnotatedTypeVariable)innerType;
            typevar.getUpperBound().clearAnnotations();
            typevar.getLowerBound().clearAnnotations();
        } else if (innerType.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType typevar = (AnnotatedTypeMirror.AnnotatedWildcardType)innerType;
            typevar.getExtendsBound().clearAnnotations();
            typevar.getSuperBound().clearAnnotations();
        }
    }

    private static boolean isTypeAnnotation(AnnotationMirror anno) {
        TypeElement elem = (TypeElement)anno.getAnnotationType().asElement();
        if (isTypeCache.containsKey(elem)) {
            return isTypeCache.get(elem);
        }
        boolean result = TypeFromTree.isTypeAnnotationImpl(elem);
        isTypeCache.put(elem, result);
        return result;
    }

    private static boolean isTypeAnnotationImpl(TypeElement type) {
        Target target = type.getAnnotation(Target.class);
        if (target == null) {
            return true;
        }
        for (ElementType et : target.value()) {
            if (et != ElementType.TYPE_USE) continue;
            return true;
        }
        return false;
    }

    static class TypeFromTypeTree
    extends TypeFromTree {
        public static final TypeFromTypeTree INSTANCE = new TypeFromTypeTree();
        private Map<Tree, AnnotatedTypeMirror> visitedBounds = new HashMap<Tree, AnnotatedTypeMirror>();

        private TypeFromTypeTree() {
        }

        public AnnotatedTypeMirror visitAnnotatedType(AnnotatedTypeTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type = (AnnotatedTypeMirror)this.visit(node.getUnderlyingType(), f);
            if (type == null) {
                type = f.toAnnotatedType(f.types.getNoType(TypeKind.NONE));
            }
            assert (AnnotatedTypeFactory.validAnnotatedType(type));
            type.addAnnotations(InternalUtils.annotationsFromTree(node));
            return type;
        }

        public AnnotatedTypeMirror visitArrayType(ArrayTypeTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror component = (AnnotatedTypeMirror)this.visit(node.getType(), f);
            AnnotatedTypeMirror result = f.type(node);
            assert (result instanceof AnnotatedTypeMirror.AnnotatedArrayType);
            ((AnnotatedTypeMirror.AnnotatedArrayType)result).setComponentType(component);
            return result;
        }

        public AnnotatedTypeMirror visitParameterizedType(ParameterizedTypeTree node, AnnotatedTypeFactory f) {
            LinkedList args = new LinkedList();
            for (Tree tree : node.getTypeArguments()) {
                args.add(this.visit(tree, f));
            }
            AnnotatedTypeMirror result = f.type(node);
            AnnotatedTypeMirror annotatedTypeMirror = (AnnotatedTypeMirror)this.visit(node.getType(), f);
            result.addAnnotations(annotatedTypeMirror.getAnnotations());
            if (result instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
                assert (result instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) : node + " --> " + result;
                ((AnnotatedTypeMirror.AnnotatedDeclaredType)result).setTypeArguments(args);
            }
            return result;
        }

        public AnnotatedTypeMirror visitPrimitiveType(PrimitiveTypeTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        public AnnotatedTypeMirror visitTypeParameter(TypeParameterTree node, AnnotatedTypeFactory f) {
            LinkedList<AnnotatedTypeMirror.AnnotatedDeclaredType> bounds = new LinkedList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
            for (Tree tree : node.getBounds()) {
                AnnotatedTypeMirror bound;
                if (this.visitedBounds.containsKey(tree) && f == this.visitedBounds.get((Object)tree).typeFactory) {
                    bound = this.visitedBounds.get(tree);
                } else {
                    this.visitedBounds.put(tree, f.type(tree));
                    bound = (AnnotatedTypeMirror)this.visit(tree, f);
                    this.visitedBounds.put(tree, bound);
                }
                bounds.add((AnnotatedTypeMirror.AnnotatedDeclaredType)bound);
            }
            AnnotatedTypeMirror.AnnotatedTypeVariable result = (AnnotatedTypeMirror.AnnotatedTypeVariable)f.type(node);
            List<? extends AnnotationMirror> list = InternalUtils.annotationsFromTree(node);
            if (f.canHaveAnnotatedTypeParameters()) {
                result.addAnnotations(list);
            }
            result.getUpperBound().addAnnotations(list);
            assert (result instanceof AnnotatedTypeMirror.AnnotatedTypeVariable);
            switch (bounds.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    result.setUpperBound((AnnotatedTypeMirror)bounds.get(0));
                    break;
                }
                default: {
                    AnnotatedTypeMirror.AnnotatedDeclaredType upperBound = (AnnotatedTypeMirror.AnnotatedDeclaredType)result.getUpperBound();
                    assert (TypesUtils.isAnonymousType(upperBound.getUnderlyingType()));
                    LinkedList<AnnotatedTypeMirror.AnnotatedDeclaredType> superBounds = bounds;
                    upperBound.setDirectSuperTypes(superBounds);
                }
            }
            return result;
        }

        public AnnotatedTypeMirror visitWildcard(WildcardTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror bound = (AnnotatedTypeMirror)this.visit(node.getBound(), f);
            AnnotatedTypeMirror result = f.type(node);
            assert (result instanceof AnnotatedTypeMirror.AnnotatedWildcardType);
            if (node.getKind() == Tree.Kind.SUPER_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setSuperBound(bound);
            } else if (node.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setExtendsBound(bound);
            }
            return result;
        }

        private AnnotatedTypeMirror forTypeVariable(AnnotatedTypeMirror type, AnnotatedTypeFactory f) {
            if (type.getKind() != TypeKind.TYPEVAR) {
                throw new IllegalArgumentException();
            }
            TypeParameterElement tpe = (TypeParameterElement)((TypeVariable)type.getUnderlyingType()).asElement();
            Element elt = tpe.getGenericElement();
            if (elt instanceof TypeElement) {
                TypeElement typeElt = (TypeElement)elt;
                int idx = typeElt.getTypeParameters().indexOf(tpe);
                ClassTree cls = (ClassTree)f.declarationFromElement(typeElt);
                AnnotatedTypeMirror result = (AnnotatedTypeMirror)this.visit(cls.getTypeParameters().get(idx), f);
                return result;
            }
            if (elt instanceof ExecutableElement) {
                ExecutableElement exElt = (ExecutableElement)elt;
                int idx = exElt.getTypeParameters().indexOf(tpe);
                MethodTree meth = (MethodTree)f.declarationFromElement(exElt);
                AnnotatedTypeMirror result = (AnnotatedTypeMirror)this.visit(meth.getTypeParameters().get(idx), f);
                return result;
            }
            throw new AssertionError();
        }

        public AnnotatedTypeMirror visitIdentifier(IdentifierTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type = f.type(node);
            if (type.getKind() == TypeKind.TYPEVAR) {
                return this.forTypeVariable(type, f);
            }
            return type;
        }

        public AnnotatedTypeMirror visitMemberSelect(MemberSelectTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type = f.type(node);
            if (type.getKind() == TypeKind.TYPEVAR) {
                return this.forTypeVariable(type, f);
            }
            return type;
        }
    }

    static class TypeFromClass
    extends TypeFromTree {
        public static final TypeFromClass INSTANCE = new TypeFromClass();
        Map<ClassTree, AnnotatedTypeMirror.AnnotatedDeclaredType> visited = new HashMap<ClassTree, AnnotatedTypeMirror.AnnotatedDeclaredType>();

        private TypeFromClass() {
        }

        public AnnotatedTypeMirror visitClass(ClassTree node, AnnotatedTypeFactory f) {
            if (this.visited.containsKey(node)) {
                return this.visited.get(node);
            }
            TypeElement elt = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror result = f.toAnnotatedType(elt.asType());
            result.setElement(elt);
            result.addAnnotations(elt.getAnnotationMirrors());
            assert (result instanceof AnnotatedTypeMirror.AnnotatedDeclaredType);
            AnnotatedTypeMirror.AnnotatedDeclaredType dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)result;
            this.visited.put(node, dt);
            LinkedList<AnnotatedTypeMirror> params = new LinkedList<AnnotatedTypeMirror>();
            for (Tree tree : node.getTypeParameters()) {
                params.add(f.fromTypeTree(tree));
            }
            dt.setTypeArguments(params);
            this.visited.remove(node);
            return result;
        }
    }

    static class TypeFromMember
    extends TypeFromTree {
        public static final TypeFromMember INSTANCE = new TypeFromMember();

        private TypeFromMember() {
        }

        public AnnotatedTypeMirror visitVariable(VariableTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror result = f.fromTypeTree(node.getType());
            VariableElement elt = TreeUtils.elementFromDeclaration(node);
            result.setElement(elt);
            JCTree ntype = (JCTree)node.getType();
            if (ntype.type.getKind() == TypeKind.TYPEVAR && !elt.getAnnotationMirrors().isEmpty()) {
                TypeFromMember.clearAnnotationsFromElt(result);
            }
            TypeFromMember.addAnnotationsToElt(result, elt.getAnnotationMirrors());
            return result;
        }

        public AnnotatedTypeMirror visitMethod(MethodTree node, AnnotatedTypeFactory f) {
            ExecutableElement elt = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror.AnnotatedExecutableType result = (AnnotatedTypeMirror.AnnotatedExecutableType)f.toAnnotatedType(elt.asType());
            result.setElement(elt);
            LinkedList paramTypes = new LinkedList();
            for (Tree tree : node.getParameters()) {
                paramTypes.add(this.visit(tree, f));
            }
            result.setParameterTypes(paramTypes);
            if (node.getReturnType() == null) {
                result.setReturnType(f.toAnnotatedType(f.types.getNoType(TypeKind.VOID)));
            } else {
                result.setReturnType(f.fromTypeTree(node.getReturnType()));
            }
            TypeFromMember.addAnnotationsToElt(result.getReturnType(), elt.getAnnotationMirrors());
            List<AnnotationMirror> receiverAnnos = InternalUtils.annotationsFromTypeAnnotationTrees(node.getReceiverAnnotations());
            if (ElementUtils.isStatic(elt)) {
                result.setReceiverType(null);
            } else {
                TypeElement enclElt = ElementUtils.enclosingClass(elt);
                AnnotatedTypeMirror annotatedTypeMirror = f.fromElement((Element)enclElt);
                assert (annotatedTypeMirror instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) : annotatedTypeMirror;
                AnnotatedTypeMirror.AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)annotatedTypeMirror;
                annotatedDeclaredType.clearAnnotations();
                annotatedDeclaredType.addAnnotations(receiverAnnos);
                if (TreeUtils.isConstructor(node)) {
                    annotatedDeclaredType.addAnnotations(elt.getAnnotationMirrors());
                }
                result.setReceiverType(annotatedDeclaredType);
            }
            LinkedList<AnnotatedTypeMirror.AnnotatedTypeVariable> linkedList = new LinkedList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
            for (Tree tree : node.getTypeParameters()) {
                AnnotatedTypeMirror annotatedTypeMirror = f.fromTypeTree(tree);
                assert (annotatedTypeMirror instanceof AnnotatedTypeMirror.AnnotatedTypeVariable);
                linkedList.add((AnnotatedTypeMirror.AnnotatedTypeVariable)annotatedTypeMirror);
            }
            result.setTypeVariables(linkedList);
            LinkedList<AnnotatedTypeMirror> throwsTypes = new LinkedList<AnnotatedTypeMirror>();
            for (Tree tree : node.getThrows()) {
                throwsTypes.add(f.fromTypeTree(tree));
            }
            result.setThrownTypes(throwsTypes);
            return result;
        }
    }

    static class TypeFromExpression
    extends TypeFromTree {
        public static final TypeFromExpression INSTANCE = new TypeFromExpression();

        private TypeFromExpression() {
        }

        public AnnotatedTypeMirror visitAnnotatedType(AnnotatedTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }

        public AnnotatedTypeMirror visitArrayAccess(ArrayAccessTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type = f.getAnnotatedType(node.getExpression());
            assert (type instanceof AnnotatedTypeMirror.AnnotatedArrayType);
            return ((AnnotatedTypeMirror.AnnotatedArrayType)type).getComponentType();
        }

        public AnnotatedTypeMirror visitAssignment(AssignmentTree node, AnnotatedTypeFactory f) {
            return (AnnotatedTypeMirror)this.visit(node.getVariable(), f);
        }

        public AnnotatedTypeMirror visitBinary(BinaryTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        public AnnotatedTypeMirror visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeFactory f) {
            return (AnnotatedTypeMirror)this.visit(node.getVariable(), f);
        }

        public AnnotatedTypeMirror visitConditionalExpression(ConditionalExpressionTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror falseType;
            AnnotatedTypes annoTypes = f.atypes;
            AnnotatedTypeMirror trueType = f.getAnnotatedType(node.getTrueExpression());
            if (trueType.equals(falseType = f.getAnnotatedType(node.getFalseExpression()))) {
                return trueType;
            }
            if (trueType.getKind() == TypeKind.NULL) {
                Set<AnnotationMirror> alub = f.qualHierarchy.leastUpperBound(trueType.getAnnotations(), falseType.getAnnotations());
                falseType.clearAnnotations();
                falseType.addAnnotations(alub);
                return falseType;
            }
            if (falseType.getKind() == TypeKind.NULL) {
                Set<AnnotationMirror> alub = f.qualHierarchy.leastUpperBound(trueType.getAnnotations(), falseType.getAnnotations());
                trueType.clearAnnotations();
                trueType.addAnnotations(alub);
                return trueType;
            }
            AnnotatedTypeMirror alub = f.type(node);
            TypeMirror lub = alub.getUnderlyingType();
            if (TypesUtils.isAnonymousType(lub)) {
                f.atypes.annotateAsLub(alub, trueType, falseType);
            } else {
                if ((trueType = annoTypes.asSuper(trueType, alub)).equals(falseType = annoTypes.asSuper(falseType, alub))) {
                    return trueType;
                }
                f.atypes.annotateAsLub(alub, trueType, falseType);
            }
            return alub;
        }

        public AnnotatedTypeMirror visitIdentifier(IdentifierTree node, AnnotatedTypeFactory f) {
            Element elt = TreeUtils.elementFromUse(node);
            if (node.getName().contentEquals("this") && elt.getKind() != ElementKind.CONSTRUCTOR) {
                return f.getSelfType(node);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType selfType = f.getImplicitReceiverType(node);
            if (selfType != null) {
                return f.atypes.asMemberOf((AnnotatedTypeMirror)selfType, elt);
            }
            return f.getAnnotatedType(elt);
        }

        public AnnotatedTypeMirror visitInstanceOf(InstanceOfTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        public AnnotatedTypeMirror visitLiteral(LiteralTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        public AnnotatedTypeMirror visitMemberSelect(MemberSelectTree node, AnnotatedTypeFactory f) {
            Element elt = TreeUtils.elementFromUse(node);
            if (elt.getKind().isClass() || elt.getKind().isInterface()) {
                return f.fromElement(elt);
            }
            if (!(node.getExpression() instanceof PrimitiveTypeTree)) {
                if (node.getIdentifier().contentEquals("this")) {
                    return f.getEnclosingType((TypeElement)InternalUtils.symbol(node.getExpression()), node);
                }
                AnnotatedTypeMirror t = f.getAnnotatedType(node.getExpression());
                if (t instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
                    return f.atypes.asMemberOf(t, elt);
                }
            }
            return f.fromElement(elt);
        }

        public AnnotatedTypeMirror visitMethodInvocation(MethodInvocationTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedExecutableType ex = f.methodFromUse(node);
            return ex.getReturnType();
        }

        public AnnotatedTypeMirror visitNewArray(NewArrayTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedArrayType result = (AnnotatedTypeMirror.AnnotatedArrayType)f.type(node);
            if (node.getType() == null) {
                return result;
            }
            this.annotateArrayAsArray(result, node, f);
            return result;
        }

        private AnnotatedTypeMirror descendBy(AnnotatedTypeMirror type, int depth) {
            AnnotatedTypeMirror result = type;
            while (depth > 0) {
                result = ((AnnotatedTypeMirror.AnnotatedArrayType)result).getComponentType();
                --depth;
            }
            return result;
        }

        private void annotateArrayAsArray(AnnotatedTypeMirror.AnnotatedArrayType result, NewArrayTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror treeElem = f.fromTypeTree(node.getType());
            boolean hasInit = node.getInitializers() != null;
            AnnotatedTypeMirror typeElem = this.descendBy(result, hasInit ? 1 : node.getDimensions().size());
            while (true) {
                typeElem.addAnnotations(treeElem.getAnnotations());
                if (!(treeElem instanceof AnnotatedTypeMirror.AnnotatedArrayType)) break;
                assert (typeElem instanceof AnnotatedTypeMirror.AnnotatedArrayType);
                treeElem = ((AnnotatedTypeMirror.AnnotatedArrayType)treeElem).getComponentType();
                typeElem = ((AnnotatedTypeMirror.AnnotatedArrayType)typeElem).getComponentType();
            }
            int idx = 0;
            AnnotatedTypeMirror level = result;
            while (level.getKind() == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType array = level;
                List<? extends AnnotationMirror> annos = InternalUtils.annotationsFromArrayCreation(node, idx++);
                array.addAnnotations(annos);
                level = array.getComponentType();
            }
            result.addAnnotations(InternalUtils.annotationsFromArrayCreation(node, -1));
        }

        private void annotateArrayAsCanonical(AnnotatedTypeMirror.AnnotatedArrayType result, NewArrayTree node, AnnotatedTypeFactory f) {
            this.annotateArrayAsArray(result, node, f);
        }

        public AnnotatedTypeMirror visitNewClass(NewClassTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedDeclaredType type = f.fromNewClass(node);
            if (node.getClassBody() != null) {
                DeclaredType dt = (DeclaredType)InternalUtils.typeOf(node);
                AnnotatedTypeMirror.AnnotatedDeclaredType anonType = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypeMirror.createType(dt, f.env, f);
                anonType.setElement(type.getElement());
                if (type.isAnnotated()) {
                    List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = Collections.singletonList(type);
                    anonType.setDirectSuperTypes(supertypes);
                    anonType.addAnnotations(type.getAnnotations());
                    f.postDirectSuperTypes(anonType, supertypes);
                }
                type = anonType;
            }
            return type;
        }

        public AnnotatedTypeMirror visitParenthesized(ParenthesizedTree node, AnnotatedTypeFactory f) {
            return (AnnotatedTypeMirror)this.visit(node.getExpression(), f);
        }

        public AnnotatedTypeMirror visitTypeCast(TypeCastTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node.getType());
        }

        public AnnotatedTypeMirror visitUnary(UnaryTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        public AnnotatedTypeMirror visitWildcard(WildcardTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror bound = (AnnotatedTypeMirror)this.visit(node.getBound(), f);
            AnnotatedTypeMirror result = f.type(node);
            assert (result instanceof AnnotatedTypeMirror.AnnotatedWildcardType);
            if (node.getKind() == Tree.Kind.SUPER_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setSuperBound(bound);
            } else if (node.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setExtendsBound(bound);
            }
            return result;
        }

        public AnnotatedTypeMirror visitPrimitiveType(PrimitiveTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }

        public AnnotatedTypeMirror visitArrayType(ArrayTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }
    }
}

