/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.util.AnnotationUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;

public class TypeHierarchy {
    private final QualifierHierarchy qualifierHierarchy;
    protected final Set<Element> visited;

    public TypeHierarchy(QualifierHierarchy qualifierHierarchy) {
        this.qualifierHierarchy = qualifierHierarchy;
        this.visited = new HashSet<Element>();
    }

    public final boolean isSubtype(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        boolean result = this.isSubtypeImpl(rhs, lhs);
        this.visited.clear();
        return result;
    }

    protected final boolean isSubtypeImpl(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        if (this.visited.contains(lhs.getElement())) {
            return true;
        }
        AnnotatedTypeMirror lhsBase = lhs;
        while (lhsBase.getKind() != rhs.getKind() && (lhsBase.getKind() == TypeKind.WILDCARD || lhsBase.getKind() == TypeKind.TYPEVAR)) {
            if (lhsBase.getKind() == TypeKind.WILDCARD && rhs.getKind() != TypeKind.WILDCARD) {
                AnnotatedTypeMirror.AnnotatedWildcardType wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)lhsBase;
                if (wildcard.getSuperBound() != null && this.isSubtypeImpl(rhs, wildcard.getSuperBound())) {
                    return true;
                }
                if ((lhsBase = ((AnnotatedTypeMirror.AnnotatedWildcardType)lhsBase).getExtendsBound()) == null || !lhsBase.isAnnotated()) {
                    return true;
                }
                this.visited.add(lhsBase.getElement());
                continue;
            }
            if (rhs.getKind() == TypeKind.WILDCARD) {
                rhs = ((AnnotatedTypeMirror.AnnotatedWildcardType)rhs).getExtendsBound();
                continue;
            }
            if (lhsBase.getKind() != TypeKind.TYPEVAR || rhs.getKind() == TypeKind.TYPEVAR) continue;
            AnnotatedTypeMirror.AnnotatedTypeVariable lhsb_atv = (AnnotatedTypeMirror.AnnotatedTypeVariable)lhsBase;
            Set<AnnotationMirror> lAnnos = lhsb_atv.getLowerBoundAnnotations();
            if (!lAnnos.isEmpty()) {
                return this.qualifierHierarchy.isSubtype(rhs.getAnnotations(), lAnnos);
            }
            return this.qualifierHierarchy.getBottomQualifier() == null ? rhs.getAnnotations().isEmpty() : rhs.getAnnotations().contains(this.qualifierHierarchy.getBottomQualifier());
        }
        if (lhsBase.getKind() == TypeKind.WILDCARD && rhs.getKind() == TypeKind.WILDCARD) {
            return this.isSubtype(((AnnotatedTypeMirror.AnnotatedWildcardType)rhs).getExtendsBound(), ((AnnotatedTypeMirror.AnnotatedWildcardType)lhsBase).getExtendsBound());
        }
        AnnotatedTypeMirror rhsBase = rhs.typeFactory.atypes.asSuper(rhs, lhsBase);
        if (rhsBase == null) {
            rhsBase = rhs;
        }
        if (!this.qualifierHierarchy.isSubtype(rhsBase.getAnnotations(), lhsBase.getAnnotations())) {
            return false;
        }
        if (lhs.getKind() == TypeKind.ARRAY && rhsBase.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror rhsComponent = ((AnnotatedTypeMirror.AnnotatedArrayType)rhsBase).getComponentType();
            AnnotatedTypeMirror lhsComponent = ((AnnotatedTypeMirror.AnnotatedArrayType)lhsBase).getComponentType();
            return this.isSubtypeAsArrayComponent(rhsComponent, lhsComponent);
        }
        if (lhsBase.getKind() == TypeKind.DECLARED && rhsBase.getKind() == TypeKind.DECLARED) {
            return this.isSubtypeTypeArguments((AnnotatedTypeMirror.AnnotatedDeclaredType)rhsBase, (AnnotatedTypeMirror.AnnotatedDeclaredType)lhsBase);
        }
        if (lhsBase.getKind() == TypeKind.TYPEVAR && rhsBase.getKind() == TypeKind.TYPEVAR) {
            AnnotatedTypeMirror rhsSuperClass = rhsBase;
            while (rhsSuperClass.getKind() == TypeKind.TYPEVAR) {
                if (lhsBase.equals(rhsSuperClass)) {
                    return true;
                }
                if (lhsBase.toString().equals(rhsSuperClass.toString())) {
                    return true;
                }
                rhsSuperClass = ((AnnotatedTypeMirror.AnnotatedTypeVariable)rhsSuperClass).getUpperBound();
            }
            Set<AnnotationMirror> las = ((AnnotatedTypeMirror.AnnotatedTypeVariable)lhsBase).getLowerBoundAnnotations();
            Set<AnnotationMirror> ras = ((AnnotatedTypeMirror.AnnotatedTypeVariable)rhsBase).getUpperBoundAnnotations();
            if (!las.isEmpty()) {
                return this.qualifierHierarchy.isSubtype(ras, las);
            }
            return this.qualifierHierarchy.getBottomQualifier() == null ? rhs.getAnnotations().isEmpty() : rhs.getAnnotations().contains(this.qualifierHierarchy.getBottomQualifier());
        }
        return true;
    }

    protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
        List<AnnotatedTypeMirror> rhsTypeArgs = rhs.getTypeArguments();
        List<AnnotatedTypeMirror> lhsTypeArgs = lhs.getTypeArguments();
        if (rhsTypeArgs.isEmpty() || lhsTypeArgs.isEmpty()) {
            return true;
        }
        assert (lhsTypeArgs.size() == rhsTypeArgs.size());
        for (int i = 0; i < lhsTypeArgs.size(); ++i) {
            if (this.isSubtypeAsTypeArgument(rhsTypeArgs.get(i), lhsTypeArgs.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubtypeAsTypeArgument(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        Set<AnnotationMirror> ras;
        if (lhs.getKind() == TypeKind.WILDCARD && rhs.getKind() != TypeKind.WILDCARD) {
            if (this.visited.contains(lhs.getElement())) {
                return true;
            }
            this.visited.add(lhs.getElement());
            lhs = ((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).getExtendsBound();
            if (lhs == null) {
                return true;
            }
            return this.isSubtypeImpl(rhs, lhs);
        }
        if (lhs.getKind() == TypeKind.WILDCARD && rhs.getKind() == TypeKind.WILDCARD) {
            return this.isSubtype(((AnnotatedTypeMirror.AnnotatedWildcardType)rhs).getExtendsBound(), ((AnnotatedTypeMirror.AnnotatedWildcardType)lhs).getExtendsBound());
        }
        if (lhs.getKind() == TypeKind.TYPEVAR && rhs.getKind() != TypeKind.TYPEVAR) {
            if (this.visited.contains(lhs.getElement())) {
                return true;
            }
            this.visited.add(lhs.getElement());
            return this.isSubtype(rhs, ((AnnotatedTypeMirror.AnnotatedTypeVariable)lhs).getUpperBound());
        }
        Set<AnnotationMirror> las = lhs.getAnnotations();
        if (!AnnotationUtils.areSame(las, ras = rhs.getAnnotations())) {
            return false;
        }
        if (lhs.getKind() == TypeKind.DECLARED && rhs.getKind() == TypeKind.DECLARED) {
            return this.isSubtypeTypeArguments((AnnotatedTypeMirror.AnnotatedDeclaredType)rhs, (AnnotatedTypeMirror.AnnotatedDeclaredType)lhs);
        }
        if (lhs.getKind() == TypeKind.ARRAY && rhs.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror rhsComponent = ((AnnotatedTypeMirror.AnnotatedArrayType)rhs).getComponentType();
            AnnotatedTypeMirror lhsComponent = ((AnnotatedTypeMirror.AnnotatedArrayType)lhs).getComponentType();
            return this.isSubtypeAsTypeArgument(rhsComponent, lhsComponent);
        }
        return true;
    }

    protected boolean isSubtypeAsArrayComponent(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
        return this.isSubtypeImpl(rhs, lhs);
    }
}

