/*
 * Decompiled with CFR 0.152.
 */
package checkers.types.visitors;

import checkers.types.AnnotatedTypeMirror;
import checkers.types.visitors.AnnotatedTypeVisitor;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedTypeScanner<R, P>
implements AnnotatedTypeVisitor<R, P> {
    protected Map<AnnotatedTypeMirror, R> visitedNodes = new IdentityHashMap<AnnotatedTypeMirror, R>();

    @Override
    public final R visit(AnnotatedTypeMirror t) {
        return this.visit(t, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final R visit(AnnotatedTypeMirror type, P p) {
        Map<AnnotatedTypeMirror, R> prev = this.visitedNodes;
        this.visitedNodes = new IdentityHashMap<AnnotatedTypeMirror, R>();
        try {
            R r = this.scan(type, p);
            return r;
        }
        finally {
            this.visitedNodes = prev;
        }
    }

    protected R scan(AnnotatedTypeMirror type, P p) {
        return type == null ? null : (R)type.accept(this, p);
    }

    protected R scan(Iterable<? extends AnnotatedTypeMirror> types, P p) {
        if (types == null) {
            return null;
        }
        R r = null;
        boolean first = true;
        for (AnnotatedTypeMirror annotatedTypeMirror : types) {
            r = (R)(first ? this.scan(annotatedTypeMirror, p) : this.scanAndReduce(annotatedTypeMirror, p, r));
            first = false;
        }
        return r;
    }

    protected R scanAndReduce(Iterable<? extends AnnotatedTypeMirror> types, P p, R r) {
        return this.reduce(this.scan(types, p), r);
    }

    public R scanAndReduce(AnnotatedTypeMirror type, P p, R r) {
        return this.reduce(this.scan(type, p), r);
    }

    protected R reduce(R r1, R r2) {
        if (r1 == null) {
            return r2;
        }
        return r1;
    }

    @Override
    public R visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, P p) {
        R r = this.scan(type.getTypeArguments(), p);
        return r;
    }

    @Override
    public R visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, P p) {
        R r = this.scan(type.getComponentType(), p);
        return r;
    }

    @Override
    public R visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, P p) {
        R r = this.scan(type.getReturnType(), p);
        r = this.scanAndReduce(type.getReceiverType(), p, r);
        r = this.scanAndReduce(type.getParameterTypes(), p, r);
        r = this.scanAndReduce(type.getThrownTypes(), p, r);
        r = this.scanAndReduce(type.getTypeVariables(), p, r);
        return r;
    }

    @Override
    public R visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, P p) {
        if (this.visitedNodes.containsKey(type)) {
            return this.visitedNodes.get(type);
        }
        R r = this.scan(type.getLowerBound(), p);
        this.visitedNodes.put(type, r);
        r = this.scanAndReduce(type.getUpperBound(), p, r);
        this.visitedNodes.put(type, r);
        return r;
    }

    @Override
    public R visitNoType(AnnotatedTypeMirror.AnnotatedNoType type, P p) {
        return null;
    }

    @Override
    public R visitNull(AnnotatedTypeMirror.AnnotatedNullType type, P p) {
        return null;
    }

    @Override
    public R visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, P p) {
        return null;
    }

    @Override
    public R visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, P p) {
        if (this.visitedNodes.containsKey(type)) {
            return this.visitedNodes.get(type);
        }
        R r = this.scan(type.getExtendsBound(), p);
        this.visitedNodes.put(type, r);
        r = this.scanAndReduce(type.getSuperBound(), p, r);
        this.visitedNodes.put(type, r);
        return r;
    }
}

