/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.source.SourceChecker;
import com.sun.source.util.AbstractTypeProcessor;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateChecker
extends AbstractTypeProcessor {
    List<SourceChecker> checkers;

    protected abstract Collection<Class<? extends SourceChecker>> getSupportedCheckers();

    public AggregateChecker() {
        Collection<Class<? extends SourceChecker>> checkerClasses = this.getSupportedCheckers();
        this.checkers = new ArrayList<SourceChecker>(checkerClasses.size());
        for (Class<? extends SourceChecker> checkerClass : checkerClasses) {
            try {
                SourceChecker instance = checkerClass.newInstance();
                this.checkers.add(instance);
            }
            catch (Exception e) {
                System.err.println("Couldn't instantiate an instance of " + checkerClass);
            }
        }
    }

    @Override
    public final void typeProcess(TypeElement element, TreePath tree) {
        for (SourceChecker checker : this.checkers) {
            checker.typeProcess(element, tree);
        }
    }

    @Override
    public void typeProcessingOver() {
        for (SourceChecker checker : this.checkers) {
            checker.typeProcessingOver();
        }
    }

    @Override
    public final void init(ProcessingEnvironment env) {
        super.init(env);
        for (SourceChecker checker : this.checkers) {
            checker.init(env);
        }
    }

    @Override
    public final Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>();
        for (SourceChecker checker : this.checkers) {
            options.addAll(checker.getSupportedOptions());
        }
        return options;
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        try {
            return SourceVersion.RELEASE_7;
        }
        catch (NoSuchFieldError e) {
            return SourceVersion.latest();
        }
    }
}

