/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.nullness.quals.Nullable;
import checkers.quals.DefaultLocation;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    private static AnnotationUtils instance;
    private final ProcessingEnvironment env;
    private final Elements elements;
    private final Trees trees;
    private static final Map<String, AnnotationMirror> annotationsFromNames;
    private static final Comparator<AnnotationMirror> ANNOTATION_ORDERING;

    public static AnnotationUtils getInstance(ProcessingEnvironment env) {
        if (instance == null || AnnotationUtils.instance.env != env) {
            instance = new AnnotationUtils(env);
        }
        return instance;
    }

    private AnnotationUtils(ProcessingEnvironment env) {
        this.env = env;
        this.elements = env.getElementUtils();
        Trees trees = Trees.instance(env);
        assert (trees != null);
        this.trees = trees;
    }

    public AnnotationMirror fromName(CharSequence name) {
        return this.fromName(name.toString());
    }

    public AnnotationMirror fromName(String name) {
        if (annotationsFromNames.containsKey(name)) {
            return annotationsFromNames.get(name);
        }
        final DeclaredType annoType = this.typeFromName(name);
        if (annoType == null) {
            return null;
        }
        if (annoType.asElement().getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new AssertionError((Object)(annoType + " is not an annotation"));
        }
        AnnotationMirror result = new AnnotationMirror(){
            String toString;
            {
                this.toString = "@" + annoType;
            }

            @Override
            public DeclaredType getAnnotationType() {
                return annoType;
            }

            @Override
            public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
                return Collections.emptyMap();
            }

            public String toString() {
                return this.toString;
            }
        };
        annotationsFromNames.put(name, result);
        return result;
    }

    public AnnotationMirror fromClass(Class<? extends Annotation> clazz) {
        return this.fromName(clazz.getCanonicalName());
    }

    private DeclaredType typeFromName(CharSequence name) {
        TypeElement typeElt = this.elements.getTypeElement(name);
        if (typeElt == null) {
            return null;
        }
        return (DeclaredType)typeElt.asType();
    }

    public Map<TypeElement, Set<DefaultLocation>> findDefaultLocations(TreePath path) {
        ClassTree cls;
        MethodTree method;
        Element typeElt = this.trees.getElement(path);
        if (typeElt == null && (method = TreeUtils.enclosingMethod(path)) != null) {
            typeElt = InternalUtils.symbol(method);
        }
        if (typeElt == null && (cls = TreeUtils.enclosingClass(path)) != null) {
            typeElt = InternalUtils.symbol(cls);
        }
        if (typeElt == null) {
            throw new IllegalArgumentException("no element or enclosing element");
        }
        return this.findDefaultLocations(typeElt);
    }

    public Map<TypeElement, Set<DefaultLocation>> findDefaultLocations(Element elt) {
        TypeElement defaultElt = this.elements.getTypeElement("checkers.quals.DefaultQualifier");
        assert (defaultElt != null) : "couldn't get element for @DefaultQualifier";
        HashMap<TypeElement, Set<Object>> locations = new HashMap<TypeElement, Set<Object>>();
        List<? extends AnnotationMirror> annos = elt.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annos) {
            if (!defaultElt.equals(annotationMirror.getAnnotationType().asElement())) continue;
            String name = AnnotationUtils.parseStringValue(annotationMirror, "value");
            TypeElement aElt = this.elements.getTypeElement(name);
            if (aElt == null) {
                throw new RuntimeException("illegal annotation name: " + name);
            }
            Set<DefaultLocation> locs = AnnotationUtils.parseEnumConstantArrayValue(annotationMirror, "types", DefaultLocation.class);
            if (!locations.containsKey(aElt)) {
                locations.put(aElt, new HashSet());
            }
            if (locs == null) continue;
            ((Set)locations.get(aElt)).addAll(locs);
        }
        Element encl = elt.getEnclosingElement();
        if (encl != null) {
            locations.putAll(this.findDefaultLocations(encl));
        }
        return Collections.unmodifiableMap(locations);
    }

    public static Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror ad) {
        if (ad == null) {
            return Collections.emptyMap();
        }
        HashMap<? extends ExecutableElement, ? extends AnnotationValue> valMap = new HashMap<ExecutableElement, AnnotationValue>();
        if (ad.getElementValues() != null) {
            valMap.putAll(ad.getElementValues());
        }
        for (ExecutableElement meth : ElementFilter.methodsIn(ad.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = meth.getDefaultValue();
            if (defaultValue == null || valMap.containsKey(meth)) continue;
            valMap.put(meth, defaultValue);
        }
        return valMap;
    }

    @Nullable
    private static <R> R parseAnnotationValue(AbstractAnnotationValueParser<R> parser, AnnotationMirror ad, String fieldName) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = AnnotationUtils.getElementValuesWithDefaults(ad);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
            ExecutableElement name = entry.getKey();
            AnnotationValue value = entry.getValue();
            Name eltName = name.getSimpleName();
            if (!fieldName.equals(eltName.toString())) continue;
            parser.visit(value);
            return parser.getValue();
        }
        return null;
    }

    @Nullable
    public static <R extends Enum<R>> Set<R> parseEnumConstantArrayValue(AnnotationMirror ad, String field, Class<R> enumType) {
        return (Set)AnnotationUtils.parseAnnotationValue(new EnumConstantArrayValueParser<R>(enumType), ad, field);
    }

    @Nullable
    public static String parseStringValue(AnnotationMirror ad, String field) {
        return AnnotationUtils.parseAnnotationValue(new StringValueParser(), ad, field);
    }

    @Nullable
    public static List<String> parseStringArrayValue(AnnotationMirror ad, String field) {
        return AnnotationUtils.parseAnnotationValue(new StringArrayValueParser(), ad, field);
    }

    @Nullable
    public static final Name annotationName(@Nullable AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        DeclaredType annoType = annotation.getAnnotationType();
        TypeElement elm = (TypeElement)annoType.asElement();
        return elm.getQualifiedName();
    }

    public static boolean areSame(@Nullable AnnotationMirror a1, @Nullable AnnotationMirror a2) {
        if (a1 != null && a2 != null) {
            return AnnotationUtils.annotationName(a1).equals(AnnotationUtils.annotationName(a2)) && a1.toString().equals(a2.toString());
        }
        return a1 == a2;
    }

    public static boolean areSameIgnoringValues(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 != null && a2 != null) {
            return AnnotationUtils.annotationName(a1).equals(AnnotationUtils.annotationName(a2));
        }
        return a1 == a2;
    }

    public static boolean areSame(Collection<AnnotationMirror> c1, Collection<AnnotationMirror> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1.size() == 1 && c2.size() == 1) {
            return AnnotationUtils.areSame(c1.iterator().next(), c2.iterator().next());
        }
        Set<AnnotationMirror> s1 = AnnotationUtils.createAnnotationSet();
        Set<AnnotationMirror> s2 = AnnotationUtils.createAnnotationSet();
        s1.addAll(c1);
        s2.addAll(c2);
        Iterator<AnnotationMirror> iter1 = s1.iterator();
        Iterator<AnnotationMirror> iter2 = s2.iterator();
        while (iter1.hasNext()) {
            AnnotationMirror anno2;
            AnnotationMirror anno1 = iter1.next();
            if (AnnotationUtils.areSame(anno1, anno2 = iter2.next())) continue;
            return false;
        }
        return true;
    }

    public static Comparator<AnnotationMirror> annotationOrdering() {
        return ANNOTATION_ORDERING;
    }

    public static <V> Map<AnnotationMirror, V> createAnnotationMap() {
        return new TreeMap(AnnotationUtils.annotationOrdering());
    }

    public static Set<AnnotationMirror> createAnnotationSet() {
        return new TreeSet<AnnotationMirror>(AnnotationUtils.annotationOrdering());
    }

    public static <T> T elementValue(AnnotationMirror anno, CharSequence name, Class<T> expectedType) {
        for (ExecutableElement executableElement : anno.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals(name)) continue;
            AnnotationValue val = anno.getElementValues().get(executableElement);
            return expectedType.cast(val.getValue());
        }
        throw new IllegalArgumentException("No element with name " + name + " in annotation " + anno);
    }

    public static boolean hasInheritiedMeta(AnnotationMirror anno) {
        return anno.getAnnotationType().asElement().getAnnotation(Inherited.class) != null;
    }

    static {
        annotationsFromNames = new HashMap<String, AnnotationMirror>();
        ANNOTATION_ORDERING = new Comparator<AnnotationMirror>(){

            @Override
            public int compare(AnnotationMirror a1, AnnotationMirror a2) {
                Name n2;
                Name n1;
                if (a1 == null || a2 == null) {
                    if (a1 == a2) {
                        return 0;
                    }
                    if (a1 == null) {
                        return -1;
                    }
                    if (a2 == null) {
                        return 1;
                    }
                }
                if ((n1 = AnnotationUtils.annotationName(a1)).equals(n2 = AnnotationUtils.annotationName(a2))) {
                    return 0;
                }
                int comp = n1.hashCode() - n2.hashCode();
                if (comp != 0) {
                    return comp;
                }
                return n1.toString().compareTo(n2.toString());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationBuilder {
        private final ProcessingEnvironment env;
        private final TypeElement annotationElt;
        private final DeclaredType annotationType;
        private final Map<ExecutableElement, AnnotationValue> elementValues;
        private boolean wasBuilt = false;

        public AnnotationBuilder(ProcessingEnvironment env, Class<? extends Annotation> anno) {
            this(env, anno.getCanonicalName());
        }

        public AnnotationBuilder(ProcessingEnvironment env, CharSequence name) {
            this.env = env;
            this.annotationElt = env.getElementUtils().getTypeElement(name);
            assert (this.annotationElt.getKind() == ElementKind.ANNOTATION_TYPE);
            this.annotationType = (DeclaredType)this.annotationElt.asType();
            this.elementValues = new LinkedHashMap<ExecutableElement, AnnotationValue>();
        }

        public AnnotationBuilder(ProcessingEnvironment env, AnnotationMirror annotation) {
            this.env = env;
            this.annotationType = annotation.getAnnotationType();
            this.annotationElt = (TypeElement)this.annotationType.asElement();
            this.elementValues = new LinkedHashMap<ExecutableElement, AnnotationValue>();
            this.elementValues.putAll(annotation.getElementValues());
        }

        private void assertNotBuilt() {
            if (this.wasBuilt) {
                throw new IllegalStateException("type was already built");
            }
        }

        public AnnotationMirror build() {
            this.assertNotBuilt();
            this.wasBuilt = true;
            return new AnnotationMirror(){

                @Override
                public DeclaredType getAnnotationType() {
                    return AnnotationBuilder.this.annotationType;
                }

                @Override
                public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
                    return Collections.unmodifiableMap(AnnotationBuilder.this.elementValues);
                }

                public String toString() {
                    StringBuilder buf = new StringBuilder();
                    buf.append("@");
                    buf.append(AnnotationBuilder.this.annotationType);
                    int len = AnnotationBuilder.this.elementValues.size();
                    if (len > 0) {
                        buf.append('(');
                        boolean first = true;
                        for (Map.Entry pair : AnnotationBuilder.this.elementValues.entrySet()) {
                            if (!first) {
                                buf.append(", ");
                            }
                            first = false;
                            String name = ((ExecutableElement)pair.getKey()).getSimpleName().toString();
                            if (len > 1 || !name.equals("value")) {
                                buf.append(name);
                                buf.append('=');
                            }
                            buf.append(pair.getValue());
                        }
                        buf.append(')');
                    }
                    return buf.toString();
                }
            };
        }

        public AnnotationBuilder setValue(CharSequence elementName, AnnotationMirror value) {
            this.setValue(elementName, (Object)value);
            return this;
        }

        public AnnotationBuilder setValue(CharSequence elementName, List<? extends Object> values) {
            this.assertNotBuilt();
            ArrayList<AnnotationValue> value = new ArrayList<AnnotationValue>();
            ExecutableElement var = this.findElement(elementName);
            TypeMirror expectedType = var.getReturnType();
            if (expectedType.getKind() != TypeKind.ARRAY) {
                throw new IllegalArgumentException("value is an array while expected type is not");
            }
            expectedType = ((ArrayType)expectedType).getComponentType();
            for (Object object : values) {
                this.checkSubtype(expectedType, object);
                value.add(this.createValue(object));
            }
            AnnotationValue val = this.createValue(value);
            this.elementValues.put(var, val);
            return this;
        }

        public AnnotationBuilder setValue(CharSequence elementName, Object[] values) {
            return this.setValue(elementName, Arrays.asList(values));
        }

        public AnnotationBuilder setValue(CharSequence elementName, Boolean value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, Character value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, Double value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, VariableElement value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, Float value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, Integer value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, Long value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, Short value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, String value) {
            return this.setValue(elementName, (Object)value);
        }

        public AnnotationBuilder setValue(CharSequence elementName, TypeMirror value) {
            this.assertNotBuilt();
            AnnotationValue val = this.createValue(value);
            ExecutableElement var = this.findElement(elementName);
            if (!TypesUtils.isClass(var.getReturnType())) {
                throw new IllegalArgumentException("expected " + var.getReturnType());
            }
            this.elementValues.put(var, val);
            return this;
        }

        private TypeMirror typeFromClass(Class<?> clazz) {
            if (clazz == Void.TYPE) {
                return this.env.getTypeUtils().getNoType(TypeKind.VOID);
            }
            if (clazz.isPrimitive()) {
                String primitiveName = clazz.getName().toUpperCase();
                TypeKind primitiveKind = TypeKind.valueOf(primitiveName);
                return this.env.getTypeUtils().getPrimitiveType(primitiveKind);
            }
            if (clazz.isArray()) {
                TypeMirror componentType = this.typeFromClass(clazz.getComponentType());
                return this.env.getTypeUtils().getArrayType(componentType);
            }
            TypeElement element = this.env.getElementUtils().getTypeElement(clazz.getCanonicalName());
            if (element == null) {
                throw new IllegalArgumentException("Unrecognized class: " + clazz);
            }
            return element.asType();
        }

        public AnnotationBuilder setValue(CharSequence elementName, Class<?> value) {
            return this.setValue(elementName, this.typeFromClass(value));
        }

        public AnnotationBuilder setValue(CharSequence elementName, Enum<?> value) {
            this.assertNotBuilt();
            VariableElement enumElt = this.findEnumElement(value);
            ExecutableElement var = this.findElement(elementName);
            if (var.getReturnType().getKind() != TypeKind.DECLARED) {
                throw new IllegalArgumentException("exptected a non enum: " + var.getReturnType());
            }
            if (!((DeclaredType)var.getReturnType()).asElement().equals(enumElt.getEnclosingElement())) {
                throw new IllegalArgumentException("expected a different type of enum: " + enumElt.getEnclosingElement());
            }
            this.elementValues.put(var, this.createValue(enumElt));
            return this;
        }

        private VariableElement findEnumElement(Enum<?> value) {
            String enumClass = value.getDeclaringClass().getCanonicalName();
            TypeElement enumClassElt = this.env.getElementUtils().getTypeElement(enumClass);
            assert (enumClassElt != null);
            for (Element element : enumClassElt.getEnclosedElements()) {
                if (!element.getSimpleName().contentEquals(value.name())) continue;
                return (VariableElement)element;
            }
            throw new AssertionError((Object)"cannot be here");
        }

        private AnnotationBuilder setValue(CharSequence key, Object value) {
            this.assertNotBuilt();
            AnnotationValue val = this.createValue(value);
            ExecutableElement var = this.findElement(key);
            this.checkSubtype(var.getReturnType(), value);
            this.elementValues.put(var, val);
            return this;
        }

        private ExecutableElement findElement(CharSequence key) {
            for (ExecutableElement elt : ElementFilter.methodsIn(this.annotationElt.getEnclosedElements())) {
                if (!elt.getSimpleName().contentEquals(key)) continue;
                return elt;
            }
            throw new IllegalArgumentException("Couldn't find " + key + " element in " + this.annotationElt);
        }

        private boolean checkSubtype(TypeMirror expected, Object givenValue) {
            boolean isSubtype;
            TypeMirror found;
            String newLine = System.getProperty("line.separator");
            Types types = this.env.getTypeUtils();
            if (expected.getKind().isPrimitive()) {
                expected = types.boxedClass((PrimitiveType)expected).asType();
            }
            if (expected.getKind() == TypeKind.DECLARED && TypesUtils.isClass(expected) && givenValue instanceof TypeMirror) {
                return true;
            }
            if (expected.getKind() == TypeKind.DECLARED && ((DeclaredType)expected).asElement().getKind() == ElementKind.ANNOTATION_TYPE && givenValue instanceof AnnotationMirror) {
                found = ((AnnotationMirror)givenValue).getAnnotationType();
                isSubtype = ((DeclaredType)expected).asElement().equals(found.asElement());
            } else if (givenValue instanceof AnnotationMirror) {
                found = ((AnnotationMirror)givenValue).getAnnotationType();
                isSubtype = false;
            } else {
                found = this.env.getElementUtils().getTypeElement(givenValue.getClass().getCanonicalName()).asType();
                isSubtype = types.isSubtype(types.erasure(found), types.erasure(expected));
            }
            if (!isSubtype) {
                throw new IllegalArgumentException("given value differs from expected" + newLine + "found: " + found + newLine + "expected: " + expected);
            }
            return true;
        }

        private AnnotationValue createValue(final Object obj) {
            return new AnnotationValue(){
                final Object value;
                {
                    this.value = obj;
                }

                @Override
                public Object getValue() {
                    return this.value;
                }

                @Override
                public String toString() {
                    if (this.value instanceof String) {
                        return "\"" + this.value.toString() + "\"";
                    }
                    if (this.value instanceof Character) {
                        return "'" + this.value.toString() + "'";
                    }
                    if (this.value instanceof List) {
                        StringBuilder sb = new StringBuilder();
                        List list = (List)this.value;
                        sb.append('{');
                        boolean isFirst = true;
                        for (Object o : list) {
                            if (!isFirst) {
                                sb.append(", ");
                            }
                            isFirst = false;
                            sb.append(o.toString());
                        }
                        sb.append('}');
                        return sb.toString();
                    }
                    return this.value.toString();
                }

                @Override
                public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
                    if (this.value instanceof AnnotationMirror) {
                        return v.visitAnnotation((AnnotationMirror)this.value, p);
                    }
                    if (this.value instanceof List) {
                        return v.visitArray((List)this.value, p);
                    }
                    if (this.value instanceof Boolean) {
                        return v.visitBoolean((Boolean)this.value, p);
                    }
                    if (this.value instanceof Character) {
                        return v.visitChar(((Character)this.value).charValue(), p);
                    }
                    if (this.value instanceof Double) {
                        return v.visitDouble((Double)this.value, p);
                    }
                    if (this.value instanceof VariableElement) {
                        return v.visitEnumConstant((VariableElement)this.value, p);
                    }
                    if (this.value instanceof Float) {
                        return v.visitFloat(((Float)this.value).floatValue(), p);
                    }
                    if (this.value instanceof Integer) {
                        return v.visitInt((Integer)this.value, p);
                    }
                    if (this.value instanceof Long) {
                        return v.visitLong((Long)this.value, p);
                    }
                    if (this.value instanceof Short) {
                        return v.visitShort((Short)this.value, p);
                    }
                    if (this.value instanceof String) {
                        return v.visitString((String)this.value, p);
                    }
                    if (this.value instanceof TypeMirror) {
                        return v.visitType((TypeMirror)this.value, p);
                    }
                    assert (false) : " unknown type : " + v.getClass();
                    return v.visitUnknown(this, p);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringArrayValueParser
    extends AbstractAnnotationValueParser<List<String>> {
        private final List<String> values = new ArrayList<String>();

        private StringArrayValueParser() {
        }

        @Override
        @Nullable
        public Void visitString(String s, Boolean p) {
            if (p == null || !p.booleanValue()) {
                return null;
            }
            this.values.add(s);
            return null;
        }

        @Override
        public List<String> getValue() {
            return Collections.unmodifiableList(this.values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringValueParser
    extends AbstractAnnotationValueParser<String> {
        @Nullable
        private String value = null;

        private StringValueParser() {
        }

        @Override
        @Nullable
        public Void visitString(String s, Boolean p) {
            this.value = s;
            return null;
        }

        @Override
        public String getValue() {
            assert (this.value != null);
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumConstantArrayValueParser<R extends Enum<R>>
    extends AbstractAnnotationValueParser<Set<R>> {
        private Set<R> values = new HashSet<R>();
        private Class<R> enumType;

        public EnumConstantArrayValueParser(Class<R> enumType) {
            this.enumType = enumType;
        }

        @Override
        @Nullable
        public Void visitEnumConstant(VariableElement c, Boolean p) {
            if (p == null || !p.booleanValue()) {
                return null;
            }
            R r = Enum.valueOf(this.enumType, c.getSimpleName().toString());
            assert (r != null);
            this.values.add(r);
            return null;
        }

        @Override
        public Set<R> getValue() {
            return Collections.unmodifiableSet(this.values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractAnnotationValueParser<A>
    extends SimpleAnnotationValueVisitor6<Void, Boolean> {
        private AbstractAnnotationValueParser() {
        }

        public abstract A getValue();

        @Override
        @Nullable
        public Void visitArray(List<? extends AnnotationValue> vals, Boolean p) {
            if (p != null && p.booleanValue()) {
                return null;
            }
            for (AnnotationValue annotationValue : vals) {
                this.visit(annotationValue, Boolean.TRUE);
            }
            return null;
        }
    }
}

