/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.Main;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckerMain {
    private static final String VERSION = "1";

    public static void main(String[] args) throws Exception {
        if (CheckerMain.isUsingJSR308Compiler()) {
            String[] newArgs = new String[args.length + 1];
            newArgs[0] = "-Xbootclasspath/p:" + CheckerMain.jdkJar();
            System.arraycopy(args, 0, newArgs, 1, args.length);
            Main.main(newArgs);
        } else {
            System.out.println("Manipulating bootclasspath");
            List<String> cmdArgs = CheckerMain.newCommandArgs(args);
            CheckerMain.execute(cmdArgs);
        }
    }

    static List<String> newCommandArgs(String[] currArgs) {
        ArrayList<String> args = new ArrayList<String>(currArgs.length + 5);
        args.add("java");
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        args.addAll(mxBean.getInputArguments());
        String jarPath = CheckerMain.findPathJar(CheckerMain.class);
        args.add("-Xbootclasspath/p:" + jarPath);
        args.add("-jar");
        args.add(jarPath);
        args.add("-Xbootclasspath/p:" + CheckerMain.jdkJar());
        args.addAll(Arrays.asList(currArgs));
        return args;
    }

    private static File tempJDKPath() {
        String userSupplied = System.getProperty("jsr308.jdk");
        if (userSupplied != null) {
            return new File(userSupplied);
        }
        String tmpFolder = System.getProperty("java.io.tmpdir");
        File jdkFile = new File(tmpFolder, "jdk-1.jar");
        return jdkFile;
    }

    private static String jdkJar() {
        String thisJar = CheckerMain.findPathJar(CheckerMain.class);
        File potential = new File(new File(thisJar).getParentFile(), "jdk.jar");
        if (potential.exists()) {
            return potential.getPath();
        }
        File jdkFile = CheckerMain.tempJDKPath();
        if (jdkFile.exists()) {
            return jdkFile.getPath();
        }
        try {
            CheckerMain.extractFile(thisJar, "jdk.jar", jdkFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (jdkFile.exists()) {
            return jdkFile.getPath();
        }
        throw new AssertionError((Object)"Couldn't find annotated JDK");
    }

    private static void extractFile(String jar, String fileName, File output) throws Exception {
        int currentByte;
        int BUFFER = 2048;
        File jarFile = new File(jar);
        ZipFile zip = new ZipFile(jarFile);
        ZipEntry entry = zip.getEntry(fileName);
        assert (!entry.isDirectory());
        BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
        byte[] data = new byte[BUFFER];
        FileOutputStream fos = new FileOutputStream(output);
        BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
        while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
            dest.write(data, 0, currentByte);
        }
        dest.flush();
        dest.close();
        is.close();
    }

    public static String findPathJar(Class<?> context) throws IllegalStateException {
        String rawName;
        int idx;
        String classFileName;
        String uri;
        if (context == null) {
            context = CheckerMain.class;
        }
        if ((uri = context.getResource(classFileName = ((idx = (rawName = context.getName()).lastIndexOf(46)) == -1 ? rawName : rawName.substring(idx + 1)) + ".class").toString()).startsWith("file:")) {
            throw new IllegalStateException("This class has been loaded from a directory and not from a jar file.");
        }
        if (!uri.startsWith("jar:file:")) {
            int idx2 = uri.indexOf(58);
            String protocol = idx2 == -1 ? "(unknown)" : uri.substring(0, idx2);
            throw new IllegalStateException("This class has been loaded remotely via the " + protocol + " protocol. Only loading from a jar on the local file system is supported.");
        }
        int idx3 = uri.indexOf(33);
        if (idx3 == -1) {
            throw new IllegalStateException("You appear to have loaded this class from a local jar file, but I can't make sense of the URL!");
        }
        try {
            String fileName = URLDecoder.decode(uri.substring("jar:file:".length(), idx3), Charset.defaultCharset().name());
            return new File(fileName).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("default charset doesn't exist. Your VM is borked.");
        }
    }

    static boolean isUsingJSR308Compiler() {
        try {
            Class<MethodTree> clazz = MethodTree.class;
            clazz.getMethod("getReceiverAnnotations", new Class[0]);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static String constructCommand(Iterable<String> args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append('\"');
            sb.append(arg.replace("\"", "\\\""));
            sb.append("\" ");
        }
        return sb.toString();
    }

    static void execute(Iterable<String> cmdArray) {
        String command = CheckerMain.constructCommand(cmdArray);
        CLibrary.INSTANCE.system(command);
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary("c", CLibrary.class);

        public int system(String var1);
    }
}

