/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.quals.Dependent;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.AnnotationUtils;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;

public class DependentTypes {
    private final AnnotatedTypeFactory factory;
    private final AnnotationUtils annoUtils;

    public DependentTypes(ProcessingEnvironment env, CompilationUnitTree root) {
        this.factory = new AnnotatedTypeFactory(env, null, root, null);
        this.annoUtils = AnnotationUtils.getInstance(env);
    }

    AnnotationMirror getResult(Dependent anno) {
        try {
            anno.result();
        }
        catch (MirroredTypeException exp) {
            Name valName = TypesUtils.getQualifiedName((DeclaredType)exp.getTypeMirror());
            return this.annoUtils.fromName(valName);
        }
        assert (false) : "shouldn't be here";
        return null;
    }

    AnnotationMirror getWhen(Dependent anno) {
        try {
            anno.when();
        }
        catch (MirroredTypeException exp) {
            Name valName = TypesUtils.getQualifiedName((DeclaredType)exp.getTypeMirror());
            return this.annoUtils.fromName(valName);
        }
        assert (false) : "shouldn't be here";
        return null;
    }

    public void doSubsitution(Element symbol, AnnotatedTypeMirror type, AnnotatedTypeMirror receiver) {
        Dependent dependentInfo = symbol.getAnnotation(Dependent.class);
        if (dependentInfo == null) {
            return;
        }
        if (receiver == null) {
            return;
        }
        AnnotationMirror ifpresent = this.getWhen(dependentInfo);
        if (receiver.hasAnnotation(ifpresent)) {
            type.clearAnnotations();
            AnnotationMirror then = this.getResult(dependentInfo);
            type.addAnnotation(then);
        }
    }

    public void handle(Tree tree, AnnotatedTypeMirror type) {
        if (!(tree instanceof ExpressionTree)) {
            return;
        }
        ExpressionTree expr = (ExpressionTree)tree;
        Element symbol = null;
        if (expr instanceof IdentifierTree) {
            symbol = TreeUtils.elementFromUse((IdentifierTree)expr);
        } else if (expr instanceof MemberSelectTree) {
            symbol = TreeUtils.elementFromUse((MemberSelectTree)expr);
        }
        if (symbol == null || !symbol.getKind().isField() && symbol.getKind() != ElementKind.LOCAL_VARIABLE) {
            return;
        }
        AnnotatedTypeMirror receiver = this.factory.getReceiver(expr);
        if (receiver != null) {
            this.doSubsitution(symbol, type, receiver);
        }
    }

    public void handleConstructor(NewClassTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        if (!(tree.getIdentifier() instanceof AnnotatedTypeTree)) {
            return;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = this.factory.getAnnotatedType(tree);
        ExecutableElement constructorElt = InternalUtils.constructor(tree);
        for (int i = 0; i < constructorElt.getParameters().size(); ++i) {
            Element parameter = constructorElt.getParameters().get(i);
            AnnotatedTypeMirror paramType = type.getParameterTypes().get(i);
            this.doSubsitution(parameter, paramType, dt);
        }
    }
}

