/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.quals.DefaultLocation;
import checkers.quals.DefaultQualifier;
import checkers.quals.DefaultQualifiers;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.util.AnnotationUtils;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierDefaults {
    private final AnnotatedTypeFactory factory;
    private final AnnotationUtils annoFactory;
    private AnnotationMirror absoluteDefaultAnno;
    private Set<DefaultLocation> absoluteDefaultLocs;
    private Map<String, String> qualifiedNameMap;
    private Map<Element, List<DefaultQualifier>> qualifierCache = new IdentityHashMap<Element, List<DefaultQualifier>>();
    private static AnnotationMirror WMD_localannot;

    public QualifierDefaults(AnnotatedTypeFactory factory, AnnotationUtils annoFactory) {
        this.factory = factory;
        this.annoFactory = annoFactory;
        this.qualifiedNameMap = new HashMap<String, String>();
        for (Name name : factory.getQualifierHierarchy().getTypeQualifiers()) {
            if (name == null) continue;
            String qualified = name.toString();
            String unqualified = qualified.substring(qualified.lastIndexOf(46) + 1);
            this.qualifiedNameMap.put(qualified, qualified);
            this.qualifiedNameMap.put(unqualified, qualified);
        }
    }

    public void setAbsoluteDefaults(AnnotationMirror absoluteDefaultAnno, Set<DefaultLocation> locations) {
        this.absoluteDefaultAnno = absoluteDefaultAnno;
        this.absoluteDefaultLocs = new HashSet<DefaultLocation>(locations);
    }

    public void annotateTypeElement(TypeElement elt, AnnotatedTypeMirror type) {
        this.applyDefaults(elt, type);
    }

    public void annotate(Element elt, AnnotatedTypeMirror type) {
        this.applyDefaults(elt, type);
    }

    public void annotate(Tree tree, AnnotatedTypeMirror type) {
        this.applyDefaults(tree, type);
    }

    private Element nearestEnclosing(Tree tree) {
        TreePath path = this.factory.getPath(tree);
        if (path == null) {
            return InternalUtils.symbol(tree);
        }
        for (Tree t : path) {
            switch (t.getKind()) {
                case VARIABLE: {
                    return TreeUtils.elementFromDeclaration((VariableTree)t);
                }
                case METHOD: {
                    return TreeUtils.elementFromDeclaration((MethodTree)t);
                }
                case CLASS: {
                    return TreeUtils.elementFromDeclaration((ClassTree)t);
                }
            }
        }
        return null;
    }

    private Element nearestEnclosingExceptLocal(Tree tree) {
        TreePath path = this.factory.getPath(tree);
        if (path == null) {
            return InternalUtils.symbol(tree);
        }
        Tree prev = null;
        for (Tree t : path) {
            switch (t.getKind()) {
                case VARIABLE: {
                    VariableTree vtree = (VariableTree)t;
                    ExpressionTree vtreeInit = vtree.getInitializer();
                    if (vtreeInit != null && prev == vtreeInit) {
                        VariableElement elt = TreeUtils.elementFromDeclaration((VariableTree)t);
                        DefaultQualifier d = elt.getAnnotation(DefaultQualifier.class);
                        DefaultQualifiers ds = elt.getAnnotation(DefaultQualifiers.class);
                        if (d == null && ds == null) break;
                    }
                    return TreeUtils.elementFromDeclaration((VariableTree)t);
                }
                case METHOD: {
                    return TreeUtils.elementFromDeclaration((MethodTree)t);
                }
                case CLASS: {
                    return TreeUtils.elementFromDeclaration((ClassTree)t);
                }
            }
            prev = t;
        }
        return null;
    }

    private void applyDefaults(Tree tree, AnnotatedTypeMirror type) {
        Element elt = null;
        switch (tree.getKind()) {
            case MEMBER_SELECT: {
                elt = TreeUtils.elementFromUse((MemberSelectTree)tree);
                break;
            }
            case IDENTIFIER: {
                elt = TreeUtils.elementFromUse((IdentifierTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                elt = TreeUtils.elementFromUse((MethodInvocationTree)tree);
                break;
            }
            default: {
                elt = this.nearestEnclosingExceptLocal(tree);
            }
        }
        if (elt != null) {
            this.applyDefaults(elt, type);
        }
    }

    private List<DefaultQualifier> defaultsAt(Element elt) {
        DefaultQualifiers ds;
        if (elt == null) {
            return Collections.emptyList();
        }
        if (this.qualifierCache.containsKey(elt)) {
            return this.qualifierCache.get(elt);
        }
        ArrayList<DefaultQualifier> qualifiers = new ArrayList<DefaultQualifier>();
        DefaultQualifier d = elt.getAnnotation(DefaultQualifier.class);
        if (d != null) {
            qualifiers.add(d);
        }
        if ((ds = elt.getAnnotation(DefaultQualifiers.class)) != null) {
            qualifiers.addAll(Arrays.asList(ds.value()));
        }
        Element parent = elt.getKind() == ElementKind.PACKAGE ? ((Symbol)elt).owner : elt.getEnclosingElement();
        List<DefaultQualifier> parentDefaults = this.defaultsAt(parent);
        if (qualifiers.isEmpty()) {
            qualifiers = parentDefaults;
        } else {
            qualifiers.addAll(parentDefaults);
        }
        this.qualifierCache.put(elt, qualifiers);
        return qualifiers;
    }

    private void applyDefaults(Element annotationScope, AnnotatedTypeMirror type) {
        List<DefaultQualifier> defaults = this.defaultsAt(annotationScope);
        for (DefaultQualifier dq : defaults) {
            this.applyDefault(annotationScope, dq, type);
        }
        if (this.absoluteDefaultAnno != null) {
            new DefaultApplier(annotationScope, this.absoluteDefaultLocs, type).scan(type, this.absoluteDefaultAnno);
        }
    }

    private void applyDefault(Element annotationScope, DefaultQualifier d, AnnotatedTypeMirror type) {
        AnnotationMirror anno;
        String name = d.value();
        if (this.qualifiedNameMap.containsKey(name)) {
            name = this.qualifiedNameMap.get(name);
        }
        if ((anno = this.annoFactory.fromName(name)) == null) {
            return;
        }
        new DefaultApplier(annotationScope, d.locations(), type).scan(type, anno);
    }

    public void setLocalDefault(AnnotationMirror localannot) {
        WMD_localannot = localannot;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultApplier
    extends AnnotatedTypeScanner<Void, AnnotationMirror> {
        private final Element elt;
        private final Collection<DefaultLocation> locations;
        private final AnnotatedTypeMirror type;
        private boolean isTypeVarExtends = false;

        public DefaultApplier(Element elt, DefaultLocation[] locations, AnnotatedTypeMirror type) {
            this(elt, Arrays.asList(locations), type);
        }

        public DefaultApplier(Element elt, Collection<DefaultLocation> locations, AnnotatedTypeMirror type) {
            this.elt = elt;
            this.locations = locations;
            this.type = type;
        }

        @Override
        public Void scan(AnnotatedTypeMirror t, AnnotationMirror p) {
            if (t == null || t.getKind() == TypeKind.NONE) {
                return null;
            }
            if (t.getKind() == TypeKind.WILDCARD || t.getKind() == TypeKind.TYPEVAR) {
                return (Void)super.scan(t, p);
            }
            if (this.elt.getKind() == ElementKind.LOCAL_VARIABLE && this.locations.contains((Object)DefaultLocation.ALL_EXCEPT_LOCALS) && t == this.type) {
                if (!t.isAnnotated() && WMD_localannot != null) {
                    t.addAnnotation(WMD_localannot);
                }
                return (Void)super.scan(t, p);
            }
            if (this.locations.contains((Object)DefaultLocation.UPPER_BOUNDS) && this.locations.size() == 1 && !this.isTypeVarExtends) {
                return (Void)super.scan(t, p);
            }
            if (!t.isAnnotated()) {
                t.addAnnotation(p);
            }
            return (Void)super.scan(t, p);
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType t, AnnotationMirror p) {
            return (Void)super.visitExecutable(t, p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotationMirror p) {
            if (this.visitedNodes.containsKey(type)) {
                return (Void)this.visitedNodes.get(type);
            }
            Void r = this.scan(type.getLowerBound(), p);
            this.visitedNodes.put(type, r);
            boolean prevIsTypeVarExtends = this.isTypeVarExtends;
            this.isTypeVarExtends = true;
            try {
                r = this.scanAndReduce(type.getUpperBound(), p, r);
            }
            finally {
                this.isTypeVarExtends = prevIsTypeVarExtends;
            }
            this.visitedNodes.put(type, r);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotationMirror p) {
            Void r;
            if (this.visitedNodes.containsKey(type)) {
                return (Void)this.visitedNodes.get(type);
            }
            boolean prevIsTypeVarExtends = this.isTypeVarExtends;
            this.isTypeVarExtends = true;
            try {
                r = this.scan(type.getExtendsBound(), p);
            }
            finally {
                this.isTypeVarExtends = prevIsTypeVarExtends;
            }
            this.visitedNodes.put(type, r);
            r = this.scanAndReduce(type.getSuperBound(), p, r);
            this.visitedNodes.put(type, r);
            return r;
        }
    }
}

