/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.basetype.BaseTypeChecker;
import checkers.quals.PolymorphicQualifier;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.AnnotatedTypes;
import checkers.types.QualifierHierarchy;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.types.visitors.SimpleAnnotatedTypeVisitor;
import checkers.util.AnnotationUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.util.SimpleTreeVisitor;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;

public class QualifierPolymorphism {
    private final AnnotatedTypeFactory factory;
    private final AnnotationUtils annoFactory;
    private final AnnotatedTypes atypes;
    private final Resolver resolver;
    private final Completer completer;
    protected final AnnotationMirror polyQual;
    protected final AnnotationMirror rootQual;
    private AnnotatedTypeScanner<Void, AnnotationMirror> replacer = new AnnotatedTypeScanner<Void, AnnotationMirror>(){

        @Override
        public Void scan(AnnotatedTypeMirror type, AnnotationMirror qual) {
            if (type != null && type.hasAnnotation(QualifierPolymorphism.this.polyQual)) {
                type.removeAnnotation(QualifierPolymorphism.this.polyQual);
                type.addAnnotation(qual);
            }
            return (Void)super.scan(type, qual);
        }
    };
    private final PolyCollector collector;

    public QualifierPolymorphism(BaseTypeChecker checker, AnnotatedTypeFactory factory) {
        this.factory = factory;
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        this.atypes = new AnnotatedTypes(env, factory);
        this.annoFactory = AnnotationUtils.getInstance(env);
        AnnotationMirror poly = null;
        AnnotationMirror root = null;
        for (Class<? extends Annotation> a : checker.getSupportedTypeQualifiers()) {
            if (a.getAnnotation(PolymorphicQualifier.class) == null) continue;
            if (poly != null) {
                throw new IllegalArgumentException("checker has multiple polymorphic qualifiers");
            }
            poly = this.annoFactory.fromClass(a);
        }
        root = checker.getQualifierHierarchy().getRootAnnotation();
        this.polyQual = poly;
        this.rootQual = root;
        this.collector = new PolyCollector();
        this.resolver = new Resolver();
        this.completer = new Completer();
    }

    public void annotate(Element elt, AnnotatedTypeMirror type) {
        if (this.polyQual == null) {
            return;
        }
        this.completer.visit(type);
    }

    public void annotate(MethodInvocationTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        if (this.polyQual == null) {
            return;
        }
        List<AnnotatedTypeMirror> arguments = this.atypes.getAnnotatedTypes(tree.getArguments());
        List<AnnotatedTypeMirror> requiredArgs = this.atypes.expandVarArgs(type, tree.getArguments());
        Map<String, AnnotationMirror> matchingMapping = this.collector.visit(arguments, requiredArgs);
        if ((matchingMapping = this.collector.reduce(matchingMapping, (Map)this.collector.visit(this.factory.getReceiver(tree), type.getReceiverType()))) != null && !matchingMapping.isEmpty()) {
            this.replacer.visit(type, matchingMapping.values().iterator().next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PolyCollector
    extends SimpleAnnotatedTypeVisitor<Map<String, AnnotationMirror>, AnnotatedTypeMirror> {
        private static final String KEY = "key";
        private final QualifierHierarchy hierarchy;
        private Set<TypeVariable> typeVar;

        private PolyCollector() {
            this.hierarchy = QualifierPolymorphism.this.factory.getQualifierHierarchy();
            this.typeVar = new HashSet<TypeVariable>();
        }

        public Map<String, AnnotationMirror> reduce(Map<String, AnnotationMirror> r1, Map<String, AnnotationMirror> r2) {
            if (r1 == null || r1.isEmpty()) {
                return r2;
            }
            if (r2 == null || r2.isEmpty()) {
                return r1;
            }
            AnnotationMirror a1Anno = r1.get(KEY);
            AnnotationMirror a2Anno = r2.get(KEY);
            AnnotationMirror lub = this.hierarchy.leastUpperBound(a1Anno, a2Anno);
            return Collections.singletonMap(KEY, lub);
        }

        public Map<String, AnnotationMirror> visit(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> actualTypes) {
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            Iterator<? extends AnnotatedTypeMirror> itert = types.iterator();
            Iterator<? extends AnnotatedTypeMirror> itera = actualTypes.iterator();
            while (itert.hasNext() && itera.hasNext()) {
                AnnotatedTypeMirror type = itert.next();
                AnnotatedTypeMirror actualType = itera.next();
                result = this.reduce(result, (Map)this.visit(type, actualType));
            }
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.typeVar.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.typeVar.add((TypeVariable)actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.typeVar.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
            }
            if (actualType.getKind() != type.getKind() || actualType == type) {
                return Collections.emptyMap();
            }
            assert (actualType.getKind() == type.getKind());
            type = (AnnotatedTypeMirror.AnnotatedDeclaredType)QualifierPolymorphism.this.atypes.asSuper(type, actualType);
            if (type == null) {
                return new HashMap<String, AnnotationMirror>();
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType dcType = (AnnotatedTypeMirror.AnnotatedDeclaredType)actualType;
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            if (dcType.hasAnnotation(QualifierPolymorphism.this.polyQual)) {
                AnnotationMirror typeQual = !type.isAnnotated() ? null : type.getAnnotations().iterator().next();
                result.put(KEY, typeQual);
            }
            if (type.isParameterized() && dcType.isParameterized()) {
                result = this.reduce(result, this.visit(type.getTypeArguments(), dcType.getTypeArguments()));
            }
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitNull(AnnotatedTypeMirror.AnnotatedNullType type, AnnotatedTypeMirror actualType) {
            if (actualType.hasAnnotation(QualifierPolymorphism.this.polyQual)) {
                AnnotationMirror typeQual = !type.isAnnotated() ? null : type.getAnnotations().iterator().next();
                return Collections.singletonMap(KEY, typeQual);
            }
            return (Map)super.visitNull(type, actualType);
        }

        @Override
        public Map<String, AnnotationMirror> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.DECLARED) {
                return (Map)this.visit(QualifierPolymorphism.this.atypes.asSuper(type, actualType), actualType);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.typeVar.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.typeVar.add((TypeVariable)actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.typeVar.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
            }
            assert (type.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedArrayType arType = (AnnotatedTypeMirror.AnnotatedArrayType)actualType;
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            if (arType.hasAnnotation(QualifierPolymorphism.this.polyQual)) {
                AnnotationMirror typeQual = !type.isAnnotated() ? null : type.getAnnotations().iterator().next();
                result.put(KEY, typeQual);
            }
            result = this.reduce(result, (Map)this.visit(type.getComponentType(), arType.getComponentType()));
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror actualType) {
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror typeSuper = this.findType(type, actualType);
            if (typeSuper.getKind() != TypeKind.TYPEVAR) {
                return (Map)this.visit(typeSuper, actualType);
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            assert (type.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedTypeVariable tvType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeSuper;
            this.typeVar.add(type.getUnderlyingType());
            Map result = (Map)this.visit(type.getUpperBound(), tvType.getUpperBound());
            this.typeVar.remove(type.getUnderlyingType());
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror typeSuper = this.findType(type, actualType);
            if (typeSuper.getKind() != TypeKind.WILDCARD) {
                return (Map)this.visit(typeSuper, actualType);
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedWildcardType wcType = (AnnotatedTypeMirror.AnnotatedWildcardType)typeSuper;
            if (type.getExtendsBound() != null && wcType.getExtendsBound() != null) {
                return (Map)this.visit(type.getExtendsBound(), wcType.getExtendsBound());
            }
            if (type.getSuperBound() != null && wcType.getSuperBound() != null) {
                return (Map)this.visit(type.getSuperBound(), wcType.getSuperBound());
            }
            return new HashMap<String, AnnotationMirror>();
        }

        private AnnotatedTypeMirror findType(AnnotatedTypeMirror type, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror result = QualifierPolymorphism.this.atypes.asSuper(type, actualType);
            return result != null ? result : type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Resolver
    extends SimpleTreeVisitor<Void, AnnotatedTypeMirror> {
        Resolver() {
        }

        private void resolve(MethodInvocationTree node, AnnotatedTypeMirror type, AnnotatedTypeMirror ret, List<AnnotatedTypeMirror> params, AnnotatedTypeMirror rcv) {
            if (ret.hasAnnotation(QualifierPolymorphism.this.polyQual)) {
                int i = 0;
                boolean flag = false;
                for (AnnotatedTypeMirror param : params) {
                    ExpressionTree arg = node.getArguments().get(i);
                    AnnotatedTypeMirror argType = QualifierPolymorphism.this.factory.getAnnotatedType(arg);
                    flag = this.resolveForType(param, argType, type, flag);
                    if (argType instanceof AnnotatedTypeMirror.AnnotatedDeclaredType && param instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
                        AnnotatedTypeMirror.AnnotatedDeclaredType argDecl = (AnnotatedTypeMirror.AnnotatedDeclaredType)argType;
                        AnnotatedTypeMirror.AnnotatedDeclaredType paramDecl = (AnnotatedTypeMirror.AnnotatedDeclaredType)param;
                        for (int j = 0; j < argDecl.getTypeArguments().size(); ++j) {
                            flag = this.resolveForType(paramDecl.getTypeArguments().get(j), argDecl.getTypeArguments().get(j), type, flag);
                        }
                    }
                    ++i;
                }
                if (flag) {
                    return;
                }
                if (rcv.hasAnnotation(QualifierPolymorphism.this.polyQual)) {
                    Set<AnnotationMirror> r = QualifierPolymorphism.this.factory.getReceiver(node).getAnnotations();
                    type.clearAnnotations();
                    type.addAnnotations(r);
                }
            }
        }

        private boolean resolveForType(AnnotatedTypeMirror decl, AnnotatedTypeMirror actual, AnnotatedTypeMirror type, boolean merge) {
            if (decl instanceof AnnotatedTypeMirror.AnnotatedWildcardType) {
                decl = ((AnnotatedTypeMirror.AnnotatedWildcardType)decl).getExtendsBound();
            }
            if (actual instanceof AnnotatedTypeMirror.AnnotatedWildcardType) {
                actual = ((AnnotatedTypeMirror.AnnotatedWildcardType)actual).getExtendsBound();
            }
            if (decl.hasAnnotation(QualifierPolymorphism.this.polyQual)) {
                if (!merge) {
                    type.clearAnnotations();
                    type.addAnnotations(actual.getAnnotations());
                    return true;
                }
                for (AnnotationMirror a : type.getAnnotations()) {
                    if (actual.hasAnnotation(a)) continue;
                    type.removeAnnotation(a);
                }
            }
            return false;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, AnnotatedTypeMirror p) {
            if (p == null) {
                return null;
            }
            ExecutableElement elt = TreeUtils.elementFromUse(node);
            AnnotatedTypeMirror.AnnotatedExecutableType ex = QualifierPolymorphism.this.factory.fromElement(elt);
            AnnotatedTypeMirror ret = ex.getReturnType();
            List<AnnotatedTypeMirror> params = QualifierPolymorphism.this.atypes.expandVarArgs(ex, node.getArguments());
            AnnotatedTypeMirror.AnnotatedDeclaredType rcv = ex.getReceiverType();
            this.resolve(node, p, ret, params, rcv);
            if (p instanceof AnnotatedTypeMirror.AnnotatedDeclaredType && ret instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
                AnnotatedTypeMirror.AnnotatedDeclaredType pDecl = (AnnotatedTypeMirror.AnnotatedDeclaredType)p;
                AnnotatedTypeMirror.AnnotatedDeclaredType rDecl = (AnnotatedTypeMirror.AnnotatedDeclaredType)ex.getReturnType();
                for (int i = 0; i < pDecl.getTypeArguments().size(); ++i) {
                    this.resolve(node, pDecl.getTypeArguments().get(i), rDecl.getTypeArguments().get(i), params, rcv);
                }
            } else if (p instanceof AnnotatedTypeMirror.AnnotatedArrayType && ret instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
                AnnotatedTypeMirror.AnnotatedArrayType pArray = (AnnotatedTypeMirror.AnnotatedArrayType)p;
                AnnotatedTypeMirror.AnnotatedArrayType rArray = (AnnotatedTypeMirror.AnnotatedArrayType)ret;
                this.resolve(node, pArray.getComponentType(), rArray.getComponentType(), params, rcv);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Completer
    extends AnnotatedTypeScanner<Void, Void> {
        Completer() {
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type, Void p) {
            if (type != null && type.hasAnnotation(QualifierPolymorphism.this.polyQual)) {
                type.removeAnnotation(QualifierPolymorphism.this.polyQual);
            }
            if (QualifierPolymorphism.this.rootQual != null && type != null && !type.isAnnotated()) {
                type.addAnnotation(QualifierPolymorphism.this.rootQual);
            }
            return (Void)super.scan(type, p);
        }
    }
}

