/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.nullness.quals.Nullable;
import checkers.util.ElementUtils;
import checkers.util.InternalUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtils {
    private TreeUtils() {
        throw new AssertionError((Object)"un-initializable class");
    }

    public static boolean isConstructor(MethodTree tree) {
        return tree.getName().contentEquals("<init>");
    }

    public static boolean isSelfAccess(ExpressionTree tree) {
        ExpressionTree tr = TreeUtils.skipParens(tree);
        if (tr.getKind() == Tree.Kind.ARRAY_ACCESS) {
            return false;
        }
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            tr = ((MethodInvocationTree)tree).getMethodSelect();
        }
        if ((tr = TreeUtils.skipParens(tr)).getKind() == Tree.Kind.TYPE_CAST) {
            tr = ((TypeCastTree)tr).getExpression();
        }
        if ((tr = TreeUtils.skipParens(tr)).getKind() == Tree.Kind.IDENTIFIER) {
            return true;
        }
        if (tr.getKind() == Tree.Kind.MEMBER_SELECT && (tr = ((MemberSelectTree)tr).getExpression()).getKind() == Tree.Kind.IDENTIFIER) {
            Name ident = ((IdentifierTree)tr).getName();
            return ident.contentEquals("this") || ident.contentEquals("super");
        }
        return false;
    }

    public static boolean isSuperCall(MethodInvocationTree tree) {
        ExpressionTree mst = tree.getMethodSelect();
        assert (mst != null);
        if (mst.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        MemberSelectTree selectTree = (MemberSelectTree)mst;
        if (selectTree.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        return ((IdentifierTree)selectTree.getExpression()).getName().contentEquals("super");
    }

    public static Tree enclosingOfKind(TreePath path, Tree.Kind kind) {
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            Tree leaf = p.getLeaf();
            assert (leaf != null);
            if (leaf.getKind() != kind) continue;
            return leaf;
        }
        return null;
    }

    public static <T extends Tree> T enclosingOfClass(TreePath path, Class<T> treeClass) {
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            Tree leaf = p.getLeaf();
            if (!treeClass.isInstance(leaf)) continue;
            return (T)((Tree)treeClass.cast(leaf));
        }
        return null;
    }

    @Nullable
    public static ClassTree enclosingClass(@Nullable TreePath path) {
        return (ClassTree)TreeUtils.enclosingOfKind(path, Tree.Kind.CLASS);
    }

    public static VariableTree enclosingVariable(TreePath path) {
        return (VariableTree)TreeUtils.enclosingOfKind(path, Tree.Kind.VARIABLE);
    }

    @Nullable
    public static MethodTree enclosingMethod(@Nullable TreePath path) {
        return (MethodTree)TreeUtils.enclosingOfKind(path, Tree.Kind.METHOD);
    }

    public static Tree skipParens(Tree tree) {
        Tree t = tree;
        while (t.getKind() == Tree.Kind.PARENTHESIZED) {
            t = ((ParenthesizedTree)t).getExpression();
        }
        return t;
    }

    public static ExpressionTree skipParens(ExpressionTree tree) {
        ExpressionTree t = tree;
        while (t.getKind() == Tree.Kind.PARENTHESIZED) {
            t = ((ParenthesizedTree)t).getExpression();
        }
        return t;
    }

    public static Tree getAssignmentContext(TreePath treePath) {
        TreePath path = treePath.getParentPath();
        if (path == null) {
            return null;
        }
        Tree node = path.getLeaf();
        if (node instanceof AssignmentTree || node instanceof CompoundAssignmentTree || node instanceof MethodInvocationTree || node instanceof NewArrayTree || node instanceof NewClassTree || node instanceof ReturnTree || node instanceof VariableTree) {
            return node;
        }
        return null;
    }

    public static final TypeElement elementFromDeclaration(ClassTree node) {
        assert (node != null) : "null node";
        TypeElement elt = (TypeElement)((Object)TreeInfo.symbolFor((JCTree)((Object)node)));
        return elt;
    }

    public static final ExecutableElement elementFromDeclaration(MethodTree node) {
        assert (node != null) : "null node";
        ExecutableElement elt = (ExecutableElement)((Object)TreeInfo.symbolFor((JCTree)((Object)node)));
        return elt;
    }

    public static final VariableElement elementFromDeclaration(VariableTree node) {
        assert (node != null) : "null node";
        VariableElement elt = (VariableElement)((Object)TreeInfo.symbolFor((JCTree)((Object)node)));
        return elt;
    }

    public static final ExecutableElement elementFromUse(MethodInvocationTree node) {
        return (ExecutableElement)((Object)TreeInfo.symbol((JCTree)((Object)node.getMethodSelect())));
    }

    public static final Element elementFromUse(IdentifierTree node) {
        return TreeInfo.symbol((JCTree)((Object)node));
    }

    public static final boolean isUseOfElement(Tree node) {
        switch (node.getKind()) {
            case IDENTIFIER: 
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: {
                return true;
            }
        }
        return false;
    }

    public static final Element elementFromUse(ExpressionTree node) {
        switch (node.getKind()) {
            case IDENTIFIER: 
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: {
                return TreeInfo.symbol((JCTree)((Object)node));
            }
        }
        throw new IllegalArgumentException("Tree not use: " + (Object)((Object)node.getKind()));
    }

    public static final ExecutableElement elementFromUse(NewClassTree node) {
        return (ExecutableElement)((Object)((JCTree.JCNewClass)node).constructor);
    }

    public static final Element elementFromUse(MemberSelectTree node) {
        return TreeInfo.symbol((JCTree)((Object)node));
    }

    public static final Name methodName(MethodInvocationTree node) {
        ExpressionTree expr = node.getMethodSelect();
        if (expr.getKind() == Tree.Kind.IDENTIFIER) {
            return ((IdentifierTree)expr).getName();
        }
        if (expr.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)expr).getIdentifier();
        }
        throw new AssertionError((Object)("cannot be here: " + node));
    }

    public static final boolean containsThisConstructorInvocation(MethodTree node) {
        if (!TreeUtils.isConstructor(node) || node.getBody().getStatements().isEmpty()) {
            return false;
        }
        StatementTree st = node.getBody().getStatements().get(0);
        if (!(st instanceof ExpressionStatementTree) || !(((ExpressionStatementTree)st).getExpression() instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree invocation = (MethodInvocationTree)((ExpressionStatementTree)st).getExpression();
        return "this".contentEquals(TreeUtils.methodName(invocation));
    }

    public static final Tree firstStatement(Tree tree) {
        BlockTree block;
        Tree first = tree.getKind() == Tree.Kind.BLOCK ? ((block = (BlockTree)tree).getStatements().isEmpty() ? block : (Tree)block.getStatements().iterator().next()) : tree;
        return first;
    }

    public static final boolean isDiamondTree(Tree tree) {
        switch (tree.getKind()) {
            case ANNOTATED_TYPE: {
                return TreeUtils.isDiamondTree(((AnnotatedTypeTree)tree).getUnderlyingType());
            }
            case PARAMETERIZED_TYPE: {
                return ((ParameterizedTypeTree)tree).getTypeArguments().isEmpty();
            }
            case NEW_CLASS: {
                return TreeUtils.isDiamondTree(((NewClassTree)tree).getIdentifier());
            }
        }
        return false;
    }

    public static final boolean isStringConcatenation(Tree tree) {
        return tree.getKind() == Tree.Kind.PLUS && TypesUtils.isDeclaredOfName(InternalUtils.typeOf(tree), String.class.getCanonicalName());
    }

    public static final boolean isStringCompoundConcatenation(CompoundAssignmentTree tree) {
        return tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT && TypesUtils.isDeclaredOfName(InternalUtils.typeOf(tree), String.class.getCanonicalName());
    }

    public static boolean isCompileTimeString(ExpressionTree node) {
        ExpressionTree tree = TreeUtils.skipParens(node);
        if (tree instanceof LiteralTree) {
            return true;
        }
        if (TreeUtils.isUseOfElement(tree)) {
            Element elt = TreeUtils.elementFromUse(tree);
            return ElementUtils.isCompileTimeConstant(elt);
        }
        if (TreeUtils.isStringConcatenation(tree)) {
            BinaryTree binOp = (BinaryTree)node;
            return TreeUtils.isCompileTimeString(binOp.getLeftOperand()) && TreeUtils.isCompileTimeString(binOp.getRightOperand());
        }
        return false;
    }

    public static ExpressionTree getReceiverTree(ExpressionTree expression) {
        if (expression.getKind() != Tree.Kind.METHOD_INVOCATION && expression.getKind() != Tree.Kind.MEMBER_SELECT && expression.getKind() != Tree.Kind.IDENTIFIER && expression.getKind() != Tree.Kind.ARRAY_ACCESS) {
            return null;
        }
        if (expression.getKind() == Tree.Kind.IDENTIFIER && "this".equals(expression.toString())) {
            return null;
        }
        ExpressionTree receiver = TreeUtils.skipParens(expression);
        if (receiver.getKind() == Tree.Kind.ARRAY_ACCESS) {
            return ((ArrayAccessTree)receiver).getExpression();
        }
        if (expression.getKind() == Tree.Kind.MEMBER_SELECT && ((MemberSelectTree)expression).getExpression() instanceof PrimitiveTypeTree) {
            return null;
        }
        if (TreeUtils.isSelfAccess(expression)) {
            return null;
        }
        if (receiver.getKind() == Tree.Kind.METHOD_INVOCATION) {
            receiver = ((MethodInvocationTree)receiver).getMethodSelect();
        }
        receiver = TreeUtils.skipParens(receiver);
        assert (receiver.getKind() == Tree.Kind.MEMBER_SELECT);
        if (receiver.getKind() == Tree.Kind.MEMBER_SELECT) {
            receiver = ((MemberSelectTree)receiver).getExpression();
        }
        return receiver;
    }
}

