/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class TypesUtils {
    private TypesUtils() {
        throw new AssertionError((Object)"un-initializable class");
    }

    public static Name getQualifiedName(DeclaredType type) {
        TypeElement element = (TypeElement)type.asElement();
        return element.getQualifiedName();
    }

    public static boolean isObject(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Object");
    }

    public static boolean isClass(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Class");
    }

    public static boolean isDeclaredOfName(TypeMirror type, CharSequence qualifiedName) {
        return type.getKind() == TypeKind.DECLARED && TypesUtils.getQualifiedName((DeclaredType)type).contentEquals(qualifiedName);
    }

    public static boolean isAnonymousType(TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED && TypesUtils.getQualifiedName((DeclaredType)type).length() == 0;
    }

    public static boolean isBoxedPrimitive(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String qualifiedName = TypesUtils.getQualifiedName((DeclaredType)type).toString();
        return qualifiedName.equals("java.lang.Boolean") || qualifiedName.equals("java.lang.Byte") || qualifiedName.equals("java.lang.Character") || qualifiedName.equals("java.lang.Short") || qualifiedName.equals("java.lang.Integer") || qualifiedName.equals("java.lang.Long") || qualifiedName.equals("java.lang.Double") || qualifiedName.equals("java.lang.Float");
    }

    public static boolean isThrowable(TypeMirror type) {
        while (type != null && type.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)type;
            TypeElement elem = (TypeElement)dt.asElement();
            Name name = elem.getQualifiedName();
            if ("java.lang.Throwable".contentEquals(name)) {
                return true;
            }
            type = elem.getSuperclass();
        }
        return false;
    }
}

