/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.stub;

import checkers.nullness.quals.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ExtendedAnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Skeleton
implements ClassVisitor {
    private final PrintWriter pw;
    private final String name;
    private final String base;
    private final String tab;
    private final StringBuffer buf;
    private final List<String> text;
    private final Set<String> visited;
    private boolean aborted = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean isEnum = false;

    public Skeleton(String name, String base, String tab, PrintWriter pw, Set<String> visited) {
        this.pw = pw;
        this.name = this.toClassName(name);
        this.base = base;
        this.tab = tab;
        this.buf = new StringBuffer();
        this.text = new LinkedList<String>();
        this.visited = visited == null ? new HashSet<String>() : visited;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length > 2) {
            System.err.println("usage: Skeleton [class name] [jar file]");
            return;
        }
        String baseDir = null;
        if (args.length == 1) {
            PrintWriter pw = new PrintWriter(System.out);
            Class<?> cls = Class.forName(args[0]);
            pw.println("package " + cls.getPackage().getName() + ";");
            pw.println();
            Skeleton.read(args[0], "", "  ", pw, new HashSet<String>());
        } else if (args.length == 2) {
            List<String> classes = Skeleton.getFiles(args[0], args[1], true);
            for (String className : classes) {
                try {
                    Skeleton.createDirForClass(className, baseDir);
                    Class<?> cls = Class.forName(className);
                    PrintWriter pw = new PrintWriter(new File(Skeleton.getClassFileName(className)));
                    pw.println("package " + cls.getPackage().getName() + ";");
                    pw.println();
                    Skeleton.read(className, "", "  ", pw, new HashSet<String>());
                    System.out.println("Output : " + className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getClassFileName(String className) {
        String classFileName = className.replace(".", "/");
        classFileName = classFileName + ".java";
        return classFileName;
    }

    public static boolean createDirForClass(String className, String baseDir) {
        String finalDirectory = className.substring(0, className.lastIndexOf(46));
        finalDirectory = finalDirectory.replace('.', '/');
        if (baseDir != null) {
            finalDirectory = baseDir.endsWith("/") ? baseDir + finalDirectory : baseDir + '/' + finalDirectory;
        }
        return new File(finalDirectory).mkdirs();
    }

    public static List<String> getFiles(String packageName, String jar, boolean subpackage) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        packageName = packageName.replaceAll("\\.$", "");
        if (!jar.endsWith(".jar")) {
            return Collections.emptyList();
        }
        JarFile jarFile = new JarFile(jar);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            String className;
            JarEntry entry = e.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class") || (className = entryName.replaceAll("\\.class$", "").replace("/", ".")).contains("$") || !".".equals(packageName) && !className.startsWith(packageName) || !subpackage && className.substring(packageName.length() + 1).contains(".")) continue;
            results.add(className);
        }
        return results;
    }

    public static void read(String className, String base, String tab, PrintWriter pw, @NonNull Set<String> visited) throws Exception {
        if (visited.contains(className)) {
            return;
        }
        ClassReader cr = new ClassReader(className);
        visited.add(className);
        cr.accept((ClassVisitor)new Skeleton(className, base, tab, pw, visited), false);
    }

    public static void read(InputStream classStream, String className, String base, String tab, PrintWriter pw, @NonNull Set<String> visited) throws Exception {
        if (visited.contains(className)) {
            return;
        }
        ClassReader cr = new ClassReader(classStream);
        visited.add(className);
        cr.accept((ClassVisitor)new Skeleton(className, base, tab, pw, visited), false);
    }

    private void appendAccess(int access, int suppress) {
        if ((access & ~suppress & 1) != 0) {
            this.buf.append("public ");
        }
        if ((access & ~suppress & 2) != 0) {
            this.buf.append("private ");
        }
        if ((access & ~suppress & 4) != 0) {
            this.buf.append("protected ");
        }
        if ((access & ~suppress & 0x10) != 0 && (access & ~suppress & 0x4000) == 0) {
            this.buf.append("final ");
        }
        if ((access & ~suppress & 8) != 0) {
            this.buf.append("static ");
        }
        if ((access & ~suppress & 0x20) != 0) {
            this.buf.append("synchronized ");
        }
        if ((access & ~suppress & 0x40) != 0) {
            this.buf.append("volatile ");
        }
        if ((access & ~suppress & 0x80) != 0) {
            this.buf.append("transient ");
        }
        if ((access & ~suppress & 0x100) != 0) {
            this.buf.append("native ");
        }
        if ((access & ~suppress & 0x400) != 0) {
            this.buf.append("abstract ");
        }
        if ((access & ~suppress & 0x800) != 0) {
            this.buf.append("strictfp ");
        }
        if ((access & ~suppress & 0x1000) != 0) {
            this.buf.append("synthetic ");
        }
    }

    private void appendType(int flags) {
        if ((flags & 0x2000) != 0) {
            this.buf.append("@interface");
        } else if ((flags & 0x200) != 0) {
            this.buf.append("interface ");
        } else if ((flags & 0x4000) != 0) {
            this.buf.append("enum ");
        } else {
            this.buf.append("class ");
        }
    }

    private void appendName(String name) {
        this.buf.append(this.toClassName(name));
    }

    private final String chooseSignature(String signature, String desc) {
        if (signature != null) {
            return signature;
        }
        if (desc != null) {
            return desc;
        }
        return null;
    }

    private void appendGenerics(int access, String signature) {
        if (signature == null) {
            return;
        }
        TraceSignatureVisitor sv = new TraceSignatureVisitor(access);
        SignatureReader r = new SignatureReader(signature);
        r.accept((SignatureVisitor)sv);
        this.buf.append(this.toClassName(sv.getDeclaration())).append(" ");
    }

    private void appendGenericsField(int access, String signature) {
        if (signature == null) {
            return;
        }
        TraceSignatureVisitor sv = new TraceSignatureVisitor(access);
        SignatureReader r = new SignatureReader(signature);
        r.accept((SignatureVisitor)sv);
        String str = this.toClassName(sv.getDeclaration());
        if (str.contains("<")) {
            str = str.substring(str.indexOf("<"));
        }
        this.buf.append(str);
    }

    private void appendFieldType(int access, String desc) {
        if (desc == null) {
            return;
        }
        TraceSignatureVisitor sv = new TraceSignatureVisitor(access);
        SignatureReader r = new SignatureReader(desc);
        r.acceptType((SignatureVisitor)sv);
        this.buf.append(this.adjustType(sv.getDeclaration()));
    }

    private void appendReturnType(int access, String signature, String desc) {
        String str = this.chooseSignature(signature, desc);
        if (str == null) {
            return;
        }
        TraceSignatureVisitor sv = new TraceSignatureVisitor(access);
        SignatureReader r = new SignatureReader(str);
        r.accept((SignatureVisitor)sv);
        String ret = sv.getReturnType();
        this.buf.append(this.adjustType(ret)).append(" ");
    }

    private String adjustType(String ret) {
        String type = ret.trim();
        if ((type = type.replace("$", ".")).length() == 0 || type.startsWith("[")) {
            type = "Object" + type;
        }
        return type;
    }

    private String formalAndTypeParams(int access, String signature, String desc) {
        String str = this.chooseSignature(signature, desc);
        if (str == null) {
            return null;
        }
        ArgumentSignatureVisitor sv = new ArgumentSignatureVisitor(access);
        SignatureReader r = new SignatureReader(str);
        r.accept((SignatureVisitor)sv);
        String params = sv.getParams();
        if ((access & 0x80) != 0) {
            int index = params.lastIndexOf("[]");
            params = params.substring(0, index) + "..." + params.substring(index + 2);
        }
        return params;
    }

    private void appendMethodTypeParams(int access, String signature, String desc) {
        String params = this.formalAndTypeParams(access, signature, desc);
        if (params == null) {
            return;
        }
        int paren = params.indexOf("(");
        if (paren > 0) {
            this.buf.append(params.substring(0, paren)).append(" ");
        }
    }

    private void appendParamType(int access, String signature, String desc) {
        String allparams = this.formalAndTypeParams(access, signature, desc);
        if (allparams == null) {
            return;
        }
        if (allparams.length() == 0) {
            this.buf.append("()");
        } else {
            int paren = allparams.indexOf("(");
            String params = this.adjustType(allparams.substring(paren));
            this.buf.append(params);
        }
    }

    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 5) == 0) {
            this.aborted = true;
            return;
        }
        this.isEnum = (access & 0x4000) != 0;
        this.buf.setLength(0);
        this.buf.append(this.base);
        this.appendAccess(access, 32);
        if (name.contains("$")) {
            this.buf.append("static ");
        }
        this.appendType(access);
        this.appendName(this.name.substring(this.name.lastIndexOf(46) + 1));
        this.buf.append(" ");
        if (signature != null) {
            if ((access & 0x4000) == 0) {
                this.appendGenerics(access, signature);
            }
        } else {
            if (superName != null && !this.toClassName(superName).equals("java.lang.Object") && (access & 0x4000) == 0) {
                this.buf.append("extends " + this.toClassName(superName) + " ");
            }
            if (interfaces != null && interfaces.length != 0) {
                this.buf.append((access & 0x200) == 0 ? "implements " : "extends ");
                this.buf.append(this.toClassName(interfaces[0]));
                for (int i = 1; i < interfaces.length; ++i) {
                    this.buf.append(", " + this.toClassName(interfaces[i]));
                }
                this.buf.append(" ");
            }
        }
        this.buf.append("{\n");
        this.text.add(this.buf.toString());
    }

    public void visitSource(String file, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new EmptyVisitor();
    }

    public ExtendedAnnotationVisitor visitExtendedAnnotation(String desc, boolean visible) {
        return new EmptyVisitor();
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.aborted) {
            return;
        }
        if (this.name.equals(name.replace('/', '.')) || !name.replace('/', '.').startsWith(this.name)) {
            return;
        }
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            Skeleton.read(name.replace('/', '.'), this.base + this.tab, this.tab, new PrintWriter(ba), this.visited);
            this.buf.setLength(0);
            this.buf.append(ba.toString());
        }
        catch (Exception e) {
            this.buf.append("// couldn't read inner class ").append(name);
        }
        this.text.add(this.buf.toString());
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.aborted) {
            return new EmptyVisitor();
        }
        if ((access & 5) != 0) {
            this.buf.setLength(0);
            this.buf.append(this.base).append(this.tab);
            if (!this.isEnum) {
                this.appendAccess(access, 16);
                this.appendFieldType(access, desc);
                this.appendGenericsField(access, signature);
                this.buf.append(" ");
            }
            this.appendName(name);
            if (value != null) {
                this.buf.append(" = ");
                if (value instanceof String) {
                    this.buf.append("\"").append(value).append("\"");
                } else {
                    this.buf.append(value);
                }
            }
            this.buf.append(this.isEnum ? (char)',' : ';');
            this.buf.append(LINE_SEPARATOR);
            this.text.add(this.buf.toString());
        }
        return new EmptyVisitor();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.aborted || name.equals("<clinit>") || name.equals("clone") || (access & 0x100) != 0 || (access & 0x1000) != 0) {
            return new EmptyVisitor();
        }
        if ((access & 5) != 0) {
            this.buf.setLength(0);
            this.buf.append(this.base).append(this.tab);
            if (this.isEnum && (name.equals("values") || name.equals("valueOf"))) {
                this.buf.append("//");
            }
            this.appendAccess(access, 192);
            this.appendMethodTypeParams(access, signature, desc);
            if (name.equals("<init>")) {
                this.appendName(this.name.substring(this.name.lastIndexOf(46) + 1));
            } else {
                this.appendReturnType(access, signature, desc);
                this.appendName(name);
            }
            this.appendParamType(access, signature, desc);
            if (exceptions != null && exceptions.length > 0) {
                this.buf.append(" throws ");
                this.appendName(exceptions[0]);
                for (int i = 1; i < exceptions.length; ++i) {
                    this.buf.append(", ");
                    this.appendName(exceptions[i]);
                }
            }
            if ((access & 0x500) != 0) {
                this.buf.append(";");
            } else {
                this.buf.append(" { throw new RuntimeException(\"skeleton method\"); }");
            }
            this.buf.append(LINE_SEPARATOR);
            this.text.add(this.buf.toString());
        }
        return new EmptyVisitor();
    }

    public void visitEnd() {
        if (this.aborted) {
            return;
        }
        this.text.add(this.base);
        this.text.add("}");
        this.text.add(LINE_SEPARATOR);
        for (String o : this.text) {
            this.pw.print(o.toString());
        }
        this.pw.flush();
        this.isEnum = false;
    }

    protected String toClassName(String name) {
        String result = name;
        result = name.trim();
        result = result.replace("/", ".");
        result = result.replace("$", ".");
        return result;
    }

    static class ArgumentSignatureVisitor
    extends TraceSignatureVisitor {
        private int pos = 0;
        private int arg = 0;
        private boolean finished = true;
        private boolean skip = false;
        private int skipCount = 0;
        private final StringBuffer local = new StringBuffer();

        public ArgumentSignatureVisitor(int access) {
            super(access);
        }

        public String getParams() {
            return this.local.toString();
        }

        private void updateLocal(boolean addArg) {
            if (this.finished || this.skip) {
                return;
            }
            this.local.append(super.getDeclaration().substring(this.pos));
            this.pos = super.getDeclaration().length();
            if (addArg) {
                this.local.append(" a" + ++this.arg);
            }
        }

        public SignatureVisitor visitParameterType() {
            this.finished = false;
            super.visitParameterType();
            this.local.append(super.getDeclaration().substring(this.pos));
            this.pos = super.getDeclaration().length();
            return this;
        }

        public SignatureVisitor visitReturnType() {
            super.visitReturnType();
            this.updateLocal(false);
            this.finished = true;
            return this;
        }

        public void visitBaseType(char descriptor) {
            super.visitBaseType(descriptor);
            this.updateLocal(true);
        }

        public void visitClassType(String name) {
            if (this.skip) {
                ++this.skipCount;
            }
            super.visitClassType(name);
        }

        public void visitTypeArgument() {
            super.visitTypeArgument();
        }

        public SignatureVisitor visitTypeArgument(char tag) {
            this.skip = true;
            super.visitTypeArgument(tag);
            return this;
        }

        public void visitTypeVariable(String name) {
            super.visitTypeVariable(name);
            this.updateLocal(true);
        }

        public void visitEnd() {
            this.skip = false;
            super.visitEnd();
            this.updateLocal(this.skipCount == 0);
            if (this.skipCount > 0) {
                --this.skipCount;
            }
        }
    }
}

