/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Flow
extends TreeScanner {
    protected static final Context.Key<Flow> flowKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Types types;
    private final Check chk;
    private TreeMaker make;
    private final Resolve rs;
    private Env<AttrContext> attrEnv;
    private Lint lint;
    private final boolean allowRethrowAnalysis;
    private boolean alive;
    Bits inits;
    Bits uninits;
    HashMap<Symbol, List<Type>> multicatchTypes;
    Bits uninitsTry;
    Bits initsWhenTrue;
    Bits initsWhenFalse;
    Bits uninitsWhenTrue;
    Bits uninitsWhenFalse;
    Symbol.VarSymbol[] vars;
    JCTree.JCClassDecl classDef;
    int firstadr;
    int nextadr;
    List<Type> thrown;
    List<Type> caught;
    Map<Symbol.VarSymbol, JCTree.JCVariableDecl> unrefdResources;
    boolean loopPassTwo = false;
    ListBuffer<PendingExit> pendingExits;
    private static final boolean ignoreAnnotatedCasts = true;

    public static Flow instance(Context context) {
        Flow instance = context.get(flowKey);
        if (instance == null) {
            instance = new Flow(context);
        }
        return instance;
    }

    protected Flow(Context context) {
        context.put(flowKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.chk = Check.instance(context);
        this.lint = Lint.instance(context);
        this.rs = Resolve.instance(context);
        Source source = Source.instance(context);
        this.allowRethrowAnalysis = source.allowMulticatch();
    }

    void errorUncaught() {
        PendingExit exit = this.pendingExits.next();
        while (exit != null) {
            boolean synthetic = this.classDef != null && this.classDef.pos == exit.tree.pos;
            this.log.error(exit.tree.pos(), synthetic ? "unreported.exception.default.constructor" : "unreported.exception.need.to.catch.or.throw", exit.thrown);
            exit = this.pendingExits.next();
        }
    }

    void markThrown(JCTree tree, Type exc) {
        if (!this.chk.isUnchecked(tree.pos(), exc)) {
            if (!this.chk.isHandled(exc, this.caught)) {
                this.pendingExits.append(new PendingExit(tree, exc));
            }
            this.thrown = this.chk.incl(exc, this.thrown);
        }
    }

    boolean trackable(Symbol.VarSymbol sym) {
        return sym.owner.kind == 16 || (sym.flags() & 0x200040010L) == 16L && this.classDef.sym.isEnclosedBy((Symbol.ClassSymbol)sym.owner);
    }

    void newVar(Symbol.VarSymbol sym) {
        if (this.nextadr == this.vars.length) {
            Symbol.VarSymbol[] newvars = new Symbol.VarSymbol[this.nextadr * 2];
            System.arraycopy(this.vars, 0, newvars, 0, this.nextadr);
            this.vars = newvars;
        }
        sym.adr = this.nextadr;
        this.vars[this.nextadr] = sym;
        this.inits.excl(this.nextadr);
        this.uninits.incl(this.nextadr);
        ++this.nextadr;
    }

    void letInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
        if (sym.adr >= this.firstadr && this.trackable(sym)) {
            if ((sym.flags() & 0x10L) != 0L) {
                if ((sym.flags() & 0x200000000L) != 0L) {
                    if ((sym.flags() & 0x8000000000L) != 0L) {
                        this.log.error(pos, "multicatch.parameter.may.not.be.assigned", sym);
                    } else {
                        this.log.error(pos, "final.parameter.may.not.be.assigned", sym);
                    }
                } else if (!this.uninits.isMember(sym.adr)) {
                    this.log.error(pos, this.loopPassTwo ? "var.might.be.assigned.in.loop" : "var.might.already.be.assigned", sym);
                } else if (!this.inits.isMember(sym.adr)) {
                    this.uninits.excl(sym.adr);
                    this.uninitsTry.excl(sym.adr);
                } else {
                    this.uninits.excl(sym.adr);
                }
            }
            this.inits.incl(sym.adr);
        } else if ((sym.flags() & 0x10L) != 0L) {
            this.log.error(pos, "var.might.already.be.assigned", sym);
        }
    }

    void letInit(JCTree tree) {
        if ((tree = TreeInfo.skipParens(tree)).getTag() == 35 || tree.getTag() == 34) {
            Symbol sym = TreeInfo.symbol(tree);
            this.letInit(tree.pos(), (Symbol.VarSymbol)sym);
        }
    }

    void checkInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
        if ((sym.adr >= this.firstadr || sym.owner.kind != 2) && this.trackable(sym) && !this.inits.isMember(sym.adr)) {
            this.log.error(pos, "var.might.not.have.been.initialized", sym);
            this.inits.incl(sym.adr);
        }
    }

    void recordExit(JCTree tree) {
        this.pendingExits.append(new PendingExit(tree, this.inits, this.uninits));
        this.markDead();
    }

    boolean resolveBreaks(JCTree tree, ListBuffer<PendingExit> oldPendingExits) {
        boolean result = false;
        List<PendingExit> exits = this.pendingExits.toList();
        this.pendingExits = oldPendingExits;
        while (exits.nonEmpty()) {
            PendingExit exit = (PendingExit)exits.head;
            if (exit.tree.getTag() == 21 && ((JCTree.JCBreak)exit.tree).target == tree) {
                this.inits.andSet(exit.inits);
                this.uninits.andSet(exit.uninits);
                result = true;
            } else {
                this.pendingExits.append(exit);
            }
            exits = exits.tail;
        }
        return result;
    }

    boolean resolveContinues(JCTree tree) {
        boolean result = false;
        List<PendingExit> exits = this.pendingExits.toList();
        this.pendingExits = new ListBuffer();
        while (exits.nonEmpty()) {
            PendingExit exit = (PendingExit)exits.head;
            if (exit.tree.getTag() == 22 && ((JCTree.JCContinue)exit.tree).target == tree) {
                this.inits.andSet(exit.inits);
                this.uninits.andSet(exit.uninits);
                result = true;
            } else {
                this.pendingExits.append(exit);
            }
            exits = exits.tail;
        }
        return result;
    }

    void markDead() {
        this.inits.inclRange(this.firstadr, this.nextadr);
        this.uninits.inclRange(this.firstadr, this.nextadr);
        this.alive = false;
    }

    void split() {
        this.initsWhenFalse = this.inits.dup();
        this.uninitsWhenFalse = this.uninits.dup();
        this.initsWhenTrue = this.inits;
        this.uninitsWhenTrue = this.uninits;
        this.uninits = null;
        this.inits = null;
    }

    void merge() {
        this.inits = this.initsWhenFalse.andSet(this.initsWhenTrue);
        this.uninits = this.uninitsWhenFalse.andSet(this.uninitsWhenTrue);
    }

    void scanDef(JCTree tree) {
        this.scanStat(tree);
        if (tree != null && tree.getTag() == 7 && !this.alive) {
            this.log.error(tree.pos(), "initializer.must.be.able.to.complete.normally", new Object[0]);
        }
    }

    void scanStat(JCTree tree) {
        if (!this.alive && tree != null) {
            this.log.error(tree.pos(), "unreachable.stmt", new Object[0]);
            if (tree.getTag() != 6) {
                this.alive = true;
            }
        }
        this.scan(tree);
    }

    void scanStats(List<? extends JCTree.JCStatement> trees) {
        if (trees != null) {
            List<JCTree.JCStatement> l = trees;
            while (l.nonEmpty()) {
                this.scanStat((JCTree)l.head);
                l = l.tail;
            }
        }
    }

    void scanExpr(JCTree tree) {
        if (tree != null) {
            this.scan(tree);
            if (this.inits == null) {
                this.merge();
            }
        }
    }

    void scanExprs(List<? extends JCTree.JCExpression> trees) {
        if (trees != null) {
            List<JCTree.JCExpression> l = trees;
            while (l.nonEmpty()) {
                this.scanExpr((JCTree)l.head);
                l = l.tail;
            }
        }
    }

    void scanCond(JCTree tree) {
        if (tree.type.isFalse()) {
            if (this.inits == null) {
                this.merge();
            }
            this.initsWhenTrue = this.inits.dup();
            this.initsWhenTrue.inclRange(this.firstadr, this.nextadr);
            this.uninitsWhenTrue = this.uninits.dup();
            this.uninitsWhenTrue.inclRange(this.firstadr, this.nextadr);
            this.initsWhenFalse = this.inits;
            this.uninitsWhenFalse = this.uninits;
        } else if (tree.type.isTrue()) {
            if (this.inits == null) {
                this.merge();
            }
            this.initsWhenFalse = this.inits.dup();
            this.initsWhenFalse.inclRange(this.firstadr, this.nextadr);
            this.uninitsWhenFalse = this.uninits.dup();
            this.uninitsWhenFalse.inclRange(this.firstadr, this.nextadr);
            this.initsWhenTrue = this.inits;
            this.uninitsWhenTrue = this.uninits;
        } else {
            this.scan(tree);
            if (this.inits != null) {
                this.split();
            }
        }
        this.uninits = null;
        this.inits = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        if (tree.sym == null) {
            return;
        }
        JCTree.JCClassDecl classDefPrev = this.classDef;
        List<Type> thrownPrev = this.thrown;
        List<Type> caughtPrev = this.caught;
        boolean alivePrev = this.alive;
        int firstadrPrev = this.firstadr;
        int nextadrPrev = this.nextadr;
        ListBuffer<PendingExit> pendingExitsPrev = this.pendingExits;
        Lint lintPrev = this.lint;
        this.pendingExits = new ListBuffer();
        if (tree.name != this.names.empty) {
            this.caught = List.nil();
            this.firstadr = this.nextadr;
        }
        this.classDef = tree;
        this.thrown = List.nil();
        this.lint = this.lint.augment(tree.sym.attributes_field);
        try {
            Symbol.VarSymbol sym;
            JCTree.JCVariableDecl def;
            List<JCTree> l = tree.defs;
            while (l.nonEmpty()) {
                if (((JCTree)l.head).getTag() == 5) {
                    def = (JCTree.JCVariableDecl)l.head;
                    if ((def.mods.flags & 8L) != 0L && this.trackable(sym = def.sym)) {
                        this.newVar(sym);
                    }
                }
                l = l.tail;
            }
            l = tree.defs;
            while (l.nonEmpty()) {
                if (((JCTree)l.head).getTag() != 4 && (TreeInfo.flags((JCTree)l.head) & 8L) != 0L) {
                    this.scanDef((JCTree)l.head);
                    this.errorUncaught();
                }
                l = l.tail;
            }
            if (tree.name != this.names.empty) {
                boolean firstConstructor = true;
                List<JCTree> l2 = tree.defs;
                while (l2.nonEmpty()) {
                    if (TreeInfo.isInitialConstructor((JCTree)l2.head)) {
                        List<Type> mthrown = ((JCTree.JCMethodDecl)l2.head).sym.type.getThrownTypes();
                        if (firstConstructor) {
                            this.caught = mthrown;
                            firstConstructor = false;
                        } else {
                            this.caught = this.chk.intersect(mthrown, this.caught);
                        }
                    }
                    l2 = l2.tail;
                }
            }
            l = tree.defs;
            while (l.nonEmpty()) {
                if (((JCTree)l.head).getTag() == 5) {
                    def = (JCTree.JCVariableDecl)l.head;
                    if ((def.mods.flags & 8L) == 0L && this.trackable(sym = def.sym)) {
                        this.newVar(sym);
                    }
                }
                l = l.tail;
            }
            l = tree.defs;
            while (l.nonEmpty()) {
                if (((JCTree)l.head).getTag() != 4 && (TreeInfo.flags((JCTree)l.head) & 8L) == 0L) {
                    this.scanDef((JCTree)l.head);
                    this.errorUncaught();
                }
                l = l.tail;
            }
            if (tree.name == this.names.empty) {
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (TreeInfo.isInitialConstructor((JCTree)l.head)) {
                        JCTree.JCMethodDecl mdef = (JCTree.JCMethodDecl)l.head;
                        mdef.thrown = this.make.Types(this.thrown);
                        mdef.sym.type.setThrown(this.thrown);
                    }
                    l = l.tail;
                }
                thrownPrev = this.chk.union(this.thrown, thrownPrev);
            }
            l = tree.defs;
            while (l.nonEmpty()) {
                if (((JCTree)l.head).getTag() == 4) {
                    this.scan((JCTree)l.head);
                    this.errorUncaught();
                }
                l = l.tail;
            }
            this.thrown = thrownPrev;
        }
        finally {
            this.pendingExits = pendingExitsPrev;
            this.alive = alivePrev;
            this.nextadr = nextadrPrev;
            this.firstadr = firstadrPrev;
            this.caught = caughtPrev;
            this.classDef = classDefPrev;
            this.lint = lintPrev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if (tree.body == null) {
            return;
        }
        List<Type> caughtPrev = this.caught;
        List<Type> mthrown = tree.sym.type.getThrownTypes();
        Bits initsPrev = this.inits.dup();
        Bits uninitsPrev = this.uninits.dup();
        int nextadrPrev = this.nextadr;
        int firstadrPrev = this.firstadr;
        Lint lintPrev = this.lint;
        this.lint = this.lint.augment(tree.sym.attributes_field);
        assert (this.pendingExits.isEmpty());
        try {
            boolean isInitialConstructor = TreeInfo.isInitialConstructor(tree);
            if (!isInitialConstructor) {
                this.firstadr = this.nextadr;
            }
            List<JCTree.JCVariableDecl> l = tree.params;
            while (l.nonEmpty()) {
                JCTree.JCVariableDecl def = (JCTree.JCVariableDecl)l.head;
                this.scan(def);
                this.inits.incl(def.sym.adr);
                this.uninits.excl(def.sym.adr);
                l = l.tail;
            }
            if (isInitialConstructor) {
                this.caught = this.chk.union(this.caught, mthrown);
            } else if ((tree.sym.flags() & 0x100008L) != 0x100000L) {
                this.caught = mthrown;
            }
            this.alive = true;
            this.scanStat(tree.body);
            if (this.alive && tree.sym.type.getReturnType().tag != 9) {
                this.log.error(TreeInfo.diagEndPos(tree.body), "missing.ret.stmt", new Object[0]);
            }
            if (isInitialConstructor) {
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    if (this.vars[i].owner != this.classDef.sym) continue;
                    this.checkInit(TreeInfo.diagEndPos(tree.body), this.vars[i]);
                }
            }
            List<PendingExit> exits = this.pendingExits.toList();
            this.pendingExits = new ListBuffer();
            while (exits.nonEmpty()) {
                PendingExit exit = (PendingExit)exits.head;
                exits = exits.tail;
                if (exit.thrown == null) {
                    assert (exit.tree.getTag() == 23);
                    if (!isInitialConstructor) continue;
                    this.inits = exit.inits;
                    for (int i = this.firstadr; i < this.nextadr; ++i) {
                        this.checkInit(exit.tree.pos(), this.vars[i]);
                    }
                    continue;
                }
                this.pendingExits.append(exit);
            }
        }
        finally {
            this.inits = initsPrev;
            this.uninits = uninitsPrev;
            this.nextadr = nextadrPrev;
            this.firstadr = firstadrPrev;
            this.caught = caughtPrev;
            this.lint = lintPrev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        boolean track = this.trackable(tree.sym);
        if (track && tree.sym.owner.kind == 16) {
            this.newVar(tree.sym);
        }
        if (tree.init != null) {
            Lint lintPrev = this.lint;
            this.lint = this.lint.augment(tree.sym.attributes_field);
            try {
                this.scanExpr(tree.init);
                if (track) {
                    this.letInit(tree.pos(), tree.sym);
                }
            }
            finally {
                this.lint = lintPrev;
            }
        }
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        int nextadrPrev = this.nextadr;
        this.scanStats(tree.stats);
        this.nextadr = nextadrPrev;
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        boolean prevLoopPassTwo = this.loopPassTwo;
        this.pendingExits = new ListBuffer();
        while (true) {
            Bits uninitsEntry = this.uninits.dup();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            this.scanCond(tree.cond);
            if (this.log.nerrors != 0 || this.loopPassTwo || uninitsEntry.diffSet(this.uninitsWhenTrue).nextBit(this.firstadr) == -1) break;
            this.inits = this.initsWhenTrue;
            this.uninits = uninitsEntry.andSet(this.uninitsWhenTrue);
            this.loopPassTwo = true;
            this.alive = true;
        }
        this.loopPassTwo = prevLoopPassTwo;
        this.inits = this.initsWhenFalse;
        this.uninits = this.uninitsWhenFalse;
        this.alive = this.alive && !tree.cond.type.isTrue();
        this.alive |= this.resolveBreaks(tree, prevPendingExits);
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        Bits uninitsCond;
        Bits initsCond;
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        boolean prevLoopPassTwo = this.loopPassTwo;
        this.pendingExits = new ListBuffer();
        while (true) {
            Bits uninitsEntry = this.uninits.dup();
            this.scanCond(tree.cond);
            initsCond = this.initsWhenFalse;
            uninitsCond = this.uninitsWhenFalse;
            this.inits = this.initsWhenTrue;
            this.uninits = this.uninitsWhenTrue;
            this.alive = !tree.cond.type.isFalse();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            if (this.log.nerrors != 0 || this.loopPassTwo || uninitsEntry.diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
            this.uninits = uninitsEntry.andSet(this.uninits);
            this.loopPassTwo = true;
            this.alive = true;
        }
        this.loopPassTwo = prevLoopPassTwo;
        this.inits = initsCond;
        this.uninits = uninitsCond;
        this.alive = this.resolveBreaks(tree, prevPendingExits) || !tree.cond.type.isTrue();
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        Bits uninitsCond;
        Bits initsCond;
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        boolean prevLoopPassTwo = this.loopPassTwo;
        int nextadrPrev = this.nextadr;
        this.scanStats(tree.init);
        this.pendingExits = new ListBuffer();
        while (true) {
            Bits uninitsEntry = this.uninits.dup();
            if (tree.cond != null) {
                this.scanCond(tree.cond);
                initsCond = this.initsWhenFalse;
                uninitsCond = this.uninitsWhenFalse;
                this.inits = this.initsWhenTrue;
                this.uninits = this.uninitsWhenTrue;
                this.alive = !tree.cond.type.isFalse();
            } else {
                initsCond = this.inits.dup();
                initsCond.inclRange(this.firstadr, this.nextadr);
                uninitsCond = this.uninits.dup();
                uninitsCond.inclRange(this.firstadr, this.nextadr);
                this.alive = true;
            }
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            this.scan(tree.step);
            if (this.log.nerrors != 0 || this.loopPassTwo || uninitsEntry.dup().diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
            this.uninits = uninitsEntry.andSet(this.uninits);
            this.loopPassTwo = true;
            this.alive = true;
        }
        this.loopPassTwo = prevLoopPassTwo;
        this.inits = initsCond;
        this.uninits = uninitsCond;
        this.alive = this.resolveBreaks(tree, prevPendingExits) || tree.cond != null && !tree.cond.type.isTrue();
        this.nextadr = nextadrPrev;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        this.visitVarDef(tree.var);
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        boolean prevLoopPassTwo = this.loopPassTwo;
        int nextadrPrev = this.nextadr;
        this.scan(tree.expr);
        Bits initsStart = this.inits.dup();
        Bits uninitsStart = this.uninits.dup();
        this.letInit(tree.pos(), tree.var.sym);
        this.pendingExits = new ListBuffer();
        while (true) {
            Bits uninitsEntry = this.uninits.dup();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            if (this.log.nerrors != 0 || this.loopPassTwo || uninitsEntry.diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
            this.uninits = uninitsEntry.andSet(this.uninits);
            this.loopPassTwo = true;
            this.alive = true;
        }
        this.loopPassTwo = prevLoopPassTwo;
        this.inits = initsStart;
        this.uninits = uninitsStart.andSet(this.uninits);
        this.resolveBreaks(tree, prevPendingExits);
        this.alive = true;
        this.nextadr = nextadrPrev;
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        this.pendingExits = new ListBuffer();
        this.scanStat(tree.body);
        this.alive |= this.resolveBreaks(tree, prevPendingExits);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        this.pendingExits = new ListBuffer();
        int nextadrPrev = this.nextadr;
        this.scanExpr(tree.selector);
        Bits initsSwitch = this.inits;
        Bits uninitsSwitch = this.uninits.dup();
        boolean hasDefault = false;
        List<JCTree.JCCase> l = tree.cases;
        while (l.nonEmpty()) {
            this.alive = true;
            this.inits = initsSwitch.dup();
            this.uninits = this.uninits.andSet(uninitsSwitch);
            JCTree.JCCase c = (JCTree.JCCase)l.head;
            if (c.pat == null) {
                hasDefault = true;
            } else {
                this.scanExpr(c.pat);
            }
            this.scanStats(c.stats);
            Flow.addVars(c.stats, initsSwitch, uninitsSwitch);
            if (!this.loopPassTwo && this.alive && this.lint.isEnabled(Lint.LintCategory.FALLTHROUGH) && c.stats.nonEmpty() && l.tail.nonEmpty()) {
                this.log.warning(Lint.LintCategory.FALLTHROUGH, ((JCTree.JCCase)l.tail.head).pos(), "possible.fall-through.into.case", new Object[0]);
            }
            l = l.tail;
        }
        if (!hasDefault) {
            this.inits.andSet(initsSwitch);
            this.alive = true;
        }
        this.alive |= this.resolveBreaks(tree, prevPendingExits);
        this.nextadr = nextadrPrev;
    }

    private static void addVars(List<JCTree.JCStatement> stats, Bits inits, Bits uninits) {
        while (stats.nonEmpty()) {
            JCTree stat = (JCTree)stats.head;
            if (stat.getTag() == 5) {
                int adr = ((JCTree.JCVariableDecl)stat).sym.adr;
                inits.excl(adr);
                uninits.incl(adr);
            }
            stats = stats.tail;
        }
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        List<Type> caughtPrev = this.caught;
        List<Type> thrownPrev = this.thrown;
        Map<Symbol.VarSymbol, JCTree.JCVariableDecl> unrefdResourcesPrev = this.unrefdResources;
        this.thrown = List.nil();
        List<JCTree.JCCatch> l = tree.catchers;
        while (l.nonEmpty()) {
            List<JCTree.JCExpression> subClauses = TreeInfo.isMultiCatch((JCTree.JCCatch)l.head) ? ((JCTree.JCTypeDisjoint)((JCTree.JCCatch)l.head).param.vartype).components : List.of(((JCTree.JCCatch)l.head).param.vartype);
            for (JCTree.JCExpression ct : subClauses) {
                this.caught = this.chk.incl(ct.type, this.caught);
            }
            l = l.tail;
        }
        Bits uninitsTryPrev = this.uninitsTry;
        ListBuffer<PendingExit> prevPendingExits = this.pendingExits;
        this.pendingExits = new ListBuffer();
        Bits initsTry = this.inits.dup();
        this.uninitsTry = this.uninits.dup();
        this.unrefdResources = new LinkedHashMap<Symbol.VarSymbol, JCTree.JCVariableDecl>();
        for (JCTree resource : tree.resources) {
            if (resource instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl vdecl = (JCTree.JCVariableDecl)resource;
                this.visitVarDef(vdecl);
                this.unrefdResources.put(vdecl.sym, vdecl);
                continue;
            }
            if (resource instanceof JCTree.JCExpression) {
                this.scanExpr((JCTree.JCExpression)resource);
                continue;
            }
            throw new AssertionError(tree);
        }
        for (JCTree resource : tree.resources) {
            List<Type> closeableSupertypes = resource.type.isCompound() ? this.types.interfaces(resource.type).prepend(this.types.supertype(resource.type)) : List.of(resource.type);
            for (Type sup : closeableSupertypes) {
                if (this.types.asSuper(sup, this.syms.autoCloseableType.tsym) == null) continue;
                Symbol.MethodSymbol closeMethod = this.rs.resolveInternalMethod(tree, this.attrEnv, sup, this.names.close, List.<Type>nil(), List.<Type>nil());
                if (closeMethod.kind != 16) continue;
                for (Type t : closeMethod.getThrownTypes()) {
                    this.markThrown(tree.body, t);
                }
            }
        }
        this.scanStat(tree.body);
        List<Type> thrownInTry = this.thrown;
        this.thrown = thrownPrev;
        this.caught = caughtPrev;
        boolean aliveEnd = this.alive;
        this.uninitsTry.andSet(this.uninits);
        Bits initsEnd = this.inits;
        Bits uninitsEnd = this.uninits;
        int nextadrCatch = this.nextadr;
        if (!this.unrefdResources.isEmpty() && this.lint.isEnabled(Lint.LintCategory.ARM)) {
            for (Map.Entry<Symbol.VarSymbol, JCTree.JCVariableDecl> e : this.unrefdResources.entrySet()) {
                this.log.warning(e.getValue().pos(), "automatic.resource.not.referenced", e.getKey());
            }
        }
        List<Type> caughtInTry = List.nil();
        List<JCTree.JCCatch> l2 = tree.catchers;
        while (l2.nonEmpty()) {
            this.alive = true;
            JCTree.JCVariableDecl param = ((JCTree.JCCatch)l2.head).param;
            List<JCTree.JCExpression> subClauses = TreeInfo.isMultiCatch((JCTree.JCCatch)l2.head) ? ((JCTree.JCTypeDisjoint)((JCTree.JCCatch)l2.head).param.vartype).components : List.of(((JCTree.JCCatch)l2.head).param.vartype);
            List<Type> ctypes = List.nil();
            List<Type> rethrownTypes = this.chk.diff(thrownInTry, caughtInTry);
            for (JCTree.JCExpression ct : subClauses) {
                Type exc = ct.type;
                ctypes = ctypes.append(exc);
                if (this.types.isSameType(exc, this.syms.objectType)) continue;
                if (this.chk.subset(exc, caughtInTry)) {
                    this.log.error(((JCTree.JCCatch)l2.head).pos(), "except.already.caught", exc);
                } else if (!this.chk.isUnchecked(((JCTree.JCCatch)l2.head).pos(), exc) && exc.tsym != this.syms.throwableType.tsym && exc.tsym != this.syms.exceptionType.tsym && !this.chk.intersects(exc, thrownInTry)) {
                    this.log.error(((JCTree.JCCatch)l2.head).pos(), "except.never.thrown.in.try", exc);
                }
                caughtInTry = this.chk.incl(exc, caughtInTry);
            }
            this.inits = initsTry.dup();
            this.uninits = this.uninitsTry.dup();
            this.scan(param);
            this.inits.incl(param.sym.adr);
            this.uninits.excl(param.sym.adr);
            this.multicatchTypes.put(param.sym, this.chk.intersect(ctypes, rethrownTypes));
            this.scanStat(((JCTree.JCCatch)l2.head).body);
            initsEnd.andSet(this.inits);
            uninitsEnd.andSet(this.uninits);
            this.nextadr = nextadrCatch;
            this.multicatchTypes.remove(param.sym);
            aliveEnd |= this.alive;
            l2 = l2.tail;
        }
        if (tree.finalizer != null) {
            List<Type> savedThrown = this.thrown;
            this.thrown = List.nil();
            this.inits = initsTry.dup();
            this.uninits = this.uninitsTry.dup();
            ListBuffer<PendingExit> exits = this.pendingExits;
            this.pendingExits = prevPendingExits;
            this.alive = true;
            this.scanStat(tree.finalizer);
            if (!this.alive) {
                this.thrown = this.chk.union(this.thrown, thrownPrev);
                if (!this.loopPassTwo && this.lint.isEnabled(Lint.LintCategory.FINALLY)) {
                    this.log.warning(Lint.LintCategory.FINALLY, TreeInfo.diagEndPos(tree.finalizer), "finally.cannot.complete", new Object[0]);
                }
            } else {
                this.thrown = this.chk.union(this.thrown, this.chk.diff(thrownInTry, caughtInTry));
                this.thrown = this.chk.union(this.thrown, savedThrown);
                this.uninits.andSet(uninitsEnd);
                while (exits.nonEmpty()) {
                    PendingExit exit = exits.next();
                    if (exit.inits != null) {
                        exit.inits.orSet(this.inits);
                        exit.uninits.andSet(this.uninits);
                    }
                    this.pendingExits.append(exit);
                }
                this.inits.orSet(initsEnd);
                this.alive = aliveEnd;
            }
        } else {
            this.thrown = this.chk.union(this.thrown, this.chk.diff(thrownInTry, caughtInTry));
            this.inits = initsEnd;
            this.uninits = uninitsEnd;
            this.alive = aliveEnd;
            ListBuffer<PendingExit> exits = this.pendingExits;
            this.pendingExits = prevPendingExits;
            while (exits.nonEmpty()) {
                this.pendingExits.append(exits.next());
            }
        }
        this.uninitsTry.andSet(uninitsTryPrev).andSet(this.uninits);
        this.unrefdResources = unrefdResourcesPrev;
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        this.scanCond(tree.cond);
        Bits initsBeforeElse = this.initsWhenFalse;
        Bits uninitsBeforeElse = this.uninitsWhenFalse;
        this.inits = this.initsWhenTrue;
        this.uninits = this.uninitsWhenTrue;
        if (tree.truepart.type.tag == 8 && tree.falsepart.type.tag == 8) {
            this.scanCond(tree.truepart);
            Bits initsAfterThenWhenTrue = this.initsWhenTrue.dup();
            Bits initsAfterThenWhenFalse = this.initsWhenFalse.dup();
            Bits uninitsAfterThenWhenTrue = this.uninitsWhenTrue.dup();
            Bits uninitsAfterThenWhenFalse = this.uninitsWhenFalse.dup();
            this.inits = initsBeforeElse;
            this.uninits = uninitsBeforeElse;
            this.scanCond(tree.falsepart);
            this.initsWhenTrue.andSet(initsAfterThenWhenTrue);
            this.initsWhenFalse.andSet(initsAfterThenWhenFalse);
            this.uninitsWhenTrue.andSet(uninitsAfterThenWhenTrue);
            this.uninitsWhenFalse.andSet(uninitsAfterThenWhenFalse);
        } else {
            this.scanExpr(tree.truepart);
            Bits initsAfterThen = this.inits.dup();
            Bits uninitsAfterThen = this.uninits.dup();
            this.inits = initsBeforeElse;
            this.uninits = uninitsBeforeElse;
            this.scanExpr(tree.falsepart);
            this.inits.andSet(initsAfterThen);
            this.uninits.andSet(uninitsAfterThen);
        }
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        this.scanCond(tree.cond);
        Bits initsBeforeElse = this.initsWhenFalse;
        Bits uninitsBeforeElse = this.uninitsWhenFalse;
        this.inits = this.initsWhenTrue;
        this.uninits = this.uninitsWhenTrue;
        this.scanStat(tree.thenpart);
        if (tree.elsepart != null) {
            boolean aliveAfterThen = this.alive;
            this.alive = true;
            Bits initsAfterThen = this.inits.dup();
            Bits uninitsAfterThen = this.uninits.dup();
            this.inits = initsBeforeElse;
            this.uninits = uninitsBeforeElse;
            this.scanStat(tree.elsepart);
            this.inits.andSet(initsAfterThen);
            this.uninits.andSet(uninitsAfterThen);
            this.alive |= aliveAfterThen;
        } else {
            this.inits.andSet(initsBeforeElse);
            this.uninits.andSet(uninitsBeforeElse);
            this.alive = true;
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        this.recordExit(tree);
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        this.recordExit(tree);
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        this.scanExpr(tree.expr);
        this.recordExit(tree);
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        this.scanExpr(tree.expr);
        Symbol sym = TreeInfo.symbol(tree.expr);
        if (sym != null && sym.kind == 4 && (sym.flags() & 0x10L) != 0L && this.multicatchTypes.get(sym) != null && this.allowRethrowAnalysis) {
            for (Type t : this.multicatchTypes.get(sym)) {
                this.markThrown(tree, t);
            }
        } else {
            this.markThrown(tree, tree.expr.type);
        }
        this.markDead();
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        this.scanExpr(tree.meth);
        this.scanExprs(tree.args);
        List<Type> l = tree.meth.type.getThrownTypes();
        while (l.nonEmpty()) {
            this.markThrown(tree, (Type)l.head);
            l = l.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        this.scanExpr(tree.encl);
        this.scanExprs(tree.args);
        List<Type> l = tree.constructorType.getThrownTypes();
        while (l.nonEmpty()) {
            this.markThrown(tree, (Type)l.head);
            l = l.tail;
        }
        List<Type> caughtPrev = this.caught;
        try {
            if (tree.def != null) {
                List<Type> l2 = tree.constructor.type.getThrownTypes();
                while (l2.nonEmpty()) {
                    this.caught = this.chk.incl((Type)l2.head, this.caught);
                    l2 = l2.tail;
                }
            }
            this.scan(tree.def);
        }
        finally {
            this.caught = caughtPrev;
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        this.scanExprs(tree.dims);
        this.scanExprs(tree.elems);
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        Bits initsExit = this.inits.dup();
        Bits uninitsExit = this.uninits.dup();
        this.scanCond(tree.cond);
        uninitsExit.andSet(this.uninitsWhenTrue);
        if (tree.detail != null) {
            this.inits = this.initsWhenFalse;
            this.uninits = this.uninitsWhenFalse;
            this.scanExpr(tree.detail);
        }
        this.inits = initsExit;
        this.uninits = uninitsExit;
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        JCTree.JCExpression lhs = TreeInfo.skipParens(tree.lhs);
        if (!(lhs instanceof JCTree.JCIdent)) {
            this.scanExpr(lhs);
        }
        this.scanExpr(tree.rhs);
        this.letInit(lhs);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        this.scanExpr(tree.lhs);
        this.scanExpr(tree.rhs);
        this.letInit(tree.lhs);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        switch (tree.getTag()) {
            case 50: {
                this.scanCond(tree.arg);
                Bits t = this.initsWhenFalse;
                this.initsWhenFalse = this.initsWhenTrue;
                this.initsWhenTrue = t;
                t = this.uninitsWhenFalse;
                this.uninitsWhenFalse = this.uninitsWhenTrue;
                this.uninitsWhenTrue = t;
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.scanExpr(tree.arg);
                this.letInit(tree.arg);
                break;
            }
            default: {
                this.scanExpr(tree.arg);
            }
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        switch (tree.getTag()) {
            case 58: {
                this.scanCond(tree.lhs);
                Bits initsWhenFalseLeft = this.initsWhenFalse;
                Bits uninitsWhenFalseLeft = this.uninitsWhenFalse;
                this.inits = this.initsWhenTrue;
                this.uninits = this.uninitsWhenTrue;
                this.scanCond(tree.rhs);
                this.initsWhenFalse.andSet(initsWhenFalseLeft);
                this.uninitsWhenFalse.andSet(uninitsWhenFalseLeft);
                break;
            }
            case 57: {
                this.scanCond(tree.lhs);
                Bits initsWhenTrueLeft = this.initsWhenTrue;
                Bits uninitsWhenTrueLeft = this.uninitsWhenTrue;
                this.inits = this.initsWhenFalse;
                this.uninits = this.uninitsWhenFalse;
                this.scanCond(tree.rhs);
                this.initsWhenTrue.andSet(initsWhenTrueLeft);
                this.uninitsWhenTrue.andSet(uninitsWhenTrueLeft);
                break;
            }
            default: {
                this.scanExpr(tree.lhs);
                this.scanExpr(tree.rhs);
            }
        }
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
        tree.underlyingType.accept(this);
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        if (tree.sym.kind == 4) {
            this.checkInit(tree.pos(), (Symbol.VarSymbol)tree.sym);
            this.referenced(tree.sym);
        }
    }

    void referenced(Symbol sym) {
        if (this.unrefdResources != null && this.unrefdResources.containsKey(sym)) {
            this.unrefdResources.remove(sym);
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        super.visitTypeCast(tree);
        if (!tree.type.isErroneous() && this.lint.isEnabled(Lint.LintCategory.CAST) && this.types.isSameType(tree.expr.type, tree.clazz.type) && !this.containsTypeAnnotation(tree.clazz)) {
            this.log.warning(Lint.LintCategory.CAST, tree.pos(), "redundant.cast", tree.expr.type);
        }
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
    }

    private boolean containsTypeAnnotation(JCTree e) {
        AnnotationFinder finder = new AnnotationFinder();
        finder.scan(e);
        return finder.foundTypeAnno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
        block8: {
            try {
                this.attrEnv = env;
                JCTree tree = env.tree;
                this.make = make;
                this.inits = new Bits();
                this.uninits = new Bits();
                this.uninitsTry = new Bits();
                this.uninitsWhenFalse = null;
                this.uninitsWhenTrue = null;
                this.initsWhenFalse = null;
                this.initsWhenTrue = null;
                if (this.vars == null) {
                    this.vars = new Symbol.VarSymbol[32];
                } else {
                    for (int i = 0; i < this.vars.length; ++i) {
                        this.vars[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                this.pendingExits = new ListBuffer();
                this.multicatchTypes = new HashMap();
                this.alive = true;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                this.scan(tree);
                this.uninitsTry = null;
                this.uninits = null;
                this.inits = null;
                this.uninitsWhenFalse = null;
                this.uninitsWhenTrue = null;
                this.initsWhenFalse = null;
                this.initsWhenTrue = null;
                if (this.vars == null) break block8;
            }
            catch (Throwable throwable) {
                this.uninitsTry = null;
                this.uninits = null;
                this.inits = null;
                this.uninitsWhenFalse = null;
                this.uninitsWhenTrue = null;
                this.initsWhenFalse = null;
                this.initsWhenTrue = null;
                if (this.vars != null) {
                    for (int i = 0; i < this.vars.length; ++i) {
                        this.vars[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                this.pendingExits = null;
                this.make = null;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                throw throwable;
            }
            for (int i = 0; i < this.vars.length; ++i) {
                this.vars[i] = null;
            }
        }
        this.firstadr = 0;
        this.nextadr = 0;
        this.pendingExits = null;
        this.make = null;
        this.caught = null;
        this.thrown = null;
        this.classDef = null;
    }

    private static class AnnotationFinder
    extends TreeScanner {
        public boolean foundTypeAnno = false;

        private AnnotationFinder() {
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation tree) {
            this.foundTypeAnno = this.foundTypeAnno || tree instanceof JCTree.JCTypeAnnotation;
        }
    }

    static class PendingExit {
        JCTree tree;
        Bits inits;
        Bits uninits;
        Type thrown;

        PendingExit(JCTree tree, Bits inits, Bits uninits) {
            this.tree = tree;
            this.inits = inits.dup();
            this.uninits = uninits.dup();
        }

        PendingExit(JCTree tree, Type thrown) {
            this.tree = tree;
            this.thrown = thrown;
        }
    }
}

