/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Warner;

public class Infer {
    protected static final Context.Key<Infer> inferKey = new Context.Key();
    public static final Type anyPoly = new Type(18, null);
    Symtab syms;
    Types types;
    Check chk;
    Resolve rs;
    JCDiagnostic.Factory diags;
    private final NoInstanceException ambiguousNoInstanceException;
    private final NoInstanceException unambiguousNoInstanceException;
    private final InvalidInstanceException invalidInstanceException;
    Type.Mapping fromTypeVarFun = new Type.Mapping("fromTypeVarFun"){

        @Override
        public Type apply(Type t) {
            if (t.tag == 14) {
                return new Type.UndetVar(t);
            }
            return t.map(this);
        }
    };
    Type.Mapping getInstFun = new Type.Mapping("getInstFun"){

        @Override
        public Type apply(Type t) {
            switch (t.tag) {
                case 20: {
                    throw Infer.this.ambiguousNoInstanceException.setMessage("undetermined.type", new Object[0]);
                }
                case 21: {
                    Type.UndetVar that = (Type.UndetVar)t;
                    if (that.inst == null) {
                        throw Infer.this.ambiguousNoInstanceException.setMessage("type.variable.has.undetermined.type", that.qtype);
                    }
                    return this.isConstraintCyclic(that) ? that.qtype : this.apply(that.inst);
                }
            }
            return t.map(this);
        }

        private boolean isConstraintCyclic(Type.UndetVar uv) {
            Types.UnaryVisitor<Boolean> constraintScanner = new Types.UnaryVisitor<Boolean>(){
                List<Type> seen = List.nil();

                Boolean visit(List<Type> ts) {
                    for (Type t : ts) {
                        if (!((Boolean)this.visit(t)).booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public Boolean visitType(Type t, Void ignored) {
                    return false;
                }

                @Override
                public Boolean visitClassType(Type.ClassType t, Void ignored) {
                    if (t.isCompound()) {
                        return (Boolean)this.visit(Infer.this.types.supertype(t)) != false || this.visit(Infer.this.types.interfaces(t)) != false;
                    }
                    return this.visit((List<Type>)t.getTypeArguments());
                }

                @Override
                public Boolean visitWildcardType(Type.WildcardType t, Void ignored) {
                    return (Boolean)this.visit(t.type);
                }

                @Override
                public Boolean visitUndetVar(Type.UndetVar t, Void ignored) {
                    if (this.seen.contains(t)) {
                        return true;
                    }
                    this.seen = this.seen.prepend(t);
                    return (Boolean)this.visit(t.inst);
                }
            };
            return (Boolean)constraintScanner.visit(uv);
        }
    };

    public static Infer instance(Context context) {
        Infer instance = context.get(inferKey);
        if (instance == null) {
            instance = new Infer(context);
        }
        return instance;
    }

    protected Infer(Context context) {
        context.put(inferKey, this);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.rs = Resolve.instance(context);
        this.chk = Check.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.ambiguousNoInstanceException = new NoInstanceException(true, this.diags);
        this.unambiguousNoInstanceException = new NoInstanceException(false, this.diags);
        this.invalidInstanceException = new InvalidInstanceException(this.diags);
    }

    void maximizeInst(Type.UndetVar that, Warner warn) throws NoInstanceException {
        if (that.inst == null) {
            that.inst = that.hibounds.isEmpty() ? this.syms.objectType : (that.hibounds.tail.isEmpty() ? (Type)that.hibounds.head : this.types.glb(that.hibounds));
        }
        if (that.inst == null || that.inst.isErroneous()) {
            throw this.ambiguousNoInstanceException.setMessage("no.unique.maximal.instance.exists", that.qtype, that.hibounds);
        }
    }

    private boolean isSubClass(Type t, List<Type> ts) {
        t = t.baseType();
        if (t.tag == 14) {
            List<Type> bounds = this.types.getBounds((Type.TypeVar)t);
            for (Type s : ts) {
                if (this.types.isSameType(t, s.baseType())) continue;
                for (Type bound : bounds) {
                    if (this.isSubClass(bound, List.of(s.baseType()))) continue;
                    return false;
                }
            }
        } else {
            for (Type s : ts) {
                if (t.tsym.isSubClass(s.baseType().tsym, this.types)) continue;
                return false;
            }
        }
        return true;
    }

    void minimizeInst(Type.UndetVar that, Warner warn) throws NoInstanceException {
        if (that.inst == null) {
            that.inst = that.lobounds.isEmpty() ? this.syms.botType : (that.lobounds.tail.isEmpty() ? (((Type)that.lobounds.head).isPrimitive() ? this.syms.errType : (Type)that.lobounds.head) : this.types.lub(that.lobounds));
            if (that.inst == null || that.inst.tag == 19) {
                throw this.ambiguousNoInstanceException.setMessage("no.unique.minimal.instance.exists", that.qtype, that.lobounds);
            }
            if (that.hibounds.isEmpty()) {
                return;
            }
            Type hb = null;
            if (that.hibounds.tail.isEmpty()) {
                hb = (Type)that.hibounds.head;
            } else {
                List<Type> bs = that.hibounds;
                while (bs.nonEmpty() && hb == null) {
                    if (this.isSubClass((Type)bs.head, that.hibounds)) {
                        hb = this.types.fromUnknownFun.apply((Type)bs.head);
                    }
                    bs = bs.tail;
                }
            }
            if (hb == null || !this.types.isSubtypeUnchecked(hb, that.hibounds, warn) || !this.types.isSubtypeUnchecked(that.inst, hb, warn)) {
                throw this.ambiguousNoInstanceException;
            }
        }
    }

    public Type instantiateExpr(Type.ForAll that, Type to, Warner warn) throws InferenceException {
        List<Type> undetvars;
        List<Type> l = undetvars = Type.map(that.tvars, this.fromTypeVarFun);
        while (l.nonEmpty()) {
            Type.UndetVar uv = (Type.UndetVar)l.head;
            Type.TypeVar tv = (Type.TypeVar)uv.qtype;
            ListBuffer<Type> hibounds = new ListBuffer<Type>();
            for (Type t : that.getConstraints(tv, Type.ForAll.ConstraintKind.EXTENDS)) {
                hibounds.append(this.types.subst(t, that.tvars, undetvars));
            }
            List<Type> inst = that.getConstraints(tv, Type.ForAll.ConstraintKind.EQUAL);
            if (inst.nonEmpty() && ((Type)inst.head).tag != 17) {
                uv.inst = (Type)inst.head;
            }
            uv.hibounds = hibounds.toList();
            l = l.tail;
        }
        Type qtype1 = this.types.subst(that.qtype, that.tvars, undetvars);
        if (!this.types.isSubtype(qtype1, to)) {
            throw this.unambiguousNoInstanceException.setMessage("no.conforming.instance.exists", that.tvars, that.qtype, to);
        }
        List<Type> l2 = undetvars;
        while (l2.nonEmpty()) {
            this.maximizeInst((Type.UndetVar)l2.head, warn);
            l2 = l2.tail;
        }
        List<Type> targs = Type.map(undetvars, this.getInstFun);
        if (Type.containsAny(targs, that.tvars)) {
            targs = this.types.subst(targs, that.tvars, this.instaniateAsUninferredVars(undetvars, that.tvars));
        }
        return this.chk.checkType(warn.pos(), that.inst(targs, this.types), to);
    }

    private List<Type> instaniateAsUninferredVars(List<Type> undetvars, List<Type> tvars) {
        ListBuffer<Object> new_targs = ListBuffer.lb();
        for (Type t : undetvars) {
            Type.UndetVar uv = (Type.UndetVar)t;
            Type.CapturedType newArg = new Type.CapturedType(t.tsym.name, t.tsym, uv.inst, this.syms.botType, null);
            new_targs = new_targs.append(newArg);
        }
        for (Type t : new_targs.toList()) {
            Type.WildcardType wt;
            Type.CapturedType ct = (Type.CapturedType)t;
            ct.bound = this.types.subst(ct.bound, tvars, new_targs.toList());
            ct.wildcard = wt = new Type.WildcardType(ct.bound, BoundKind.EXTENDS, this.syms.boundClass);
        }
        return new_targs.toList();
    }

    public Type instantiateMethod(final Env<AttrContext> env, List<Type> tvars, Type.MethodType mt, final Symbol msym, final List<Type> argtypes, final boolean allowBoxing, final boolean useVarargs, final Warner warn) throws InferenceException {
        boolean works;
        Type varargsFormal;
        List<Type> capturedArgs;
        List<Type> undetvars = Type.map(tvars, this.fromTypeVarFun);
        List<Type> formals = mt.argtypes;
        List<Type> actuals = capturedArgs = this.types.capture(argtypes);
        List<Type> actualsNoCapture = argtypes;
        Type type = varargsFormal = useVarargs ? formals.last() : null;
        while (actuals.nonEmpty() && formals.head != varargsFormal) {
            Type formal = (Type)formals.head;
            Type actual = ((Type)actuals.head).baseType();
            Type actualNoCapture = ((Type)actualsNoCapture.head).baseType();
            if (actual.tag == 16) {
                actual = this.instantiateArg((Type.ForAll)actual, formal, tvars, warn);
            }
            Type undetFormal = this.types.subst(formal, tvars, undetvars);
            boolean bl = works = allowBoxing ? this.types.isConvertible(actual, undetFormal, warn) : this.types.isSubtypeUnchecked(actual, undetFormal, warn);
            if (!works) {
                throw this.unambiguousNoInstanceException.setMessage("no.conforming.assignment.exists", tvars, actualNoCapture, formal);
            }
            formals = formals.tail;
            actuals = actuals.tail;
            actualsNoCapture = actualsNoCapture.tail;
        }
        if (formals.head != varargsFormal || !useVarargs && actuals.nonEmpty()) {
            throw this.unambiguousNoInstanceException.setMessage("arg.length.mismatch", new Object[0]);
        }
        if (useVarargs) {
            Type elemType = this.types.elemtype(varargsFormal);
            Type elemUndet = this.types.subst(elemType, tvars, undetvars);
            while (actuals.nonEmpty()) {
                Type actual = ((Type)actuals.head).baseType();
                Type actualNoCapture = ((Type)actualsNoCapture.head).baseType();
                if (actual.tag == 16) {
                    actual = this.instantiateArg((Type.ForAll)actual, elemType, tvars, warn);
                }
                if (!(works = this.types.isConvertible(actual, elemUndet, warn))) {
                    throw this.unambiguousNoInstanceException.setMessage("no.conforming.assignment.exists", tvars, actualNoCapture, elemType);
                }
                actuals = actuals.tail;
                actualsNoCapture = actualsNoCapture.tail;
            }
        }
        for (Type t : undetvars) {
            this.minimizeInst((Type.UndetVar)t, warn);
        }
        ListBuffer<Type> restvars = new ListBuffer<Type>();
        final ListBuffer<Type.UndetVar> restundet = new ListBuffer<Type.UndetVar>();
        ListBuffer<Type> insttypes = new ListBuffer<Type>();
        ListBuffer<Type> undettypes = new ListBuffer<Type>();
        for (Type t : undetvars) {
            Type.UndetVar uv = (Type.UndetVar)t;
            if (uv.inst.tag == 17) {
                restvars.append(uv.qtype);
                restundet.append(uv);
                insttypes.append(uv.qtype);
                undettypes.append(uv);
                uv.inst = null;
                continue;
            }
            insttypes.append(uv.inst);
            undettypes.append(uv.inst);
        }
        this.checkWithinBounds(tvars, undettypes.toList(), warn);
        mt = (Type.MethodType)this.types.subst(mt, tvars, insttypes.toList());
        if (!restvars.isEmpty()) {
            final List inferredTypes = insttypes.toList();
            final List<Type> all_tvars = tvars;
            final Type.MethodType mt2 = new Type.MethodType(mt.argtypes, null, mt.thrown, this.syms.methodClass);
            mt2.restype = new Type.ForAll(restvars.toList(), mt.restype){

                @Override
                public List<Type> getConstraints(Type.TypeVar tv, Type.ForAll.ConstraintKind ck) {
                    for (Type t : restundet.toList()) {
                        Type.UndetVar uv = (Type.UndetVar)t;
                        if (uv.qtype != tv) continue;
                        switch (ck) {
                            case EXTENDS: {
                                return uv.hibounds.appendList(Infer.this.types.subst(Infer.this.types.getBounds(tv), (List<Type>)all_tvars, (List<Type>)inferredTypes));
                            }
                            case SUPER: {
                                return uv.lobounds;
                            }
                            case EQUAL: {
                                return uv.inst != null ? List.of(uv.inst) : List.nil();
                            }
                        }
                    }
                    return List.nil();
                }

                @Override
                public Type inst(List<Type> inferred, Types types) throws NoInstanceException {
                    List<Type> formals = types.subst(mt2.argtypes, (List<Type>)this.tvars, inferred);
                    if (!Infer.this.rs.argumentsAcceptable(capturedArgs, formals, allowBoxing, useVarargs, warn)) {
                        throw Infer.this.invalidInstanceException.setMessage("inferred.do.not.conform.to.params", formals, argtypes);
                    }
                    Infer.this.checkWithinBounds(all_tvars, types.subst(inferredTypes, (List<Type>)this.tvars, inferred), warn);
                    if (useVarargs) {
                        Infer.this.chk.checkVararg(env.tree.pos(), formals, msym, env);
                    }
                    return super.inst(inferred, types);
                }
            };
            return mt2;
        }
        if (!this.rs.argumentsAcceptable(capturedArgs, (List<Type>)mt.getParameterTypes(), allowBoxing, useVarargs, warn)) {
            throw this.invalidInstanceException.setMessage("inferred.do.not.conform.to.params", mt.getParameterTypes(), argtypes);
        }
        return mt;
    }

    private Type instantiateArg(Type.ForAll that, Type to, List<Type> tvars, Warner warn) throws InferenceException {
        try {
            return this.instantiateExpr(that, to, warn);
        }
        catch (NoInstanceException ex) {
            Type to1 = to;
            List<Type> l = tvars;
            while (l.nonEmpty()) {
                to1 = this.types.subst(to1, List.of(l.head), List.of(this.syms.unknownType));
                l = l.tail;
            }
            return this.instantiateExpr(that, to1, warn);
        }
    }

    void checkWithinBounds(List<Type> tvars, List<Type> arguments, Warner warn) throws InvalidInstanceException {
        List<Type> tvs = tvars;
        List<Type> args = arguments;
        while (tvs.nonEmpty()) {
            List<Type> bounds;
            if (!(args.head instanceof Type.UndetVar) && !this.types.isSubtypeUnchecked((Type)args.head, bounds = this.types.subst(this.types.getBounds((Type.TypeVar)tvs.head), tvars, arguments), warn)) {
                throw this.invalidInstanceException.setMessage("inferred.do.not.conform.to.bounds", args.head, bounds);
            }
            tvs = tvs.tail;
            args = args.tail;
        }
    }

    public static class InvalidInstanceException
    extends InferenceException {
        private static final long serialVersionUID = 2L;

        InvalidInstanceException(JCDiagnostic.Factory diags) {
            super(diags);
        }
    }

    public static class NoInstanceException
    extends InferenceException {
        private static final long serialVersionUID = 1L;
        boolean isAmbiguous;

        NoInstanceException(boolean isAmbiguous, JCDiagnostic.Factory diags) {
            super(diags);
            this.isAmbiguous = isAmbiguous;
        }
    }

    public static class InferenceException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        JCDiagnostic diagnostic = null;
        JCDiagnostic.Factory diags;

        InferenceException(JCDiagnostic.Factory diags) {
            this.diags = diags;
        }

        InferenceException setMessage(String key, Object ... args) {
            this.diagnostic = this.diags.fragment(key, args);
            return this;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diagnostic;
        }
    }
}

