/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import java.util.HashMap;
import java.util.Map;

public class Pool {
    public static final int MAX_ENTRIES = 65535;
    public static final int MAX_STRING_LENGTH = 65535;
    int pp;
    Object[] pool;
    Map<Object, Integer> indices;

    public Pool(int pp, Object[] pool) {
        this.pp = pp;
        this.pool = pool;
        this.indices = new HashMap<Object, Integer>(pool.length);
        for (int i = 1; i < pp; ++i) {
            if (pool[i] == null) continue;
            this.indices.put(pool[i], i);
        }
    }

    public Pool() {
        this(1, new Object[64]);
    }

    public int numEntries() {
        return this.pp;
    }

    public void reset() {
        this.pp = 1;
        this.indices.clear();
    }

    private void doublePool() {
        Object[] newpool = new Object[this.pool.length * 2];
        System.arraycopy(this.pool, 0, newpool, 0, this.pool.length);
        this.pool = newpool;
    }

    public int put(Object value) {
        if (value instanceof Symbol.MethodSymbol) {
            value = new Method((Symbol.MethodSymbol)value);
        } else if (value instanceof Symbol.VarSymbol) {
            value = new Variable((Symbol.VarSymbol)value);
        }
        Integer index = this.indices.get(value);
        if (index == null) {
            index = this.pp;
            this.indices.put(value, index);
            if (this.pp == this.pool.length) {
                this.doublePool();
            }
            this.pool[this.pp++] = value;
            if (value instanceof Long || value instanceof Double) {
                if (this.pp == this.pool.length) {
                    this.doublePool();
                }
                this.pool[this.pp++] = null;
            }
        }
        return index;
    }

    public int get(Object o) {
        Integer n = this.indices.get(o);
        return n == null ? -1 : n;
    }

    static class Variable
    extends Symbol.DelegatedSymbol {
        Symbol.VarSymbol v;

        Variable(Symbol.VarSymbol v) {
            super(v);
            this.v = v;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Variable)) {
                return false;
            }
            Symbol.VarSymbol o = ((Variable)other).v;
            return o.name == this.v.name && o.owner == this.v.owner && o.type.equals(this.v.type);
        }

        @Override
        public int hashCode() {
            return this.v.name.hashCode() * 33 + this.v.owner.hashCode() * 9 + this.v.type.hashCode();
        }
    }

    static class Method
    extends Symbol.DelegatedSymbol {
        Symbol.MethodSymbol m;

        Method(Symbol.MethodSymbol m) {
            super(m);
            this.m = m;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Method)) {
                return false;
            }
            Symbol.MethodSymbol o = ((Method)other).m;
            return o.name == this.m.name && o.owner == this.m.owner && o.type.equals(this.m.type);
        }

        @Override
        public int hashCode() {
            return this.m.name.hashCode() * 33 + this.m.owner.hashCode() * 9 + this.m.type.hashCode();
        }
    }
}

