/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.source.util.AbstractTypeProcessor;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.processing.JavacFiler;
import com.sun.tools.javac.processing.JavacMessager;
import com.sun.tools.javac.processing.JavacRoundEnvironment;
import com.sun.tools.javac.processing.PrintingProcessor;
import com.sun.tools.javac.processing.ServiceProxy;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner7;
import javax.lang.model.util.Elements;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacProcessingEnvironment
implements ProcessingEnvironment,
Closeable {
    Options options;
    private final boolean printProcessorInfo;
    private final boolean printRounds;
    private final boolean verbose;
    private final boolean lint;
    private final boolean procOnly;
    private final boolean fatalErrors;
    private final boolean werror;
    private boolean foundTypeProcessors;
    private final JavacFiler filer;
    private final JavacMessager messager;
    private final JavacElements elementUtils;
    private final JavacTypes typeUtils;
    private DiscoveredProcessors discoveredProcs;
    public static java.util.List<AbstractTypeProcessor> typeProcessorsToInit = new ArrayList<AbstractTypeProcessor>();
    private final Map<String, String> processorOptions;
    private final Set<String> unmatchedProcessorOptions;
    private final Set<String> platformAnnotations;
    private Set<Symbol.PackageSymbol> specifiedPackages = Collections.emptySet();
    Log log;
    Source source;
    private ClassLoader processorClassLoader;
    private JavacMessages messages;
    private Context context;
    private static int uidCounter = 0;
    private final int uid = ++uidCounter;
    private static TreeScanner treeCleaner = new TreeScanner(){

        @Override
        public void scan(JCTree node) {
            super.scan(node);
            if (node != null) {
                node.type = null;
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit node) {
            node.packge = null;
            super.visitTopLevel(node);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl node) {
            node.sym = null;
            super.visitClassDef(node);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl node) {
            node.sym = null;
            super.visitMethodDef(node);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl node) {
            node.sym = null;
            super.visitVarDef(node);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass node) {
            node.constructor = null;
            super.visitNewClass(node);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp node) {
            node.operator = null;
            super.visitAssignop(node);
        }

        @Override
        public void visitUnary(JCTree.JCUnary node) {
            node.operator = null;
            super.visitUnary(node);
        }

        @Override
        public void visitBinary(JCTree.JCBinary node) {
            node.operator = null;
            super.visitBinary(node);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess node) {
            node.sym = null;
            super.visitSelect(node);
        }

        @Override
        public void visitIdent(JCTree.JCIdent node) {
            node.sym = null;
            super.visitIdent(node);
        }
    };
    private static final Pattern allMatches = Pattern.compile(".*");
    public static final Pattern noMatches = Pattern.compile("(\\P{all})+");

    public JavacProcessingEnvironment(Context context, Iterable<? extends Processor> processors) {
        this.options = Options.instance(context);
        this.context = context;
        this.log = Log.instance(context);
        this.source = Source.instance(context);
        this.printProcessorInfo = this.options.get("-XprintProcessorInfo") != null;
        this.printRounds = this.options.get("-XprintRounds") != null;
        this.verbose = this.options.get("-verbose") != null;
        this.lint = this.options.lint("processing");
        this.procOnly = this.options.get("-proc:only") != null || this.options.get("-Xprint") != null;
        this.fatalErrors = this.options.get("fatalEnterError") != null;
        this.werror = this.options.get("-Werror") != null;
        this.platformAnnotations = this.initPlatformAnnotations();
        this.foundTypeProcessors = false;
        this.filer = new JavacFiler(context);
        this.messager = new JavacMessager(context, this);
        this.elementUtils = new JavacElements(context);
        this.typeUtils = new JavacTypes(context);
        this.processorOptions = this.initProcessorOptions(context);
        this.unmatchedProcessorOptions = this.initUnmatchedProcessorOptions();
        this.messages = JavacMessages.instance(context);
        this.initProcessorIterator(context, processors);
    }

    private Set<String> initPlatformAnnotations() {
        HashSet<String> platformAnnotations = new HashSet<String>();
        platformAnnotations.add("java.lang.Deprecated");
        platformAnnotations.add("java.lang.Override");
        platformAnnotations.add("java.lang.SuppressWarnings");
        platformAnnotations.add("java.lang.annotation.Documented");
        platformAnnotations.add("java.lang.annotation.Inherited");
        platformAnnotations.add("java.lang.annotation.Retention");
        platformAnnotations.add("java.lang.annotation.Target");
        return Collections.unmodifiableSet(platformAnnotations);
    }

    private void initProcessorIterator(Context context, Iterable<? extends Processor> processors) {
        Iterator<Processor> processorIterator;
        Log log = Log.instance(context);
        if (this.options.get("-Xprint") != null) {
            try {
                Processor processor = (Processor)PrintingProcessor.class.newInstance();
                processorIterator = List.of(processor).iterator();
            }
            catch (Throwable t) {
                AssertionError assertError = new AssertionError((Object)"Problem instantiating PrintingProcessor.");
                ((Throwable)((Object)assertError)).initCause(t);
                throw assertError;
            }
        }
        if (processors != null) {
            processorIterator = processors.iterator();
        } else {
            String processorNames = this.options.get("-processor");
            JavaFileManager fileManager = context.get(JavaFileManager.class);
            try {
                ClassLoader classLoader = this.processorClassLoader = fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH) : fileManager.getClassLoader(StandardLocation.CLASS_PATH);
                processorIterator = processorNames != null ? new NameProcessIterator(processorNames, this.processorClassLoader, log) : new ServiceIterator(this.processorClassLoader, log);
            }
            catch (SecurityException e) {
                processorIterator = this.handleServiceLoaderUnavailability("proc.cant.create.loader", e);
            }
        }
        this.discoveredProcs = new DiscoveredProcessors(processorIterator);
    }

    private Iterator<Processor> handleServiceLoaderUnavailability(String key, Exception e) {
        JavaFileManager fileManager = this.context.get(JavaFileManager.class);
        if (fileManager instanceof JavacFileManager) {
            Iterable<? extends File> workingPath;
            JavacFileManager standardFileManager = (JavacFileManager)fileManager;
            Iterable<? extends File> iterable = workingPath = fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? standardFileManager.getLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) : standardFileManager.getLocation(StandardLocation.CLASS_PATH);
            if (this.needClassLoader(this.options.get("-processor"), workingPath)) {
                this.handleException(key, e);
            }
        } else {
            this.handleException(key, e);
        }
        java.util.List pl = Collections.emptyList();
        return pl.iterator();
    }

    private void handleException(String key, Exception e) {
        if (e != null) {
            this.log.error(key, e.getLocalizedMessage());
            throw new Abort(e);
        }
        this.log.error(key, new Object[0]);
        throw new Abort();
    }

    public boolean atLeastOneProcessor() {
        return this.discoveredProcs.iterator().hasNext();
    }

    private Map<String, String> initProcessorOptions(Context context) {
        Options options = Options.instance(context);
        Set<String> keySet = options.keySet();
        LinkedHashMap<String, String> tempOptions = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            if (!key.startsWith("-A") || key.length() <= 2) continue;
            int sepIndex = key.indexOf(61);
            String candidateKey = null;
            String candidateValue = null;
            if (sepIndex == -1) {
                candidateKey = key.substring(2);
            } else if (sepIndex >= 3) {
                candidateKey = key.substring(2, sepIndex);
                candidateValue = sepIndex < key.length() - 1 ? key.substring(sepIndex + 1) : null;
            }
            tempOptions.put(candidateKey, candidateValue);
        }
        return Collections.unmodifiableMap(tempOptions);
    }

    private Set<String> initUnmatchedProcessorOptions() {
        HashSet<String> unmatchedProcessorOptions = new HashSet<String>();
        unmatchedProcessorOptions.addAll(this.processorOptions.keySet());
        return unmatchedProcessorOptions;
    }

    private void discoverAndRunProcs(Context context, Set<TypeElement> annotationsPresent, List<Symbol.ClassSymbol> topLevelClasses, List<Symbol.PackageSymbol> packageInfoFiles) {
        HashMap<String, TypeElement> unmatchedAnnotations = new HashMap<String, TypeElement>(annotationsPresent.size());
        for (TypeElement a : annotationsPresent) {
            unmatchedAnnotations.put(a.getQualifiedName().toString(), a);
        }
        if (unmatchedAnnotations.size() == 0) {
            unmatchedAnnotations.put("", null);
        }
        DiscoveredProcessors.ProcessorStateIterator psi = this.discoveredProcs.iterator();
        Set<Symbol.TypeSymbol> rootElements = new LinkedHashSet<Symbol.TypeSymbol>();
        rootElements.addAll(topLevelClasses);
        rootElements.addAll(packageInfoFiles);
        rootElements = Collections.unmodifiableSet(rootElements);
        JavacRoundEnvironment renv = new JavacRoundEnvironment(false, false, rootElements, this);
        while (unmatchedAnnotations.size() > 0 && psi.hasNext()) {
            ProcessorState ps = psi.next();
            HashSet<String> matchedNames = new HashSet<String>();
            LinkedHashSet<TypeElement> typeElements = new LinkedHashSet<TypeElement>();
            for (Map.Entry entry : unmatchedAnnotations.entrySet()) {
                String unmatchedAnnotationName = (String)entry.getKey();
                if (!ps.annotationSupported(unmatchedAnnotationName)) continue;
                matchedNames.add(unmatchedAnnotationName);
                TypeElement te = (TypeElement)entry.getValue();
                if (te == null) continue;
                typeElements.add(te);
            }
            if (matchedNames.size() <= 0 && !ps.contributed) continue;
            this.foundTypeProcessors = this.foundTypeProcessors || ps.processor instanceof AbstractTypeProcessor;
            boolean processingResult = this.callProcessor(ps.processor, typeElements, renv);
            ps.contributed = true;
            ps.removeSupportedOptions(this.unmatchedProcessorOptions);
            if (this.printProcessorInfo || this.verbose) {
                this.log.printNoteLines("x.print.processor.info", ps.processor.getClass().getName(), ((Object)matchedNames).toString(), processingResult);
            }
            if (!processingResult) continue;
            unmatchedAnnotations.keySet().removeAll(matchedNames);
        }
        unmatchedAnnotations.remove("");
        if (this.lint && unmatchedAnnotations.size() > 0) {
            unmatchedAnnotations.keySet().removeAll(this.platformAnnotations);
            if (unmatchedAnnotations.size() > 0) {
                this.log = Log.instance(context);
                this.log.warning("proc.annotations.without.processors", unmatchedAnnotations.keySet());
            }
        }
        psi.runContributingProcs(renv);
        if (this.options.get("displayFilerState") != null) {
            this.filer.displayState();
        }
    }

    private boolean callProcessor(Processor proc, Set<? extends TypeElement> tes, RoundEnvironment renv) {
        try {
            return proc.process(tes, renv);
        }
        catch (Symbol.CompletionFailure ex) {
            StringWriter out = new StringWriter();
            ex.printStackTrace(new PrintWriter(out));
            this.log.error("proc.cant.access", ex.sym, ex.getDetailValue(), out.toString());
            return false;
        }
        catch (Throwable t) {
            throw new AnnotationProcessingError(t);
        }
    }

    public JavaCompiler doProcessing(Context context, List<JCTree.JCCompilationUnit> roots, List<Symbol.ClassSymbol> classSymbols, Iterable<? extends Symbol.PackageSymbol> pckSymbols) throws IOException {
        boolean bl;
        boolean bl2;
        boolean moreToDo;
        TaskListener taskListener = context.get(TaskListener.class);
        this.log = Log.instance(context);
        LinkedHashSet<Symbol.PackageSymbol> specifiedPackages = new LinkedHashSet<Symbol.PackageSymbol>();
        for (Symbol.PackageSymbol packageSymbol : pckSymbols) {
            specifiedPackages.add(packageSymbol);
        }
        this.specifiedPackages = Collections.unmodifiableSet(specifiedPackages);
        Round round = new Round(context, roots, classSymbols);
        do {
            round.run(false, false);
            bl2 = round.unrecoverableError();
            moreToDo = this.moreToDo();
            round = round.next(new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects()), new LinkedHashMap<String, JavaFileObject>(this.filer.getGeneratedClasses()));
            if (!round.unrecoverableError()) continue;
            bl2 = true;
        } while (moreToDo && !bl2);
        round.run(true, bl2);
        this.filer.warnIfUnclosedFiles();
        this.warnIfUnmatchedOptions();
        if (this.messager.errorRaised() || this.werror && round.warningCount() > 0 && round.errorCount() > 0) {
            bl = true;
        }
        LinkedHashSet<JavaFileObject> newSourceFiles = new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects());
        roots = JavacProcessingEnvironment.cleanTrees(round.roots);
        JavaCompiler compiler2 = round.finalCompiler(bl);
        if (newSourceFiles.size() > 0) {
            roots = roots.appendList(compiler2.parseFiles(newSourceFiles));
        }
        boolean bl3 = bl || compiler2.errorCount() > 0;
        this.close();
        if (taskListener != null) {
            taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
        }
        if (bl3) {
            if (compiler2.errorCount() == 0) {
                ++compiler2.log.nerrors;
            }
            return compiler2;
        }
        if (this.procOnly && !this.foundTypeProcessors) {
            compiler2.todo.clear();
        } else {
            if (this.procOnly && this.foundTypeProcessors) {
                compiler2.shouldStopPolicy = JavaCompiler.CompileState.FLOW;
            }
            compiler2.enterTrees(roots);
        }
        return compiler2;
    }

    private void warnIfUnmatchedOptions() {
        if (!this.unmatchedProcessorOptions.isEmpty()) {
            this.log.warning("proc.unmatched.processor.options", this.unmatchedProcessorOptions.toString());
        }
    }

    @Override
    public void close() throws IOException {
        this.filer.close();
        if (this.discoveredProcs != null) {
            this.discoveredProcs.close();
        }
        this.discoveredProcs = null;
    }

    private List<Symbol.ClassSymbol> getTopLevelClasses(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.ClassSymbol> classes = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            for (JCTree node : jCCompilationUnit.defs) {
                if (node.getTag() != 3) continue;
                Symbol.ClassSymbol sym = ((JCTree.JCClassDecl)node).sym;
                assert (sym != null);
                classes = classes.prepend(sym);
            }
        }
        return classes.reverse();
    }

    private List<Symbol.ClassSymbol> getTopLevelClassesFromClasses(List<? extends Symbol.ClassSymbol> syms) {
        List<Symbol.ClassSymbol> classes = List.nil();
        for (Symbol.ClassSymbol classSymbol : syms) {
            if (this.isPkgInfo(classSymbol)) continue;
            classes = classes.prepend(classSymbol);
        }
        return classes.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFiles(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.PackageSymbol> packages = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            if (!this.isPkgInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE)) continue;
            packages = packages.prepend(jCCompilationUnit.packge);
        }
        return packages.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFilesFromClasses(List<? extends Symbol.ClassSymbol> syms) {
        List<Symbol.PackageSymbol> packages = List.nil();
        for (Symbol.ClassSymbol classSymbol : syms) {
            if (!this.isPkgInfo(classSymbol)) continue;
            packages = packages.prepend((Symbol.PackageSymbol)classSymbol.owner);
        }
        return packages.reverse();
    }

    private static <T> List<T> join(List<T> list1, List<T> list2) {
        return list1.appendList(list2);
    }

    private boolean isPkgInfo(JavaFileObject fo, JavaFileObject.Kind kind) {
        return fo.isNameCompatible("package-info", kind);
    }

    private boolean isPkgInfo(Symbol.ClassSymbol sym) {
        return this.isPkgInfo(sym.classfile, JavaFileObject.Kind.CLASS) && sym.packge().package_info == sym;
    }

    private boolean needClassLoader(String procNames, Iterable<? extends File> workingpath) {
        if (procNames != null) {
            return true;
        }
        URL[] urls = new URL[1];
        for (File file : workingpath) {
            try {
                urls[0] = file.toURI().toURL();
                if (!ServiceProxy.hasService(Processor.class, urls)) continue;
                return true;
            }
            catch (MalformedURLException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (ServiceProxy.ServiceConfigurationError e) {
                this.log.error("proc.bad.config.file", e.getLocalizedMessage());
                return true;
            }
        }
        return false;
    }

    private static <T extends JCTree> List<T> cleanTrees(List<T> nodes) {
        for (JCTree node : nodes) {
            treeCleaner.scan(node);
        }
        return nodes;
    }

    private boolean moreToDo() {
        return this.filer.newFiles();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processorOptions;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public Filer getFiler() {
        return this.filer;
    }

    @Override
    public JavacElements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public JavacTypes getTypeUtils() {
        return this.typeUtils;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return Source.toSourceVersion(this.source);
    }

    @Override
    public Locale getLocale() {
        return this.messages.getCurrentLocale();
    }

    public Set<Symbol.PackageSymbol> getSpecifiedPackages() {
        return this.specifiedPackages;
    }

    private static Pattern importStringToPattern(String s, Processor p, Log log) {
        if (JavacProcessingEnvironment.isValidImportString(s)) {
            return JavacProcessingEnvironment.validImportStringToPattern(s);
        }
        log.warning("proc.malformed.supported.string", s, p.getClass().getName());
        return noMatches;
    }

    public static boolean isValidImportString(String s) {
        if (s.equals("*")) {
            return true;
        }
        boolean valid = true;
        String t = s;
        int index = t.indexOf(42);
        if (index != -1) {
            if (index == t.length() - 1) {
                if (index - 1 >= 0) {
                    valid = t.charAt(index - 1) == '.';
                    t = t.substring(0, t.length() - 2);
                }
            } else {
                return false;
            }
        }
        if (valid) {
            String[] javaIds;
            for (String javaId : javaIds = t.split("\\.", t.length() + 2)) {
                valid &= SourceVersion.isIdentifier(javaId);
            }
        }
        return valid;
    }

    public static Pattern validImportStringToPattern(String s) {
        if (s.equals("*")) {
            return allMatches;
        }
        String s_prime = s.replace(".", "\\.");
        if (s_prime.endsWith("*")) {
            s_prime = s_prime.substring(0, s_prime.length() - 1) + ".+";
        }
        return Pattern.compile(s_prime);
    }

    public Context getContext() {
        return this.context;
    }

    public String toString() {
        return "JavacProcessingEnvironment#" + this.uid;
    }

    public static boolean isValidOptionName(String optionName) {
        for (String s : optionName.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    class Round {
        final int number;
        final Context context;
        final JavaCompiler compiler;
        final Log log;
        final int priorWarnings;
        List<JCTree.JCCompilationUnit> roots;
        Map<String, JavaFileObject> genClassFiles;
        Set<TypeElement> annotationsPresent;
        List<Symbol.ClassSymbol> topLevelClasses;
        List<Symbol.PackageSymbol> packageInfoFiles;

        private Round(Context context, int number, int priorWarnings) {
            this.context = context;
            this.number = number;
            this.priorWarnings = priorWarnings;
            this.compiler = JavaCompiler.instance(context);
            this.log = Log.instance(context);
            JavacProcessingEnvironment.this.context = context;
            this.topLevelClasses = List.nil();
            this.packageInfoFiles = List.nil();
        }

        Round(Context context, List<JCTree.JCCompilationUnit> roots, List<Symbol.ClassSymbol> classSymbols) {
            this(context, 1, 0);
            this.roots = roots;
            this.genClassFiles = new HashMap<String, JavaFileObject>();
            this.compiler.todo.clear();
            this.topLevelClasses = javacProcessingEnvironment.getTopLevelClasses(roots).prependList(classSymbols.reverse());
            this.packageInfoFiles = javacProcessingEnvironment.getPackageInfoFiles(roots);
            this.findAnnotationsPresent();
        }

        private Round(Round prev, Set<JavaFileObject> newSourceFiles, Map<String, JavaFileObject> newClassFiles) throws IOException {
            this(prev.nextContext(), prev.number + 1, prev.compiler.log.nwarnings);
            this.genClassFiles = prev.genClassFiles;
            this.updateProcessingState();
            List<JCTree.JCCompilationUnit> parsedFiles = this.compiler.parseFiles(newSourceFiles);
            this.roots = JavacProcessingEnvironment.cleanTrees(prev.roots).appendList(parsedFiles);
            if (this.unrecoverableError()) {
                return;
            }
            this.enterClassFiles(this.genClassFiles);
            List<Symbol.ClassSymbol> newClasses = this.enterClassFiles(newClassFiles);
            this.genClassFiles.putAll(newClassFiles);
            this.enterTrees(this.roots);
            if (this.unrecoverableError()) {
                return;
            }
            this.topLevelClasses = JavacProcessingEnvironment.join(javacProcessingEnvironment.getTopLevelClasses(parsedFiles), javacProcessingEnvironment.getTopLevelClassesFromClasses(newClasses));
            this.packageInfoFiles = JavacProcessingEnvironment.join(javacProcessingEnvironment.getPackageInfoFiles(parsedFiles), javacProcessingEnvironment.getPackageInfoFilesFromClasses(newClasses));
            this.findAnnotationsPresent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Round next(Set<JavaFileObject> newSourceFiles, Map<String, JavaFileObject> newClassFiles) throws IOException {
            try {
                Round round = new Round(this, newSourceFiles, newClassFiles);
                return round;
            }
            finally {
                this.compiler.close(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JavaCompiler finalCompiler(boolean errorStatus) {
            try {
                JavaCompiler c = JavaCompiler.instance(this.nextContext());
                if (errorStatus) {
                    c.log.nwarnings += this.priorWarnings + this.compiler.log.nwarnings;
                    c.log.nerrors += this.compiler.log.nerrors;
                }
                JavaCompiler javaCompiler = c;
                return javaCompiler;
            }
            finally {
                this.compiler.close(false);
            }
        }

        int errorCount() {
            return this.compiler.errorCount();
        }

        int warningCount() {
            return this.compiler.warningCount();
        }

        boolean unrecoverableError() {
            return this.log.unrecoverableError || JavacProcessingEnvironment.this.messager.errorRaised() || JavacProcessingEnvironment.this.werror && this.log.nwarnings > 0 || JavacProcessingEnvironment.this.fatalErrors && this.log.nerrors > 0;
        }

        void findAnnotationsPresent() {
            ComputeAnnotationSet annotationComputer = new ComputeAnnotationSet(JavacProcessingEnvironment.this.elementUtils);
            this.annotationsPresent = new LinkedHashSet<TypeElement>();
            for (Symbol.ClassSymbol classSym : this.topLevelClasses) {
                annotationComputer.scan((Element)classSym, this.annotationsPresent);
            }
            for (Symbol.PackageSymbol pkgSym : this.packageInfoFiles) {
                annotationComputer.scan((Element)pkgSym, this.annotationsPresent);
            }
        }

        List<Symbol.ClassSymbol> enterClassFiles(Map<String, JavaFileObject> classFiles) {
            ClassReader reader = ClassReader.instance(this.context);
            Names names = Names.instance(this.context);
            List<Symbol.ClassSymbol> list = List.nil();
            for (Map.Entry<String, JavaFileObject> entry : classFiles.entrySet()) {
                Symbol.ClassSymbol cs;
                Name name = names.fromString(entry.getKey());
                JavaFileObject file = entry.getValue();
                if (file.getKind() != JavaFileObject.Kind.CLASS) {
                    throw new AssertionError(file);
                }
                if (JavacProcessingEnvironment.this.isPkgInfo(file, JavaFileObject.Kind.CLASS)) {
                    Name packageName = Convert.packagePart(name);
                    Symbol.PackageSymbol p = reader.enterPackage(packageName);
                    if (p.package_info == null) {
                        p.package_info = reader.enterClass(Convert.shortName(name), p);
                    }
                    cs = p.package_info;
                    if (cs.classfile == null) {
                        cs.classfile = file;
                    }
                } else {
                    cs = reader.enterClass(name, file);
                }
                list = list.prepend(cs);
            }
            return list.reverse();
        }

        void enterTrees(List<JCTree.JCCompilationUnit> roots) {
            this.compiler.enterTrees(roots);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run(boolean lastRound, boolean errorStatus) {
            this.printRoundInfo(lastRound);
            TaskListener taskListener = this.context.get(TaskListener.class);
            if (taskListener != null) {
                taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
            }
            try {
                if (lastRound) {
                    JavacProcessingEnvironment.this.filer.setLastRound(true);
                    Set emptyRootElements = Collections.emptySet();
                    JavacRoundEnvironment renv = new JavacRoundEnvironment(true, errorStatus, emptyRootElements, JavacProcessingEnvironment.this);
                    JavacProcessingEnvironment.this.discoveredProcs.iterator().runContributingProcs(renv);
                } else {
                    JavacProcessingEnvironment.this.discoverAndRunProcs(this.context, this.annotationsPresent, this.topLevelClasses, this.packageInfoFiles);
                }
            }
            finally {
                if (taskListener != null) {
                    taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
                }
            }
        }

        private void updateProcessingState() {
            JavacProcessingEnvironment.this.filer.newRound(this.context);
            JavacProcessingEnvironment.this.messager.newRound(this.context);
            JavacProcessingEnvironment.this.elementUtils.setContext(this.context);
            JavacProcessingEnvironment.this.typeUtils.setContext(this.context);
        }

        private void printRoundInfo(boolean lastRound) {
            if (JavacProcessingEnvironment.this.printRounds || JavacProcessingEnvironment.this.verbose) {
                List<Object> tlc = lastRound ? List.nil() : this.topLevelClasses;
                Set<Object> ap = lastRound ? Collections.emptySet() : this.annotationsPresent;
                this.log.printNoteLines("x.print.rounds", this.number, "{" + tlc.toString(", ") + "}", ap, lastRound);
            }
        }

        private Context nextContext() {
            TaskListener tl;
            Context next = new Context();
            Options options = Options.instance(this.context);
            assert (options != null);
            next.put(Options.optionsKey, options);
            PrintWriter out = this.context.get(Log.outKey);
            assert (out != null);
            next.put(Log.outKey, out);
            boolean shareNames = true;
            Names names = Names.instance(this.context);
            assert (names != null);
            next.put(Names.namesKey, names);
            DiagnosticListener dl = this.context.get(DiagnosticListener.class);
            if (dl != null) {
                next.put(DiagnosticListener.class, dl);
            }
            if ((tl = this.context.get(TaskListener.class)) != null) {
                next.put(TaskListener.class, tl);
            }
            JavaFileManager jfm = this.context.get(JavaFileManager.class);
            assert (jfm != null);
            next.put(JavaFileManager.class, jfm);
            if (jfm instanceof JavacFileManager) {
                ((JavacFileManager)jfm).setContext(next);
            }
            Names names2 = Names.instance(this.context);
            assert (names2 != null);
            next.put(Names.namesKey, names2);
            Keywords keywords = Keywords.instance(this.context);
            assert (keywords != null);
            next.put(Keywords.keywordsKey, keywords);
            JavaCompiler oldCompiler = JavaCompiler.instance(this.context);
            JavaCompiler nextCompiler = JavaCompiler.instance(next);
            nextCompiler.initRound(oldCompiler);
            JavacTaskImpl task = this.context.get(JavacTaskImpl.class);
            if (task != null) {
                next.put(JavacTaskImpl.class, task);
                task.updateContext(next);
            }
            return next;
        }
    }

    public static class ComputeAnnotationSet
    extends ElementScanner7<Set<TypeElement>, Set<TypeElement>> {
        final Elements elements;

        public ComputeAnnotationSet(Elements elements) {
            this.elements = elements;
        }

        @Override
        public Set<TypeElement> visitPackage(PackageElement e, Set<TypeElement> p) {
            return p;
        }

        @Override
        public Set<TypeElement> scan(Element e, Set<TypeElement> p) {
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(e)) {
                Element e2 = annotationMirror.getAnnotationType().asElement();
                p.add((TypeElement)e2);
            }
            return (Set)super.scan(e, p);
        }
    }

    class DiscoveredProcessors
    implements Iterable<ProcessorState> {
        Iterator<? extends Processor> processorIterator;
        ArrayList<ProcessorState> procStateList;

        public ProcessorStateIterator iterator() {
            return new ProcessorStateIterator(this);
        }

        DiscoveredProcessors(Iterator<? extends Processor> processorIterator) {
            this.processorIterator = processorIterator;
            this.procStateList = new ArrayList();
        }

        public void close() {
            if (this.processorIterator != null && this.processorIterator instanceof ServiceIterator) {
                ((ServiceIterator)this.processorIterator).close();
            }
        }

        class ProcessorStateIterator
        implements Iterator<ProcessorState> {
            DiscoveredProcessors psi;
            Iterator<ProcessorState> innerIter;
            boolean onProcInterator;

            ProcessorStateIterator(DiscoveredProcessors psi) {
                this.psi = psi;
                this.innerIter = psi.procStateList.iterator();
                this.onProcInterator = false;
            }

            @Override
            public ProcessorState next() {
                if (!this.onProcInterator) {
                    if (this.innerIter.hasNext()) {
                        return this.innerIter.next();
                    }
                    this.onProcInterator = true;
                }
                if (this.psi.processorIterator.hasNext()) {
                    ProcessorState ps = new ProcessorState(this.psi.processorIterator.next(), JavacProcessingEnvironment.this.log, JavacProcessingEnvironment.this.source, JavacProcessingEnvironment.this);
                    this.psi.procStateList.add(ps);
                    return ps;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.onProcInterator) {
                    return this.psi.processorIterator.hasNext();
                }
                return this.innerIter.hasNext() || this.psi.processorIterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void runContributingProcs(RoundEnvironment re) {
                if (!this.onProcInterator) {
                    Set emptyTypeElements = Collections.emptySet();
                    while (this.innerIter.hasNext()) {
                        ProcessorState ps = this.innerIter.next();
                        if (!ps.contributed) continue;
                        JavacProcessingEnvironment.this.callProcessor(ps.processor, emptyTypeElements, re);
                    }
                }
            }
        }
    }

    static class ProcessorState {
        public Processor processor;
        public boolean contributed;
        private ArrayList<Pattern> supportedAnnotationPatterns;
        private ArrayList<String> supportedOptionNames;

        ProcessorState(Processor p, Log log, Source source, ProcessingEnvironment env) {
            this.processor = p;
            this.contributed = false;
            try {
                if (this.processor instanceof AbstractTypeProcessor) {
                    typeProcessorsToInit.add((AbstractTypeProcessor)this.processor);
                } else {
                    this.processor.init(env);
                }
                this.checkSourceVersionCompatibility(source, log);
                this.supportedAnnotationPatterns = new ArrayList();
                for (String importString : this.processor.getSupportedAnnotationTypes()) {
                    this.supportedAnnotationPatterns.add(JavacProcessingEnvironment.importStringToPattern(importString, this.processor, log));
                }
                this.supportedOptionNames = new ArrayList();
                for (String optionName : this.processor.getSupportedOptions()) {
                    if (!this.checkOptionName(optionName, log)) continue;
                    this.supportedOptionNames.add(optionName);
                }
            }
            catch (Throwable t) {
                throw new AnnotationProcessingError(t);
            }
        }

        private void checkSourceVersionCompatibility(Source source, Log log) {
            SourceVersion procSourceVersion = this.processor.getSupportedSourceVersion();
            if (procSourceVersion.compareTo(Source.toSourceVersion(source)) < 0) {
                log.warning("proc.processor.incompatible.source.version", new Object[]{procSourceVersion, this.processor.getClass().getName(), source.name});
            }
        }

        private boolean checkOptionName(String optionName, Log log) {
            boolean valid = JavacProcessingEnvironment.isValidOptionName(optionName);
            if (!valid) {
                log.error("proc.processor.bad.option.name", optionName, this.processor.getClass().getName());
            }
            return valid;
        }

        public boolean annotationSupported(String annotationName) {
            for (Pattern p : this.supportedAnnotationPatterns) {
                if (!p.matcher(annotationName).matches()) continue;
                return true;
            }
            return false;
        }

        public void removeSupportedOptions(Set<String> unmatchedProcessorOptions) {
            unmatchedProcessorOptions.removeAll(this.supportedOptionNames);
        }
    }

    private static class NameProcessIterator
    implements Iterator<Processor> {
        Processor nextProc = null;
        Iterator<String> names;
        ClassLoader processorCL;
        Log log;

        NameProcessIterator(String names, ClassLoader processorCL, Log log) {
            this.names = Arrays.asList(names.split(",")).iterator();
            this.processorCL = processorCL;
            this.log = log;
        }

        @Override
        public boolean hasNext() {
            Processor processor;
            if (this.nextProc != null) {
                return true;
            }
            if (!this.names.hasNext()) {
                return false;
            }
            String processorName = this.names.next();
            try {
                try {
                    processor = (Processor)this.processorCL.loadClass(processorName).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.error("proc.processor.not.found", processorName);
                    return false;
                }
                catch (ClassCastException cce) {
                    this.log.error("proc.processor.wrong.type", processorName);
                    return false;
                }
                catch (Exception e) {
                    this.log.error("proc.processor.cant.instantiate", processorName);
                    return false;
                }
            }
            catch (Throwable t) {
                throw new AnnotationProcessingError(t);
            }
            this.nextProc = processor;
            return true;
        }

        @Override
        public Processor next() {
            if (this.hasNext()) {
                Processor p = this.nextProc;
                this.nextProc = null;
                return p;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ServiceIterator
    implements Iterator<Processor> {
        private Iterator<?> iterator;
        private Log log;
        private Class<?> loaderClass;
        private boolean jusl;
        private Object loader;

        ServiceIterator(ClassLoader classLoader, Log log) {
            this.log = log;
            try {
                String loadMethodName;
                try {
                    this.loaderClass = Class.forName("java.util.ServiceLoader");
                    loadMethodName = "load";
                    this.jusl = true;
                }
                catch (ClassNotFoundException cnfe) {
                    try {
                        this.loaderClass = Class.forName("sun.misc.Service");
                        loadMethodName = "providers";
                        this.jusl = false;
                    }
                    catch (ClassNotFoundException cnfe2) {
                        this.iterator = JavacProcessingEnvironment.this.handleServiceLoaderUnavailability("proc.no.service", null);
                        return;
                    }
                }
                Method loadMethod = this.loaderClass.getMethod(loadMethodName, Class.class, ClassLoader.class);
                Object result = loadMethod.invoke(null, Processor.class, classLoader);
                if (this.jusl) {
                    this.loader = result;
                    Method m = this.loaderClass.getMethod("iterator", new Class[0]);
                    result = m.invoke(result, new Object[0]);
                }
                this.iterator = (Iterator)result;
            }
            catch (Throwable t) {
                log.error("proc.service.problem", new Object[0]);
                throw new Abort(t);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (Throwable t) {
                if ("ServiceConfigurationError".equals(t.getClass().getSimpleName())) {
                    this.log.error("proc.bad.config.file", t.getLocalizedMessage());
                }
                throw new Abort(t);
            }
        }

        @Override
        public Processor next() {
            try {
                return (Processor)this.iterator.next();
            }
            catch (Throwable t) {
                if ("ServiceConfigurationError".equals(t.getClass().getSimpleName())) {
                    this.log.error("proc.bad.config.file", t.getLocalizedMessage());
                } else {
                    this.log.error("proc.processor.constructor.error", t.getLocalizedMessage());
                }
                throw new Abort(t);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            if (this.jusl) {
                try {
                    Method reloadMethod = this.loaderClass.getMethod("reload", new Class[0]);
                    reloadMethod.invoke(this.loader, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

