/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.ref.WeakReference;

public class UnsharedNameTable
extends Name.Table {
    private HashEntry[] hashes = null;
    private int hashMask;
    public int index;

    public static Name.Table create(Names names) {
        return new UnsharedNameTable(names);
    }

    public UnsharedNameTable(Names names, int hashSize) {
        super(names);
        this.hashMask = hashSize - 1;
        this.hashes = new HashEntry[hashSize];
    }

    public UnsharedNameTable(Names names) {
        this(names, 32768);
    }

    @Override
    public Name fromChars(char[] cs, int start, int len) {
        byte[] name = new byte[len * 3];
        int nbytes = Convert.chars2utf(cs, start, name, 0, len);
        return this.fromUtf(name, 0, nbytes);
    }

    @Override
    public Name fromUtf(byte[] cs, int start, int len) {
        int h = UnsharedNameTable.hashValue(cs, start, len) & this.hashMask;
        HashEntry element = this.hashes[h];
        NameImpl n = null;
        HashEntry previousNonNullTableEntry = null;
        HashEntry firstTableEntry = element;
        while (element != null && element != null) {
            n = (NameImpl)element.get();
            if (n == null) {
                if (firstTableEntry == element) {
                    this.hashes[h] = firstTableEntry = element.next;
                } else {
                    assert (previousNonNullTableEntry != null) : "previousNonNullTableEntry cannot be null here.";
                    previousNonNullTableEntry.next = element.next;
                }
            } else {
                if (n.getByteLength() == len && UnsharedNameTable.equals(n.bytes, 0, cs, start, len)) {
                    return n;
                }
                previousNonNullTableEntry = element;
            }
            element = element.next;
        }
        byte[] bytes = new byte[len];
        System.arraycopy(cs, start, bytes, 0, len);
        n = new NameImpl(this, bytes, this.index++);
        System.arraycopy(cs, start, n.bytes, 0, len);
        HashEntry newEntry = new HashEntry(n);
        if (previousNonNullTableEntry == null) {
            this.hashes[h] = newEntry;
        } else {
            assert (previousNonNullTableEntry.next == null) : "previousNonNullTableEntry.next must be null.";
            previousNonNullTableEntry.next = newEntry;
        }
        return n;
    }

    @Override
    public void dispose() {
        this.hashes = null;
    }

    static class NameImpl
    extends Name {
        final byte[] bytes;
        final int index;

        NameImpl(UnsharedNameTable table, byte[] bytes, int index) {
            super(table);
            this.bytes = bytes;
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getByteLength() {
            return this.bytes.length;
        }

        @Override
        public byte getByteAt(int i) {
            return this.bytes[i];
        }

        @Override
        public byte[] getByteArray() {
            return this.bytes;
        }

        @Override
        public int getByteOffset() {
            return 0;
        }
    }

    static class HashEntry
    extends WeakReference<NameImpl> {
        HashEntry next;

        HashEntry(NameImpl referent) {
            super(referent);
        }
    }
}

