/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.visitor;

import japa.parser.ast.BlockComment;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.IndexUnit;
import japa.parser.ast.LineComment;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.AnnotationDeclaration;
import japa.parser.ast.body.AnnotationMemberDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EmptyMemberDeclaration;
import japa.parser.ast.body.EmptyTypeDeclaration;
import japa.parser.ast.body.EnumConstantDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.InitializerDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayAccessExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.AssignExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.CastExpr;
import japa.parser.ast.expr.CharLiteralExpr;
import japa.parser.ast.expr.ClassExpr;
import japa.parser.ast.expr.ConditionalExpr;
import japa.parser.ast.expr.DoubleLiteralExpr;
import japa.parser.ast.expr.EnclosedExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.FieldAccessExpr;
import japa.parser.ast.expr.InstanceOfExpr;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.IntegerLiteralMinValueExpr;
import japa.parser.ast.expr.LongLiteralExpr;
import japa.parser.ast.expr.LongLiteralMinValueExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.NullLiteralExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.expr.SuperExpr;
import japa.parser.ast.expr.ThisExpr;
import japa.parser.ast.expr.UnaryExpr;
import japa.parser.ast.expr.VariableDeclarationExpr;
import japa.parser.ast.stmt.AssertStmt;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.BreakStmt;
import japa.parser.ast.stmt.CatchClause;
import japa.parser.ast.stmt.ContinueStmt;
import japa.parser.ast.stmt.DoStmt;
import japa.parser.ast.stmt.EmptyStmt;
import japa.parser.ast.stmt.ExplicitConstructorInvocationStmt;
import japa.parser.ast.stmt.ExpressionStmt;
import japa.parser.ast.stmt.ForStmt;
import japa.parser.ast.stmt.ForeachStmt;
import japa.parser.ast.stmt.IfStmt;
import japa.parser.ast.stmt.LabeledStmt;
import japa.parser.ast.stmt.ReturnStmt;
import japa.parser.ast.stmt.Statement;
import japa.parser.ast.stmt.SwitchEntryStmt;
import japa.parser.ast.stmt.SwitchStmt;
import japa.parser.ast.stmt.SynchronizedStmt;
import japa.parser.ast.stmt.ThrowStmt;
import japa.parser.ast.stmt.TryStmt;
import japa.parser.ast.stmt.TypeDeclarationStmt;
import japa.parser.ast.stmt.WhileStmt;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.VoidVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VoidVisitorAdapter<A>
implements VoidVisitor<A> {
    @Override
    public void visit(AnnotationDeclaration annotationDeclaration, A a) {
        if (annotationDeclaration.getJavaDoc() != null) {
            annotationDeclaration.getJavaDoc().accept(this, a);
        }
        if (annotationDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : annotationDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (annotationDeclaration.getMembers() != null) {
            for (BodyDeclaration bodyDeclaration : annotationDeclaration.getMembers()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(AnnotationMemberDeclaration annotationMemberDeclaration, A a) {
        if (annotationMemberDeclaration.getJavaDoc() != null) {
            annotationMemberDeclaration.getJavaDoc().accept(this, a);
        }
        if (annotationMemberDeclaration.getAnnotations() != null) {
            for (AnnotationExpr annotationExpr : annotationMemberDeclaration.getAnnotations()) {
                annotationExpr.accept(this, a);
            }
        }
        annotationMemberDeclaration.getType().accept(this, a);
        if (annotationMemberDeclaration.getDefaultValue() != null) {
            annotationMemberDeclaration.getDefaultValue().accept(this, a);
        }
    }

    @Override
    public void visit(ArrayAccessExpr arrayAccessExpr, A a) {
        arrayAccessExpr.getName().accept(this, a);
        arrayAccessExpr.getIndex().accept(this, a);
    }

    @Override
    public void visit(ArrayCreationExpr arrayCreationExpr, A a) {
        arrayCreationExpr.getType().accept(this, a);
        if (arrayCreationExpr.getDimensions() != null) {
            for (Expression expression : arrayCreationExpr.getDimensions()) {
                expression.accept(this, a);
            }
        } else {
            arrayCreationExpr.getInitializer().accept(this, a);
        }
    }

    @Override
    public void visit(ArrayInitializerExpr arrayInitializerExpr, A a) {
        if (arrayInitializerExpr.getValues() != null) {
            for (Expression expression : arrayInitializerExpr.getValues()) {
                expression.accept(this, a);
            }
        }
    }

    @Override
    public void visit(AssertStmt assertStmt, A a) {
        assertStmt.getCheck().accept(this, a);
        if (assertStmt.getMessage() != null) {
            assertStmt.getMessage().accept(this, a);
        }
    }

    @Override
    public void visit(AssignExpr assignExpr, A a) {
        assignExpr.getTarget().accept(this, a);
        assignExpr.getValue().accept(this, a);
    }

    @Override
    public void visit(BinaryExpr binaryExpr, A a) {
        binaryExpr.getLeft().accept(this, a);
        binaryExpr.getRight().accept(this, a);
    }

    @Override
    public void visit(BlockComment blockComment, A a) {
    }

    @Override
    public void visit(BlockStmt blockStmt, A a) {
        if (blockStmt.getStmts() != null) {
            for (Statement statement : blockStmt.getStmts()) {
                statement.accept(this, a);
            }
        }
    }

    @Override
    public void visit(BooleanLiteralExpr booleanLiteralExpr, A a) {
    }

    @Override
    public void visit(BreakStmt breakStmt, A a) {
    }

    @Override
    public void visit(CastExpr castExpr, A a) {
        castExpr.getType().accept(this, a);
        castExpr.getExpr().accept(this, a);
    }

    @Override
    public void visit(CatchClause catchClause, A a) {
        catchClause.getExcept().accept(this, a);
        catchClause.getCatchBlock().accept(this, a);
    }

    @Override
    public void visit(CharLiteralExpr charLiteralExpr, A a) {
    }

    @Override
    public void visit(ClassExpr classExpr, A a) {
        classExpr.getType().accept(this, a);
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, A a) {
        if (classOrInterfaceDeclaration.getJavaDoc() != null) {
            classOrInterfaceDeclaration.getJavaDoc().accept(this, a);
        }
        if (classOrInterfaceDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : classOrInterfaceDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (classOrInterfaceDeclaration.getTypeParameters() != null) {
            for (TypeParameter typeParameter : classOrInterfaceDeclaration.getTypeParameters()) {
                typeParameter.accept(this, a);
            }
        }
        if (classOrInterfaceDeclaration.getExtends() != null) {
            for (ClassOrInterfaceType classOrInterfaceType : classOrInterfaceDeclaration.getExtends()) {
                classOrInterfaceType.accept(this, a);
            }
        }
        if (classOrInterfaceDeclaration.getImplements() != null) {
            for (ClassOrInterfaceType classOrInterfaceType : classOrInterfaceDeclaration.getImplements()) {
                classOrInterfaceType.accept(this, a);
            }
        }
        if (classOrInterfaceDeclaration.getMembers() != null) {
            for (BodyDeclaration bodyDeclaration : classOrInterfaceDeclaration.getMembers()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(ClassOrInterfaceType classOrInterfaceType, A a) {
        if (classOrInterfaceType.getScope() != null) {
            classOrInterfaceType.getScope().accept(this, a);
        }
        if (classOrInterfaceType.getTypeArgs() != null) {
            for (Type type : classOrInterfaceType.getTypeArgs()) {
                type.accept(this, a);
            }
        }
    }

    @Override
    public void visit(CompilationUnit compilationUnit, A a) {
        if (compilationUnit.getPackage() != null) {
            compilationUnit.getPackage().accept(this, a);
        }
        if (compilationUnit.getImports() != null) {
            for (ImportDeclaration node : compilationUnit.getImports()) {
                node.accept(this, a);
            }
        }
        if (compilationUnit.getTypes() != null) {
            for (TypeDeclaration typeDeclaration : compilationUnit.getTypes()) {
                typeDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(ConditionalExpr conditionalExpr, A a) {
        conditionalExpr.getCondition().accept(this, a);
        conditionalExpr.getThenExpr().accept(this, a);
        conditionalExpr.getElseExpr().accept(this, a);
    }

    @Override
    public void visit(ConstructorDeclaration constructorDeclaration, A a) {
        if (constructorDeclaration.getJavaDoc() != null) {
            constructorDeclaration.getJavaDoc().accept(this, a);
        }
        if (constructorDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : constructorDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (constructorDeclaration.getTypeParameters() != null) {
            for (TypeParameter typeParameter : constructorDeclaration.getTypeParameters()) {
                typeParameter.accept(this, a);
            }
        }
        if (constructorDeclaration.getParameters() != null) {
            for (Parameter parameter : constructorDeclaration.getParameters()) {
                parameter.accept(this, a);
            }
        }
        if (constructorDeclaration.getThrows() != null) {
            for (NameExpr nameExpr : constructorDeclaration.getThrows()) {
                nameExpr.accept(this, a);
            }
        }
        constructorDeclaration.getBlock().accept(this, a);
    }

    @Override
    public void visit(ContinueStmt continueStmt, A a) {
    }

    @Override
    public void visit(DoStmt doStmt, A a) {
        doStmt.getBody().accept(this, a);
        doStmt.getCondition().accept(this, a);
    }

    @Override
    public void visit(DoubleLiteralExpr doubleLiteralExpr, A a) {
    }

    @Override
    public void visit(EmptyMemberDeclaration emptyMemberDeclaration, A a) {
        if (emptyMemberDeclaration.getJavaDoc() != null) {
            emptyMemberDeclaration.getJavaDoc().accept(this, a);
        }
    }

    @Override
    public void visit(EmptyStmt emptyStmt, A a) {
    }

    @Override
    public void visit(EmptyTypeDeclaration emptyTypeDeclaration, A a) {
        if (emptyTypeDeclaration.getJavaDoc() != null) {
            emptyTypeDeclaration.getJavaDoc().accept(this, a);
        }
    }

    @Override
    public void visit(EnclosedExpr enclosedExpr, A a) {
        enclosedExpr.getInner().accept(this, a);
    }

    @Override
    public void visit(EnumConstantDeclaration enumConstantDeclaration, A a) {
        if (enumConstantDeclaration.getJavaDoc() != null) {
            enumConstantDeclaration.getJavaDoc().accept(this, a);
        }
        if (enumConstantDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : enumConstantDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (enumConstantDeclaration.getArgs() != null) {
            for (Expression expression : enumConstantDeclaration.getArgs()) {
                expression.accept(this, a);
            }
        }
        if (enumConstantDeclaration.getClassBody() != null) {
            for (BodyDeclaration bodyDeclaration : enumConstantDeclaration.getClassBody()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(EnumDeclaration enumDeclaration, A a) {
        if (enumDeclaration.getJavaDoc() != null) {
            enumDeclaration.getJavaDoc().accept(this, a);
        }
        if (enumDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : enumDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (enumDeclaration.getImplements() != null) {
            for (ClassOrInterfaceType classOrInterfaceType : enumDeclaration.getImplements()) {
                classOrInterfaceType.accept(this, a);
            }
        }
        if (enumDeclaration.getEntries() != null) {
            for (EnumConstantDeclaration enumConstantDeclaration : enumDeclaration.getEntries()) {
                enumConstantDeclaration.accept(this, a);
            }
        }
        if (enumDeclaration.getMembers() != null) {
            for (BodyDeclaration bodyDeclaration : enumDeclaration.getMembers()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt, A a) {
        if (!explicitConstructorInvocationStmt.isThis() && explicitConstructorInvocationStmt.getExpr() != null) {
            explicitConstructorInvocationStmt.getExpr().accept(this, a);
        }
        if (explicitConstructorInvocationStmt.getTypeArgs() != null) {
            for (Type node : explicitConstructorInvocationStmt.getTypeArgs()) {
                node.accept(this, a);
            }
        }
        if (explicitConstructorInvocationStmt.getArgs() != null) {
            for (Expression expression : explicitConstructorInvocationStmt.getArgs()) {
                expression.accept(this, a);
            }
        }
    }

    @Override
    public void visit(ExpressionStmt expressionStmt, A a) {
        expressionStmt.getExpression().accept(this, a);
    }

    @Override
    public void visit(FieldAccessExpr fieldAccessExpr, A a) {
        fieldAccessExpr.getScope().accept(this, a);
    }

    @Override
    public void visit(FieldDeclaration fieldDeclaration, A a) {
        if (fieldDeclaration.getJavaDoc() != null) {
            fieldDeclaration.getJavaDoc().accept(this, a);
        }
        if (fieldDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : fieldDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        fieldDeclaration.getType().accept(this, a);
        for (VariableDeclarator variableDeclarator : fieldDeclaration.getVariables()) {
            variableDeclarator.accept(this, a);
        }
    }

    @Override
    public void visit(ForeachStmt foreachStmt, A a) {
        foreachStmt.getVariable().accept(this, a);
        foreachStmt.getIterable().accept(this, a);
        foreachStmt.getBody().accept(this, a);
    }

    @Override
    public void visit(ForStmt forStmt, A a) {
        if (forStmt.getInit() != null) {
            for (Expression expression : forStmt.getInit()) {
                expression.accept(this, a);
            }
        }
        if (forStmt.getCompare() != null) {
            forStmt.getCompare().accept(this, a);
        }
        if (forStmt.getUpdate() != null) {
            for (Expression expression : forStmt.getUpdate()) {
                expression.accept(this, a);
            }
        }
        forStmt.getBody().accept(this, a);
    }

    @Override
    public void visit(IfStmt ifStmt, A a) {
        ifStmt.getCondition().accept(this, a);
        ifStmt.getThenStmt().accept(this, a);
        if (ifStmt.getElseStmt() != null) {
            ifStmt.getElseStmt().accept(this, a);
        }
    }

    @Override
    public void visit(ImportDeclaration importDeclaration, A a) {
        importDeclaration.getName().accept(this, a);
    }

    @Override
    public void visit(InitializerDeclaration initializerDeclaration, A a) {
        if (initializerDeclaration.getJavaDoc() != null) {
            initializerDeclaration.getJavaDoc().accept(this, a);
        }
        initializerDeclaration.getBlock().accept(this, a);
    }

    @Override
    public void visit(InstanceOfExpr instanceOfExpr, A a) {
        instanceOfExpr.getExpr().accept(this, a);
        instanceOfExpr.getType().accept(this, a);
    }

    @Override
    public void visit(IntegerLiteralExpr integerLiteralExpr, A a) {
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr integerLiteralMinValueExpr, A a) {
    }

    @Override
    public void visit(JavadocComment javadocComment, A a) {
    }

    @Override
    public void visit(LabeledStmt labeledStmt, A a) {
        labeledStmt.getStmt().accept(this, a);
    }

    @Override
    public void visit(LineComment lineComment, A a) {
    }

    @Override
    public void visit(LongLiteralExpr longLiteralExpr, A a) {
    }

    @Override
    public void visit(LongLiteralMinValueExpr longLiteralMinValueExpr, A a) {
    }

    @Override
    public void visit(MarkerAnnotationExpr markerAnnotationExpr, A a) {
        markerAnnotationExpr.getName().accept(this, a);
    }

    @Override
    public void visit(MemberValuePair memberValuePair, A a) {
        memberValuePair.getValue().accept(this, a);
    }

    @Override
    public void visit(MethodCallExpr methodCallExpr, A a) {
        if (methodCallExpr.getScope() != null) {
            methodCallExpr.getScope().accept(this, a);
        }
        if (methodCallExpr.getTypeArgs() != null) {
            for (Type node : methodCallExpr.getTypeArgs()) {
                node.accept(this, a);
            }
        }
        if (methodCallExpr.getArgs() != null) {
            for (Expression expression : methodCallExpr.getArgs()) {
                expression.accept(this, a);
            }
        }
    }

    @Override
    public void visit(MethodDeclaration methodDeclaration, A a) {
        if (methodDeclaration.getJavaDoc() != null) {
            methodDeclaration.getJavaDoc().accept(this, a);
        }
        if (methodDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : methodDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (methodDeclaration.getTypeParameters() != null) {
            for (TypeParameter typeParameter : methodDeclaration.getTypeParameters()) {
                typeParameter.accept(this, a);
            }
        }
        methodDeclaration.getType().accept(this, a);
        if (methodDeclaration.getParameters() != null) {
            for (Parameter parameter : methodDeclaration.getParameters()) {
                parameter.accept(this, a);
            }
        }
        if (methodDeclaration.getThrows() != null) {
            for (NameExpr nameExpr : methodDeclaration.getThrows()) {
                nameExpr.accept(this, a);
            }
        }
        if (methodDeclaration.getBody() != null) {
            methodDeclaration.getBody().accept(this, a);
        }
    }

    @Override
    public void visit(NameExpr nameExpr, A a) {
    }

    @Override
    public void visit(NormalAnnotationExpr normalAnnotationExpr, A a) {
        normalAnnotationExpr.getName().accept(this, a);
        if (normalAnnotationExpr.getPairs() != null) {
            for (MemberValuePair memberValuePair : normalAnnotationExpr.getPairs()) {
                memberValuePair.accept(this, a);
            }
        }
    }

    @Override
    public void visit(NullLiteralExpr nullLiteralExpr, A a) {
    }

    @Override
    public void visit(ObjectCreationExpr objectCreationExpr, A a) {
        if (objectCreationExpr.getScope() != null) {
            objectCreationExpr.getScope().accept(this, a);
        }
        if (objectCreationExpr.getTypeArgs() != null) {
            for (Type node : objectCreationExpr.getTypeArgs()) {
                node.accept(this, a);
            }
        }
        objectCreationExpr.getType().accept(this, a);
        if (objectCreationExpr.getArgs() != null) {
            for (Expression expression : objectCreationExpr.getArgs()) {
                expression.accept(this, a);
            }
        }
        if (objectCreationExpr.getAnonymousClassBody() != null) {
            for (BodyDeclaration bodyDeclaration : objectCreationExpr.getAnonymousClassBody()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(PackageDeclaration packageDeclaration, A a) {
        if (packageDeclaration.getAnnotations() != null) {
            for (AnnotationExpr annotationExpr : packageDeclaration.getAnnotations()) {
                annotationExpr.accept(this, a);
            }
        }
        packageDeclaration.getName().accept(this, a);
    }

    @Override
    public void visit(Parameter parameter, A a) {
        if (parameter.getAnnotations() != null) {
            for (AnnotationExpr annotationExpr : parameter.getAnnotations()) {
                annotationExpr.accept(this, a);
            }
        }
        parameter.getType().accept(this, a);
        parameter.getId().accept(this, a);
    }

    @Override
    public void visit(PrimitiveType primitiveType, A a) {
    }

    @Override
    public void visit(QualifiedNameExpr qualifiedNameExpr, A a) {
        qualifiedNameExpr.getQualifier().accept(this, a);
    }

    @Override
    public void visit(ReferenceType referenceType, A a) {
        referenceType.getType().accept(this, a);
    }

    @Override
    public void visit(ReturnStmt returnStmt, A a) {
        if (returnStmt.getExpr() != null) {
            returnStmt.getExpr().accept(this, a);
        }
    }

    @Override
    public void visit(SingleMemberAnnotationExpr singleMemberAnnotationExpr, A a) {
        singleMemberAnnotationExpr.getName().accept(this, a);
        singleMemberAnnotationExpr.getMemberValue().accept(this, a);
    }

    @Override
    public void visit(StringLiteralExpr stringLiteralExpr, A a) {
    }

    @Override
    public void visit(SuperExpr superExpr, A a) {
        if (superExpr.getClassExpr() != null) {
            superExpr.getClassExpr().accept(this, a);
        }
    }

    @Override
    public void visit(SwitchEntryStmt switchEntryStmt, A a) {
        if (switchEntryStmt.getLabel() != null) {
            switchEntryStmt.getLabel().accept(this, a);
        }
        if (switchEntryStmt.getStmts() != null) {
            for (Statement statement : switchEntryStmt.getStmts()) {
                statement.accept(this, a);
            }
        }
    }

    @Override
    public void visit(SwitchStmt switchStmt, A a) {
        switchStmt.getSelector().accept(this, a);
        if (switchStmt.getEntries() != null) {
            for (SwitchEntryStmt switchEntryStmt : switchStmt.getEntries()) {
                switchEntryStmt.accept(this, a);
            }
        }
    }

    @Override
    public void visit(SynchronizedStmt synchronizedStmt, A a) {
        synchronizedStmt.getExpr().accept(this, a);
        synchronizedStmt.getBlock().accept(this, a);
    }

    @Override
    public void visit(ThisExpr thisExpr, A a) {
        if (thisExpr.getClassExpr() != null) {
            thisExpr.getClassExpr().accept(this, a);
        }
    }

    @Override
    public void visit(ThrowStmt throwStmt, A a) {
        throwStmt.getExpr().accept(this, a);
    }

    @Override
    public void visit(TryStmt tryStmt, A a) {
        tryStmt.getTryBlock().accept(this, a);
        if (tryStmt.getCatchs() != null) {
            for (CatchClause catchClause : tryStmt.getCatchs()) {
                catchClause.accept(this, a);
            }
        }
        if (tryStmt.getFinallyBlock() != null) {
            tryStmt.getFinallyBlock().accept(this, a);
        }
    }

    @Override
    public void visit(TypeDeclarationStmt typeDeclarationStmt, A a) {
        typeDeclarationStmt.getTypeDeclaration().accept(this, a);
    }

    @Override
    public void visit(TypeParameter typeParameter, A a) {
        if (typeParameter.getTypeBound() != null) {
            for (ClassOrInterfaceType classOrInterfaceType : typeParameter.getTypeBound()) {
                classOrInterfaceType.accept(this, a);
            }
        }
    }

    @Override
    public void visit(UnaryExpr unaryExpr, A a) {
        unaryExpr.getExpr().accept(this, a);
    }

    @Override
    public void visit(VariableDeclarationExpr variableDeclarationExpr, A a) {
        if (variableDeclarationExpr.getAnnotations() != null) {
            for (AnnotationExpr node : variableDeclarationExpr.getAnnotations()) {
                node.accept(this, a);
            }
        }
        variableDeclarationExpr.getType().accept(this, a);
        for (VariableDeclarator variableDeclarator : variableDeclarationExpr.getVars()) {
            variableDeclarator.accept(this, a);
        }
    }

    @Override
    public void visit(VariableDeclarator variableDeclarator, A a) {
        variableDeclarator.getId().accept(this, a);
        if (variableDeclarator.getInit() != null) {
            variableDeclarator.getInit().accept(this, a);
        }
    }

    @Override
    public void visit(VariableDeclaratorId variableDeclaratorId, A a) {
    }

    @Override
    public void visit(VoidType voidType, A a) {
    }

    @Override
    public void visit(WhileStmt whileStmt, A a) {
        whileStmt.getCondition().accept(this, a);
        whileStmt.getBody().accept(this, a);
    }

    @Override
    public void visit(WildcardType wildcardType, A a) {
        if (wildcardType.getExtends() != null) {
            wildcardType.getExtends().accept(this, a);
        }
        if (wildcardType.getSuper() != null) {
            wildcardType.getSuper().accept(this, a);
        }
    }

    @Override
    public void visit(IndexUnit indexUnit, A a) {
        for (CompilationUnit compilationUnit : indexUnit.getCompilationUnits()) {
            compilationUnit.accept(this, a);
        }
    }
}

