/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.ReadOnlyChannel;

@NotThreadSafe
public class BufferedReadOnlyChannel
extends ReadOnlyChannel {
    private static final long INVALID = Long.MIN_VALUE;
    private long pos;
    private long bufferStart = Long.MIN_VALUE;
    private final byte[] buffer;

    @CreatesObligation
    public BufferedReadOnlyChannel(@WillCloseWhenClosed SeekableByteChannel channel) {
        this(channel, 8192);
    }

    @CreatesObligation
    public BufferedReadOnlyChannel(@WillCloseWhenClosed SeekableByteChannel channel, int bufferSize) {
        super(channel);
        this.buffer = new byte[bufferSize];
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int remaining = dst.remaining();
        if (remaining <= 0) {
            return 0;
        }
        long size = this.size();
        if (this.position() >= size) {
            return -1;
        }
        int total = 0;
        int bufferSize = this.buffer.length;
        while (total < remaining && this.pos < size) {
            this.positionBuffer();
            int bufferPos = (int)(this.pos - this.bufferStart);
            int bufferLimit = Math.min(remaining - total, bufferSize - bufferPos);
            bufferLimit = (int)Math.min((long)bufferLimit, size - this.pos);
            assert (bufferLimit > 0);
            dst.put(this.buffer, bufferPos, bufferLimit);
            total += bufferLimit;
            this.pos += (long)bufferLimit;
        }
        return total;
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.pos;
    }

    @Override
    public SeekableByteChannel position(long pos) throws IOException {
        if (0L > pos) {
            throw new IllegalArgumentException();
        }
        this.checkOpen();
        this.pos = pos;
        return this;
    }

    public BufferedReadOnlyChannel sync() {
        this.bufferStart = Long.MIN_VALUE;
        return this;
    }

    private void positionBuffer() throws IOException {
        int bufferSize = this.buffer.length;
        long pos = this.pos;
        long bufferStart = this.bufferStart;
        long nextBufferStart = bufferStart + (long)bufferSize;
        if (bufferStart <= pos && pos < nextBufferStart) {
            return;
        }
        try {
            int read;
            SeekableByteChannel channel = this.channel;
            this.bufferStart = bufferStart = pos / (long)bufferSize * (long)bufferSize;
            if (bufferStart != nextBufferStart) {
                channel.position(bufferStart);
            }
            int total = 0;
            ByteBuffer buffer = ByteBuffer.wrap(this.buffer);
            while ((read = channel.read(buffer)) >= 0 && (total += read) < bufferSize) {
            }
        }
        catch (Throwable ex) {
            this.bufferStart = Long.MIN_VALUE;
            throw ex;
        }
    }
}

