/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import net.java.truecommons.io.ImmutableBuffer;
import net.java.truecommons.io.MutableBuffer;

public abstract class PowerBuffer<This extends PowerBuffer<This>>
implements Comparable<This>,
Cloneable {
    ByteBuffer bb;

    PowerBuffer(ByteBuffer bb) {
        this.bb = bb;
    }

    public static PowerBuffer<?> allocateDirect(int capacity) {
        return MutableBuffer.allocateDirect(capacity);
    }

    public static PowerBuffer<?> allocate(int capacity) {
        return MutableBuffer.allocate(capacity);
    }

    public static PowerBuffer<?> wrap(byte[] array) {
        return MutableBuffer.wrap(array);
    }

    public static PowerBuffer<?> wrap(byte[] array, int offset, int length) {
        return MutableBuffer.wrap(array, offset, length);
    }

    public static PowerBuffer<?> wrap(ByteBuffer buffer) {
        return MutableBuffer.wrap(buffer);
    }

    public abstract boolean isMutable();

    public abstract MutableBuffer asMutableBuffer();

    public abstract ImmutableBuffer asImmutableBuffer();

    public This clone() {
        PowerBuffer clone;
        try {
            clone = (PowerBuffer)super.clone();
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        clone.bb = PowerBuffer.clone(this.bb);
        return (This)clone;
    }

    public ByteBuffer buffer() {
        return this.bb;
    }

    public This littleEndian() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return (This)this;
    }

    public This bigEndian() {
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return (This)this;
    }

    public This load(ReadableByteChannel channel) throws EOFException, IOException {
        int read;
        int remaining = this.bb.remaining();
        this.bb.mark();
        do {
            if (0 <= (read = channel.read(this.bb))) continue;
            throw new EOFException();
        } while (0 < (remaining -= read));
        this.bb.reset();
        return (This)this;
    }

    public This save(WritableByteChannel channel) throws IOException {
        int remaining = this.bb.remaining();
        this.bb.mark();
        while (0 < (remaining -= channel.write(this.bb))) {
        }
        this.bb.reset();
        return (This)this;
    }

    public This skip(int skip) {
        this.bb.position(this.bb.position() + skip);
        return (This)this;
    }

    public int getUByte() {
        return this.bb.get() & 0xFF;
    }

    public final int getUByte(int index) {
        return this.bb.get(index) & 0xFF;
    }

    public int getUShort() {
        return this.bb.getShort() & 0xFFFF;
    }

    public final int getUShort(int index) {
        return this.bb.getShort(index) & 0xFFFF;
    }

    public long getUInt() {
        return (long)this.bb.getInt() & 0xFFFFFFFFL;
    }

    public final long getUInt(int index) {
        return (long)this.bb.getInt(index) & 0xFFFFFFFFL;
    }

    public final int position() {
        return this.bb.position();
    }

    public final int limit() {
        return this.bb.limit();
    }

    public final int capacity() {
        return this.bb.capacity();
    }

    public This position(int newPosition) {
        this.bb.position(newPosition);
        return (This)this;
    }

    public This limit(int newLimit) {
        this.bb.limit(newLimit);
        return (This)this;
    }

    public This mark() {
        this.bb.mark();
        return (This)this;
    }

    public This reset() {
        this.bb.reset();
        return (This)this;
    }

    public This clear() {
        this.bb.clear();
        return (This)this;
    }

    public This flip() {
        this.bb.flip();
        return (This)this;
    }

    public This rewind() {
        this.bb.rewind();
        return (This)this;
    }

    public final int remaining() {
        return this.bb.remaining();
    }

    public final boolean hasRemaining() {
        return this.bb.hasRemaining();
    }

    public final boolean isReadOnly() {
        return this.bb.isReadOnly();
    }

    public final boolean hasArray() {
        return this.bb.hasArray();
    }

    public byte[] array() {
        return this.bb.array();
    }

    public final int arrayOffset() {
        return this.bb.arrayOffset();
    }

    public final boolean isDirect() {
        return this.bb.isDirect();
    }

    public abstract This slice();

    public abstract This duplicate();

    public abstract This asReadOnlyBuffer();

    public byte get() {
        return this.bb.get();
    }

    public This put(byte b) {
        this.bb.put(b);
        return (This)this;
    }

    public final byte get(int index) {
        return this.bb.get(index);
    }

    public final This put(int index, byte b) {
        this.bb.put(index, b);
        return (This)this;
    }

    public This get(byte[] dst, int offset, int length) {
        this.bb.get(dst, offset, length);
        return (This)this;
    }

    public This get(byte[] dst) {
        this.bb.get(dst);
        return (This)this;
    }

    public final This put(PowerBuffer<?> src) {
        return this.put(src.buffer());
    }

    public This put(ByteBuffer src) {
        this.bb.put(src);
        return (This)this;
    }

    public This put(byte[] src, int offset, int length) {
        this.bb.put(src, offset, length);
        return (This)this;
    }

    public This put(byte[] src) {
        this.bb.put(src);
        return (This)this;
    }

    public This compact() {
        this.bb.compact();
        return (This)this;
    }

    public final String toString() {
        return String.format("%s[position=%d, limit=%d, capacity=%d]", this.getClass().getName(), this.position(), this.limit(), this.capacity());
    }

    @Override
    public final int compareTo(This that) {
        return this.bb.compareTo(((PowerBuffer)that).buffer());
    }

    public final int hashCode() {
        return this.bb.hashCode();
    }

    public final boolean equals(Object that) {
        return this == that || that instanceof PowerBuffer && this.bb.equals(((PowerBuffer)that).buffer());
    }

    public final ByteOrder order() {
        return this.bb.order();
    }

    public This order(ByteOrder order) {
        this.bb.order(order);
        return (This)this;
    }

    public char getChar() {
        return this.bb.getChar();
    }

    public This putChar(char value) {
        this.bb.putChar(value);
        return (This)this;
    }

    public final char getChar(int index) {
        return this.bb.getChar(index);
    }

    public final This putChar(int index, char value) {
        this.bb.putChar(index, value);
        return (This)this;
    }

    public final CharBuffer asCharBuffer() {
        return this.bb.asCharBuffer();
    }

    public short getShort() {
        return this.bb.getShort();
    }

    public This putShort(short value) {
        this.bb.putShort(value);
        return (This)this;
    }

    public final short getShort(int index) {
        return this.bb.getShort(index);
    }

    public final This putShort(int index, short value) {
        this.bb.putShort(index, value);
        return (This)this;
    }

    public final ShortBuffer asShortBuffer() {
        return this.bb.asShortBuffer();
    }

    public int getInt() {
        return this.bb.getInt();
    }

    public This putInt(int value) {
        this.bb.putInt(value);
        return (This)this;
    }

    public final int getInt(int index) {
        return this.bb.getInt(index);
    }

    public final This putInt(int index, int value) {
        this.bb.putInt(index, value);
        return (This)this;
    }

    public final IntBuffer asIntBuffer() {
        return this.bb.asIntBuffer();
    }

    public long getLong() {
        return this.bb.getLong();
    }

    public This putLong(long value) {
        this.bb.putLong(value);
        return (This)this;
    }

    public final long getLong(int index) {
        return this.bb.getLong(index);
    }

    public final This putLong(int index, long value) {
        this.bb.putLong(index, value);
        return (This)this;
    }

    public final LongBuffer asLongBuffer() {
        return this.bb.asLongBuffer();
    }

    public float getFloat() {
        return this.bb.getFloat();
    }

    public This putFloat(float value) {
        this.bb.putFloat(value);
        return (This)this;
    }

    public final float getFloat(int index) {
        return this.bb.getFloat(index);
    }

    public final This putFloat(int index, float value) {
        this.bb.putFloat(index, value);
        return (This)this;
    }

    public final FloatBuffer asFloatBuffer() {
        return this.bb.asFloatBuffer();
    }

    public double getDouble() {
        return this.bb.getDouble();
    }

    public This putDouble(double value) {
        this.bb.putDouble(value);
        return (This)this;
    }

    public final double getDouble(int index) {
        return this.bb.getDouble(index);
    }

    public final This putDouble(int index, double value) {
        this.bb.putDouble(index, value);
        return (This)this;
    }

    public final DoubleBuffer asDoubleBuffer() {
        return this.bb.asDoubleBuffer();
    }

    static ByteBuffer clone(ByteBuffer bb) {
        return bb.duplicate().order(bb.order());
    }
}

