/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.core.LockManager;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLockManager
implements LockManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLockManager.class);
    private final LockingTaskExecutor lockingTaskExecutor;
    private final LockConfigurationExtractor lockConfigurationExtractor;

    public DefaultLockManager(LockProvider lockProvider, LockConfigurationExtractor lockConfigurationExtractor) {
        this(new DefaultLockingTaskExecutor(lockProvider), lockConfigurationExtractor);
    }

    public DefaultLockManager(LockingTaskExecutor lockingTaskExecutor, LockConfigurationExtractor lockConfigurationExtractor) {
        this.lockingTaskExecutor = Objects.requireNonNull(lockingTaskExecutor);
        this.lockConfigurationExtractor = Objects.requireNonNull(lockConfigurationExtractor);
    }

    @Override
    public void executeWithLock(Runnable task) {
        Optional<LockConfiguration> lockConfigOptional = this.lockConfigurationExtractor.getLockConfiguration(task);
        if (!lockConfigOptional.isPresent()) {
            logger.debug("No lock configuration for {}. Executing without lock.", (Object)task);
            task.run();
        } else {
            this.lockingTaskExecutor.executeWithLock(task, lockConfigOptional.get());
        }
    }
}

