/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import net.javacrumbs.shedlock.support.annotation.Nullable;

public interface LockingTaskExecutor {
    public void executeWithLock(@NonNull Runnable var1, @NonNull LockConfiguration var2);

    public void executeWithLock(@NonNull Task var1, @NonNull LockConfiguration var2) throws Throwable;

    @NonNull
    default public <T> TaskResult<T> executeWithLock(@NonNull TaskWithResult<T> task, @NonNull LockConfiguration lockConfig) throws Throwable {
        throw new UnsupportedOperationException();
    }

    public static final class TaskResult<T> {
        private final boolean executed;
        private final T result;

        private TaskResult(boolean executed, @Nullable T result) {
            this.executed = executed;
            this.result = result;
        }

        public boolean wasExecuted() {
            return this.executed;
        }

        @Nullable
        public T getResult() {
            return this.result;
        }

        static <T> TaskResult<T> result(@Nullable T result) {
            return new TaskResult<T>(true, result);
        }

        static <T> TaskResult<T> notExecuted() {
            return new TaskResult<Object>(false, null);
        }
    }

    @FunctionalInterface
    public static interface TaskWithResult<T> {
        public T call() throws Throwable;
    }

    @FunctionalInterface
    public static interface Task {
        public void call() throws Throwable;
    }
}

