/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlStatementsSource;
import net.javacrumbs.shedlock.provider.sql.internal.CalendarUtils;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionTemplate;

class JdbcTemplateStorageAccessor
extends AbstractStorageAccessor {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplateLockProvider.Configuration configuration;
    private @Nullable SqlStatementsSource sqlStatementsSource;

    JdbcTemplateStorageAccessor(JdbcTemplateLockProvider.Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration can not be null");
        this.jdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)configuration.getJdbcTemplate());
        this.configuration = configuration;
        PlatformTransactionManager transactionManager = configuration.getTransactionManager() != null ? configuration.getTransactionManager() : new DataSourceTransactionManager(Objects.requireNonNull(configuration.getJdbcTemplate().getDataSource(), "DataSource can't be null"));
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
        if (configuration.getIsolationLevel() != null) {
            this.transactionTemplate.setIsolationLevel(configuration.getIsolationLevel().intValue());
        }
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        try {
            String sql = this.sqlStatementsSource().getInsertStatement();
            return this.execute(sql, lockConfiguration);
        }
        catch (ConcurrencyFailureException | DuplicateKeyException | TransactionSystemException e) {
            this.logger.debug("Duplicate key", e);
            return false;
        }
        catch (DataAccessException e) {
            this.logger.error("Unexpected exception", (Throwable)e);
            throw new LockException((Throwable)e);
        }
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource().getUpdateStatement();
        try {
            return this.execute(sql, lockConfiguration);
        }
        catch (ConcurrencyFailureException | DuplicateKeyException | TransactionSystemException e) {
            this.logger.debug("Serialization exception", e);
            return false;
        }
        catch (DataAccessException e) {
            this.logger.error("Unexpected exception", (Throwable)e);
            throw new LockException((Throwable)e);
        }
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource().getExtendStatement();
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return this.execute(sql, lockConfiguration);
    }

    public void unlock(LockConfiguration lockConfiguration) {
        for (int i = 0; i < 10; ++i) {
            try {
                this.doUnlock(lockConfiguration);
                return;
            }
            catch (ConcurrencyFailureException | TransactionSystemException e) {
                this.logger.info("Unlock failed due to TransactionSystemException - retrying attempt {}", (Object)(i + 1));
                continue;
            }
        }
        this.logger.error("Unlock failed after 10 attempts");
    }

    private void doUnlock(LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource().getUnlockStatement();
        this.execute(sql, lockConfiguration);
    }

    private boolean execute(String sql, LockConfiguration lockConfiguration) throws TransactionException {
        return (Boolean)this.transactionTemplate.execute(status -> this.jdbcTemplate.update(sql, this.params(lockConfiguration)) > 0);
    }

    private Map<String, Object> params(LockConfiguration lockConfiguration) {
        return this.sqlStatementsSource().params(lockConfiguration).entrySet().stream().map(e -> {
            Object value = e.getValue();
            if (value instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)value;
                return Map.entry((String)e.getKey(), CalendarUtils.toCalendar((ZonedDateTime)zdt));
            }
            return e;
        }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlStatementsSource sqlStatementsSource() {
        JdbcTemplateLockProvider.Configuration configuration = this.configuration;
        synchronized (configuration) {
            if (this.sqlStatementsSource == null) {
                this.sqlStatementsSource = SqlStatementsSource.create((SqlConfiguration)this.configuration);
            }
            return this.sqlStatementsSource;
        }
    }
}

