/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.lang.reflect.Field;
import net.javacrumbs.shedlock.core.DefaultLockManager;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.core.LockManager;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockableRunnable;
import net.javacrumbs.shedlock.spring.ExtendedLockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.aop.LockProviderSupplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.NameMatchMethodPointcut;
import org.springframework.aop.support.RootClassFilter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.support.ScheduledMethodRunnable;

class SchedulerProxyScheduledLockAdvisor
extends AbstractPointcutAdvisor {
    private final Pointcut pointcut = new TaskSchedulerPointcut();
    private final Advice advice;
    private static final Logger logger = LoggerFactory.getLogger(SchedulerProxyScheduledLockAdvisor.class);

    SchedulerProxyScheduledLockAdvisor(LockProviderSupplier lockProviderSupplier, ExtendedLockConfigurationExtractor lockConfigurationExtractor) {
        this.advice = new LockingInterceptor(lockProviderSupplier, lockConfigurationExtractor);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    private static class TaskSchedulerPointcut
    implements Pointcut {
        private TaskSchedulerPointcut() {
        }

        public ClassFilter getClassFilter() {
            return new RootClassFilter(TaskScheduler.class);
        }

        public MethodMatcher getMethodMatcher() {
            NameMatchMethodPointcut nameMatchMethodPointcut = new NameMatchMethodPointcut();
            nameMatchMethodPointcut.setMappedNames(new String[]{"schedule", "scheduleAtFixedRate", "scheduleWithFixedDelay"});
            return nameMatchMethodPointcut;
        }
    }

    private static class LockingInterceptor
    implements MethodInterceptor {
        private final LockProviderSupplier lockProviderSupplier;
        private final ExtendedLockConfigurationExtractor lockConfigurationExtractor;

        private LockingInterceptor(LockProviderSupplier lockProviderSupplier, ExtendedLockConfigurationExtractor lockConfigurationExtractor) {
            this.lockProviderSupplier = lockProviderSupplier;
            this.lockConfigurationExtractor = lockConfigurationExtractor;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object[] arguments = invocation.getArguments();
            if (arguments.length < 1) {
                throw new IllegalStateException("Task scheduler method does not have any arguments");
            }
            arguments[0] = this.wrapTask(arguments[0]);
            return invocation.proceed();
        }

        private Object wrapTask(Object firstArgument) throws NoSuchFieldException, IllegalAccessException {
            if (firstArgument instanceof ScheduledMethodRunnable) {
                ScheduledMethodRunnable task = (ScheduledMethodRunnable)firstArgument;
                return this.wrapTask(task);
            }
            if (firstArgument.getClass().getSimpleName().equals("OutcomeTrackingRunnable")) {
                Field runnable = firstArgument.getClass().getDeclaredField("runnable");
                runnable.setAccessible(true);
                Object wrappedRunnable = runnable.get(firstArgument);
                if (wrappedRunnable instanceof ScheduledMethodRunnable) {
                    ScheduledMethodRunnable task = (ScheduledMethodRunnable)wrappedRunnable;
                    return this.wrapTask(task);
                }
            }
            logger.warn("Task scheduler first argument should be ScheduledMethodRunnable or OutcomeTrackingRunnable");
            return firstArgument;
        }

        private LockableRunnable wrapTask(ScheduledMethodRunnable task) {
            LockProvider lockProvider = this.lockProviderSupplier.supply(task.getTarget(), task.getMethod(), new Object[0]);
            DefaultLockManager lockManager = new DefaultLockManager(lockProvider, (LockConfigurationExtractor)this.lockConfigurationExtractor);
            return new LockableRunnable((Runnable)task, (LockManager)lockManager);
        }
    }
}

