/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.javacrumbs.springws.test.NoResponseGeneratorSpecifiedException;
import net.javacrumbs.springws.test.RequestProcessor;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.transport.WebServiceConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockWebServiceConnection
implements WebServiceConnection {
    private final URI uri;
    private WebServiceMessage request;
    private List<RequestProcessor> requestProcessors;
    private List<EndpointInterceptor> interceptors = Collections.emptyList();
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();
    protected final Log logger = LogFactory.getLog(this.getClass());

    public MockWebServiceConnection(URI uri) {
        this.uri = uri;
    }

    public void send(WebServiceMessage message) throws IOException {
        this.request = message;
    }

    public WebServiceMessage receive(WebServiceMessageFactory messageFactory) throws IOException {
        DefaultMessageContext messageContext = new DefaultMessageContext(this.request, messageFactory);
        boolean callRequestProcessors = this.handleRequest((MessageContext)messageContext);
        if (callRequestProcessors) {
            WebServiceMessage response = this.generateResponse(messageFactory);
            messageContext.setResponse(response);
        }
        this.handleResponse((MessageContext)messageContext);
        return messageContext.getResponse();
    }

    protected boolean handleRequest(MessageContext messageContext) throws IOException {
        for (EndpointInterceptor interceptor : this.interceptors) {
            try {
                if (interceptor.handleRequest(messageContext, null)) continue;
                return false;
            }
            catch (Exception e) {
                throw new IOException("Unexpected exception", e);
            }
        }
        return true;
    }

    protected void handleResponse(MessageContext messageContext) throws IOException {
        if (!this.interceptors.isEmpty()) {
            boolean hasFault = this.hasFault(messageContext);
            for (EndpointInterceptor interceptor : this.interceptors) {
                try {
                    if (!(!hasFault ? !interceptor.handleResponse(messageContext, null) : !interceptor.handleFault(messageContext, null))) continue;
                    return;
                }
                catch (Exception e) {
                    throw new IOException("Unexpected exception", e);
                }
            }
        }
    }

    protected boolean hasFault(MessageContext messageContext) {
        boolean hasFault = false;
        WebServiceMessage response = messageContext.getResponse();
        if (response instanceof FaultAwareWebServiceMessage) {
            hasFault = ((FaultAwareWebServiceMessage)response).hasFault();
        }
        return hasFault;
    }

    protected WebServiceMessage generateResponse(WebServiceMessageFactory messageFactory) throws IOException {
        WebServiceMessage response = null;
        if (this.requestProcessors != null) {
            for (RequestProcessor responseGenerator : this.requestProcessors) {
                response = responseGenerator.processRequest(this.uri, messageFactory, this.request);
                if (response == null) continue;
                return response;
            }
        }
        return this.handleResponseNotFound(messageFactory);
    }

    protected WebServiceMessage handleResponseNotFound(WebServiceMessageFactory messageFactory) {
        throw new NoResponseGeneratorSpecifiedException("No response found for request. Please, log category \"net.javacrumbs.springws.test.lookup\" on DEBUG level to find out the reasons. ");
    }

    public void close() throws IOException {
    }

    public String getErrorMessage() throws IOException {
        return null;
    }

    public URI getUri() throws URISyntaxException {
        return this.uri;
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public WebServiceMessage getRequest() {
        return this.request;
    }

    public XmlUtil getXmlUtil() {
        return this.xmlUtil;
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }

    public Collection<RequestProcessor> getRequestProcessors() {
        return this.requestProcessors;
    }

    public void setRequestProcessors(List<RequestProcessor> responseGenerators) {
        this.requestProcessors = responseGenerators;
    }

    public List<EndpointInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<EndpointInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

