/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.expression;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import net.javacrumbs.springws.test.RequestProcessor;
import net.javacrumbs.springws.test.expression.ExpressionResolver;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionProcessor
implements RequestProcessor {
    private static final String TRUE = Boolean.TRUE.toString();
    private int order;
    private ExpressionResolver expressionResolver;
    private Map<String, String> exceptionMapping;
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();

    @Override
    public WebServiceMessage processRequest(URI uri, WebServiceMessageFactory messageFactory, WebServiceMessage request) throws IOException {
        for (Map.Entry<String, String> entry : this.exceptionMapping.entrySet()) {
            String result = this.expressionResolver.resolveExpression(entry.getKey(), uri, this.xmlUtil.loadDocument(request));
            if (!TRUE.equals(result)) continue;
            this.expressionValid(entry.getKey(), entry.getValue());
        }
        return null;
    }

    protected abstract void expressionValid(String var1, String var2);

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    public void setExpressionResolver(ExpressionResolver resolver) {
        this.expressionResolver = resolver;
    }

    public Map<String, String> getExceptionMapping() {
        return this.exceptionMapping;
    }

    public void setExceptionMapping(Map<String, String> exceptionMapping) {
        this.exceptionMapping = exceptionMapping;
    }

    public XmlUtil getXmlUtil() {
        return this.xmlUtil;
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }
}

