/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.generator;

import java.io.IOException;
import java.net.URI;
import net.javacrumbs.springws.test.RequestProcessor;
import net.javacrumbs.springws.test.common.MessageGenerator;
import net.javacrumbs.springws.test.lookup.ResourceLookup;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;

public class DefaultResponseGenerator
implements RequestProcessor,
Ordered {
    static final int DEFAULT_ORDER = 50;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ResourceLookup resourceLookup;
    private int order = 50;
    private MessageGenerator messageGenerator = new MessageGenerator();

    public WebServiceMessage processRequest(URI uri, WebServiceMessageFactory messageFactory, WebServiceMessage request) throws IOException {
        Resource resultResource = this.getResultResource(uri, request);
        if (resultResource == null) {
            this.logger.debug((Object)"Resource not found, returning null.");
            return null;
        }
        WebServiceMessage message = this.generateMessage(messageFactory, resultResource);
        this.postprocessMessage(message, uri, messageFactory, request);
        return message;
    }

    protected WebServiceMessage generateMessage(WebServiceMessageFactory messageFactory, Resource resultResource) throws IOException {
        return this.getMessageGenerator().generateMessage(messageFactory, resultResource);
    }

    protected void postprocessMessage(WebServiceMessage message, URI uri, WebServiceMessageFactory messageFactory, WebServiceMessage request) {
    }

    protected Resource getResultResource(URI uri, WebServiceMessage request) throws IOException {
        return this.resourceLookup.lookupResource(uri, request);
    }

    public ResourceLookup getResourceLookup() {
        return this.resourceLookup;
    }

    public void setResourceLookup(ResourceLookup resourceLookup) {
        this.resourceLookup = resourceLookup;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public XmlUtil getXmlUtil() {
        return this.getMessageGenerator().getXmlUtil();
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.getMessageGenerator().setXmlUtil(xmlUtil);
    }

    public boolean isAlwaysCreateEnvelope() {
        return this.getMessageGenerator().isAlwaysCreateEnvelope();
    }

    public void setAlwaysCreateEnvelope(boolean alwaysCreateEnvelope) {
        this.getMessageGenerator().setAlwaysCreateEnvelope(alwaysCreateEnvelope);
    }

    public boolean isNeverCreateEnvelope() {
        return this.getMessageGenerator().isNeverCreateEnvelope();
    }

    public void setNeverCreateEnvelope(boolean neverCreateEnvelope) {
        this.getMessageGenerator().setNeverCreateEnvelope(neverCreateEnvelope);
    }

    public MessageGenerator getMessageGenerator() {
        return this.messageGenerator;
    }

    public void setMessageGenerator(MessageGenerator messageGenerator) {
        this.messageGenerator = messageGenerator;
    }
}

