/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.helper;

import java.io.IOException;
import net.javacrumbs.springws.test.common.MessageGenerator;
import net.javacrumbs.springws.test.helper.DefaultStrategiesHelperFactory;
import net.javacrumbs.springws.test.helper.MessageValidator;
import net.javacrumbs.springws.test.helper.WsTestHelper;
import net.javacrumbs.springws.test.helper.WsTestWebServiceTemplate;
import net.javacrumbs.springws.test.template.TemplateProcessor;
import net.javacrumbs.springws.test.template.XsltTemplateProcessor;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;

public class DefaultWsTestHelper
implements ApplicationContextAware,
InitializingBean,
ResourceLoaderAware,
WsTestHelper {
    private ApplicationContext applicationContext;
    private WebServiceMessageFactory messageFactory;
    private ResourceLoader resourceLoader;
    private TemplateProcessor templateProcessor = new XsltTemplateProcessor();
    private final Log logger = LogFactory.getLog(this.getClass());
    private MessageGenerator generator = new MessageGenerator();
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();
    private WsTestWebServiceTemplate webServiceTemplate;
    private ClientInterceptor[] interceptors;
    private static final FaultMessageResolver DUMMY_FAULT_MESSAGE_RESOLVER = new FaultMessageResolver(){

        public void resolveFault(WebServiceMessage message) throws IOException {
        }
    };

    public MessageContext receiveMessage(WebServiceMessage message) throws Exception {
        DefaultMessageContext context = this.createMessageContext(message);
        this.webServiceTemplate.send((MessageContext)context);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Retreived message: \"" + this.getXmlUtil().serializeDocument(context.getResponse()) + "\""));
        }
        return context;
    }

    public MessageContext receiveMessage(Resource request) throws Exception {
        Assert.notNull((Object)request, (String)"Request can not be null.");
        WebServiceMessage message = this.loadMessage(request);
        return this.receiveMessage(message);
    }

    public MessageContext receiveMessage(String requestPath) throws Exception {
        return this.receiveMessage(this.resourceLoader.getResource(requestPath));
    }

    public WebServiceMessage loadMessage(Resource resource) throws IOException {
        Resource processedResource = this.preprocessResource(resource);
        WebServiceMessage message = this.generator.generateMessage(this.messageFactory, processedResource);
        return message;
    }

    protected Resource preprocessResource(Resource resource) throws IOException {
        return this.templateProcessor.processTemplate(resource, null);
    }

    public WebServiceMessage loadMessage(String resourcePath) throws IOException {
        return this.loadMessage(this.resourceLoader.getResource(resourcePath));
    }

    protected DefaultMessageContext createMessageContext(WebServiceMessage message) {
        return new DefaultMessageContext(message, this.messageFactory);
    }

    public MessageValidator createMessageValidator(WebServiceMessage message) {
        MessageValidator messageValidator = new MessageValidator(message);
        messageValidator.setResourceLoader(this.resourceLoader);
        messageValidator.setTemplateProcessor(this.templateProcessor);
        return messageValidator;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.initializeMessageFactory();
        this.initializeResourceLoader();
        this.initializeWebServiceTemplate();
    }

    protected void initializeResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = this.applicationContext != null ? this.applicationContext : new DefaultResourceLoader();
        }
    }

    protected void initializeWebServiceTemplate() {
        if (this.webServiceTemplate == null) {
            this.webServiceTemplate = new WsTestWebServiceTemplate();
            this.webServiceTemplate.setFaultMessageResolver(DUMMY_FAULT_MESSAGE_RESOLVER);
            this.webServiceTemplate.setApplicationContext(this.applicationContext);
            this.webServiceTemplate.setInterceptors(this.interceptors);
            this.webServiceTemplate.setMessageFactory(this.messageFactory);
            this.webServiceTemplate.afterPropertiesSet();
        }
    }

    protected void initializeMessageFactory() throws Exception {
        if (this.messageFactory == null) {
            this.messageFactory = DefaultStrategiesHelperFactory.createMessageFactory(this.applicationContext);
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public TemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public void setTemplateProcessor(TemplateProcessor templateProcessor) {
        this.templateProcessor = templateProcessor;
    }

    public MessageGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(MessageGenerator generator) {
        this.generator = generator;
    }

    public XmlUtil getXmlUtil() {
        return this.xmlUtil;
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }

    public ClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(ClientInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public WsTestWebServiceTemplate getWebServiceTemplate() {
        return this.webServiceTemplate;
    }

    public void setWebServiceTemplate(WsTestWebServiceTemplate webServiceTemplate) {
        this.webServiceTemplate = webServiceTemplate;
    }
}

