/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.helper;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import net.javacrumbs.springws.test.WsTestException;
import net.javacrumbs.springws.test.common.DefaultMessageComparator;
import net.javacrumbs.springws.test.common.ExpressionEvaluator;
import net.javacrumbs.springws.test.common.MessageComparator;
import net.javacrumbs.springws.test.common.SchemaValidator;
import net.javacrumbs.springws.test.common.XPathExpressionEvaluator;
import net.javacrumbs.springws.test.template.FreeMarkerTemplateProcessor;
import net.javacrumbs.springws.test.template.TemplateProcessor;
import net.javacrumbs.springws.test.template.XsltTemplateProcessor;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapEnvelopeException;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.springframework.xml.validation.XmlValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageValidator {
    private static final String TRUE = Boolean.TRUE.toString();
    private final WebServiceMessage message;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private TemplateProcessor templateProcessor = new XsltTemplateProcessor();
    private SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
    private MessageComparator messageComparator = new DefaultMessageComparator();
    private SchemaValidator schemaValidator = new SchemaValidator();
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private ExpressionEvaluator expressionEvaluator = new XPathExpressionEvaluator();
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();

    public MessageValidator(WebServiceMessage message) {
        this.message = message;
    }

    public MessageValidator compare(String controlResourcePath) {
        return this.compare(this.getResource(controlResourcePath));
    }

    public MessageValidator compare(Resource controlResource) {
        try {
            this.messageComparator.compareMessage(this.message, this.preprocessResource(controlResource));
        }
        catch (IOException e) {
            this.processIOException(e);
        }
        return this;
    }

    protected void processIOException(IOException e) {
        throw new WsTestException("Error when comparing messages", e);
    }

    public MessageValidator validate(String schemaPath, String ... schemaPaths) throws IOException {
        Resource[] schemas = new Resource[schemaPaths.length];
        for (int i = 0; i < schemas.length; ++i) {
            schemas[i] = this.resourceLoader.getResource(schemaPaths[i]);
        }
        return this.validate(this.resourceLoader.getResource(schemaPath), schemas);
    }

    public MessageValidator validate(Resource schema, Resource ... schemas) throws IOException {
        Resource[] joinedSchemas = new Resource[schemas.length + 1];
        joinedSchemas[0] = schema;
        System.arraycopy(schemas, 0, joinedSchemas, 1, schemas.length);
        this.validate(this.schemaValidator.createValidatorFromSchemas(joinedSchemas, this.schemaLanguage));
        return this;
    }

    public MessageValidator validate(XmlValidator xmlValidator) {
        try {
            this.schemaValidator.validate(this.message, xmlValidator);
        }
        catch (IOException e) {
            this.processIOException(e);
        }
        return this;
    }

    public MessageValidator useNamespaceMapping(Map<String, String> namespaceMapping) {
        this.namespaceContext = new SimpleNamespaceContext();
        this.namespaceContext.setBindings(namespaceMapping);
        return this;
    }

    public MessageValidator addNamespaceMapping(String prefix, String namespace) {
        this.namespaceContext.bindNamespaceUri(prefix, namespace);
        return this;
    }

    public MessageValidator assertXPath(String xpath) {
        return this.assertXPath(xpath, "Expression \"" + xpath + "\" does not evaluate to true.");
    }

    public MessageValidator assertXPath(String xpath, String errorMessage) {
        if (!TRUE.equals(this.evaluateExpression(xpath))) {
            throw new WsTestException(errorMessage, this.message);
        }
        return this;
    }

    protected String evaluateExpression(String expression) {
        return this.expressionEvaluator.evaluateExpression(this.xmlUtil.loadDocument(this.message), expression, null, (NamespaceContext)this.namespaceContext);
    }

    public MessageValidator assertNotSoapFault() {
        if (this.isSoapFault()) {
            throw new WsTestException("Message is SOAP fault", this.message);
        }
        return this;
    }

    public MessageValidator assertSoapMessage() {
        SoapMessage soapMessage = this.getSoapMessage();
        try {
            soapMessage.getEnvelope();
        }
        catch (SoapEnvelopeException e) {
            throw new WsTestException("Message is not a SOAP message", e);
        }
        return this;
    }

    public MessageValidator assertSoapFault() {
        if (!this.isSoapFault()) {
            throw new WsTestException("Message is not SOAP fault", this.message);
        }
        return this;
    }

    protected boolean isSoapFault() {
        return this.getSoapMessage().hasFault();
    }

    public SoapMessage getSoapMessage() {
        if (this.message instanceof SoapMessage) {
            return (SoapMessage)this.message;
        }
        throw new WsTestException("The message is not SOAP message");
    }

    public SoapFault getSoapFault() {
        this.assertSoapFault();
        return this.getSoapMessage().getSoapBody().getFault();
    }

    public MessageValidator assertFaultCode(String expectedFaultCode) {
        String faultCode = this.getSoapFault().getFaultCode().getLocalPart();
        if (!expectedFaultCode.equals(faultCode)) {
            throw new WsTestException("Expected fault code \"" + expectedFaultCode + "\", get \"" + faultCode + "\"", this.message);
        }
        return this;
    }

    public MessageValidator assertFaultStringOrReason(String expectedStringOrReason) {
        String faultStringOrReason = this.getSoapFault().getFaultStringOrReason();
        if (!expectedStringOrReason.equals(faultStringOrReason)) {
            throw new WsTestException("Expected fault string or reason \"" + expectedStringOrReason + "\", get \"" + faultStringOrReason + "\"", this.message);
        }
        return this;
    }

    public MessageValidator assertFaultActorOrRole(String expectedActorOrRole) {
        String faultActorOrRole = this.getSoapFault().getFaultActorOrRole();
        if (!expectedActorOrRole.equals(faultActorOrRole)) {
            throw new WsTestException("Expected fault actor or role \"" + expectedActorOrRole + "\", get \"" + faultActorOrRole + "\"", this.message);
        }
        return this;
    }

    public MessageValidator assertContainElement(String elementName) {
        return this.assertXPath("count(//*[local-name()='" + elementName + "'])>0", "Element \"" + elementName + "\" not found.");
    }

    public MessageValidator assertNotContainElement(String elementName) {
        return this.assertXPath("count(//*[local-name()='" + elementName + "'])=0", "Element \"" + elementName + "\" found.");
    }

    public MessageValidator assertContain(String regexp) {
        if (!this.contains(regexp)) {
            throw new WsTestException("Message does not contain regular expression \"" + regexp + "\"", this.message);
        }
        return this;
    }

    public MessageValidator assertNotContain(String regexp) {
        if (this.contains(regexp)) {
            throw new WsTestException("Message contains regular expression \"" + regexp + "\"", this.message);
        }
        return this;
    }

    private boolean contains(String regexp) {
        String messageAsText = this.xmlUtil.serializeDocument(this.message);
        Pattern pattern = Pattern.compile(regexp);
        return pattern.matcher(messageAsText).find();
    }

    protected Resource preprocessResource(Resource resource) throws IOException {
        return this.templateProcessor.processTemplate(resource, null);
    }

    protected Resource getResource(String resourcePath) {
        return this.resourceLoader.getResource(resourcePath);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public TemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public void setTemplateProcessor(TemplateProcessor templateProcessor) {
        this.templateProcessor = templateProcessor;
    }

    public MessageValidator useTemplateProcessor(TemplateProcessor templateProcessor) {
        this.setTemplateProcessor(templateProcessor);
        return this;
    }

    public MessageValidator useFreeMarkerTemplateProcessor() {
        FreeMarkerTemplateProcessor freemarkerTemplateProcessor = new FreeMarkerTemplateProcessor();
        freemarkerTemplateProcessor.setResourceLoader(this.resourceLoader);
        freemarkerTemplateProcessor.afterPropertiesSet();
        return this.useTemplateProcessor(freemarkerTemplateProcessor);
    }

    public MessageValidator useXsltTemplateProcessor() {
        return this.useTemplateProcessor(new XsltTemplateProcessor());
    }

    public WebServiceMessage getMessage() {
        return this.message;
    }

    public MessageComparator getMessageComparator() {
        return this.messageComparator;
    }

    public void setMessageComparator(MessageComparator messageComparator) {
        this.messageComparator = messageComparator;
    }

    public MessageValidator useMessageComparator(MessageComparator messageComparator) {
        this.setMessageComparator(messageComparator);
        return this;
    }

    public SchemaValidator getSchemaValidator() {
        return this.schemaValidator;
    }

    public void setSchemaValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = schemaValidator;
    }

    public MessageValidator useSchemaValidator(SchemaValidator schemaValidator) {
        this.setSchemaValidator(schemaValidator);
        return this;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public MessageValidator useSchemaLanguage(String schemaLanguage) {
        this.setSchemaLanguage(schemaLanguage);
        return this;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public MessageValidator useExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.setExpressionEvaluator(expressionEvaluator);
        return this;
    }
}

