/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.lookup;

import java.io.IOException;
import java.net.URI;
import net.javacrumbs.springws.test.expression.ExpressionResolverException;
import net.javacrumbs.springws.test.lookup.AbstractResourceLookup;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessage;
import org.w3c.dom.Document;

public class ExpressionBasedResourceLookup
extends AbstractResourceLookup {
    private String[] resourceExpressions;

    public Resource lookupResource(URI uri, WebServiceMessage message) throws IOException {
        if (this.resourceExpressions != null) {
            Document document = this.loadDocument(message);
            for (String resourceExpression : this.resourceExpressions) {
                try {
                    Resource resultResource = this.findResourceForExpression(resourceExpression, uri, document);
                    if (resultResource != null) {
                        this.logger.debug((Object)("Found resource " + resultResource));
                        return this.processResource(uri, message, resultResource);
                    }
                }
                catch (ExpressionResolverException e) {
                    this.logger.warn((Object)("Resolution of expression \"" + resourceExpression + "\" failed."), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected Resource findResourceForExpression(String xpath, URI uri, Document document) {
        String resourcePath = this.evaluateExpression(xpath, uri, document);
        this.logger.debug((Object)("Looking for resource \"" + resourcePath + "\""));
        Resource resultResource = this.getResourceLoader().getResource(resourcePath);
        resultResource = resultResource.exists() ? resultResource : null;
        return resultResource;
    }

    public String[] getResourceExpressions() {
        return this.resourceExpressions;
    }

    public void setResourceExpressions(String ... resourceExpressions) {
        this.resourceExpressions = resourceExpressions;
    }
}

